/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.oracle.deploy.update.UpdateCheck;
import com.oracle.deploy.update.UpdateCheckListener;
import com.oracle.deploy.update.UpdateInfo;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.panel.ControlPanel;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;

public class MacUpdatePanel
extends JPanel
implements ActionListener {
    private static final String updateImage = "com/sun/deploy/resources/image/JavaProgBarInd80x80.gif";
    private JPanel updateStatusPanel;
    private JLabel progressCaption;
    private JPanel progressPanel;
    private JTextArea headlineLabel;
    private JLabel subHeadLabel;
    private JButton updateBtn;
    private JTextArea detailsTextArea;
    private JCheckBox autoUpdateChBox;
    private JTextArea lastUpdateTimeLabel;
    private boolean javaUpdateEnabled = false;
    private boolean autoUpdateCheck = false;
    private String jcontrolPath;

    MacUpdatePanel() {
        Platform.get().onLoad(this);
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.progressPanel = new JPanel();
        springLayout.putConstraint("North", (Component)this.progressPanel, 0, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.progressPanel, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)this.progressPanel, 0, "East", (Component)this);
        this.add(this.progressPanel);
        ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource(updateImage));
        JLabel jLabel = new JLabel(imageIcon, 0);
        jLabel.setHorizontalAlignment(0);
        this.progressCaption = new JLabel(" ");
        this.progressCaption.setHorizontalAlignment(0);
        SpringLayout springLayout2 = new SpringLayout();
        springLayout2.putConstraint("North", (Component)this.progressCaption, 0, "South", (Component)jLabel);
        springLayout2.putConstraint("South", (Component)this.progressCaption, -20, "South", (Component)this.progressPanel);
        springLayout2.putConstraint("North", (Component)jLabel, 10, "North", (Component)this.progressPanel);
        springLayout2.putConstraint("West", (Component)this.progressCaption, 0, "West", (Component)this.progressPanel);
        springLayout2.putConstraint("East", (Component)this.progressCaption, 0, "East", (Component)this.progressPanel);
        springLayout2.putConstraint("West", (Component)jLabel, 0, "West", (Component)this.progressPanel);
        springLayout2.putConstraint("East", (Component)jLabel, 0, "East", (Component)this.progressPanel);
        this.progressPanel.setLayout(springLayout2);
        this.progressPanel.add(jLabel);
        this.progressPanel.add(this.progressCaption);
        this.updateStatusPanel = new JPanel();
        this.updateStatusPanel.setVisible(false);
        springLayout.putConstraint("North", (Component)this.updateStatusPanel, 0, "North", (Component)this);
        springLayout.putConstraint("West", (Component)this.updateStatusPanel, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)this.updateStatusPanel, 0, "East", (Component)this);
        this.add(this.updateStatusPanel);
        SpringLayout springLayout3 = new SpringLayout();
        this.updateStatusPanel.setLayout(springLayout3);
        this.headlineLabel = new JTextArea();
        this.headlineLabel.setEditable(false);
        this.headlineLabel.setRows(2);
        this.headlineLabel.setWrapStyleWord(true);
        this.headlineLabel.setLineWrap(true);
        Font font = this.headlineLabel.getFont().deriveFont(1);
        this.headlineLabel.setFont(font);
        springLayout3.putConstraint("North", (Component)this.headlineLabel, 15, "North", (Component)this.updateStatusPanel);
        springLayout3.putConstraint("West", (Component)this.headlineLabel, 18, "West", (Component)this.updateStatusPanel);
        springLayout3.putConstraint("East", (Component)this.headlineLabel, -18, "East", (Component)this.updateStatusPanel);
        this.updateStatusPanel.add(this.headlineLabel);
        this.subHeadLabel = new JLabel();
        springLayout3.putConstraint("North", (Component)this.subHeadLabel, 5, "South", (Component)this.headlineLabel);
        springLayout3.putConstraint("West", (Component)this.subHeadLabel, 0, "West", (Component)this.headlineLabel);
        springLayout3.putConstraint("East", (Component)this.subHeadLabel, 0, "East", (Component)this.headlineLabel);
        this.updateStatusPanel.add(this.subHeadLabel);
        this.detailsTextArea = new JTextArea();
        this.detailsTextArea.setEditable(false);
        this.detailsTextArea.setRows(4);
        this.detailsTextArea.setWrapStyleWord(true);
        this.detailsTextArea.setLineWrap(true);
        springLayout3.putConstraint("North", (Component)this.detailsTextArea, 10, "South", (Component)this.subHeadLabel);
        springLayout3.putConstraint("West", (Component)this.detailsTextArea, 0, "West", (Component)this.subHeadLabel);
        springLayout3.putConstraint("East", (Component)this.detailsTextArea, 0, "East", (Component)this.subHeadLabel);
        this.updateStatusPanel.add(this.detailsTextArea);
        this.updateBtn = new JButton(this.getMessage("update.macosx.update.button"));
        this.updateBtn.addActionListener(this);
        springLayout3.putConstraint("South", (Component)this.updateBtn, -10, "South", (Component)this.updateStatusPanel);
        springLayout3.putConstraint("East", (Component)this.updateBtn, -10, "East", (Component)this.updateStatusPanel);
        this.updateStatusPanel.add(this.updateBtn);
        JPanel jPanel = new JPanel();
        springLayout.putConstraint("South", (Component)this.progressPanel, 0, "North", (Component)jPanel);
        springLayout.putConstraint("South", (Component)this.updateStatusPanel, 0, "North", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jPanel, -120, "South", (Component)this);
        springLayout.putConstraint("West", (Component)jPanel, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)jPanel, 0, "South", (Component)this);
        springLayout.putConstraint("East", (Component)jPanel, 0, "East", (Component)this);
        this.add(jPanel);
        SpringLayout springLayout4 = new SpringLayout();
        jPanel.setLayout(springLayout4);
        this.autoUpdateCheck = Config.getBooleanProperty("deployment.macosx.check.update");
        this.autoUpdateChBox = new JCheckBox(this.getMessage("autoupdatecheck.caption"));
        this.autoUpdateChBox.addActionListener(this);
        this.autoUpdateChBox.setSelected(this.autoUpdateCheck);
        springLayout4.putConstraint("North", (Component)this.autoUpdateChBox, 0, "North", (Component)jPanel);
        springLayout4.putConstraint("West", (Component)this.autoUpdateChBox, 8, "West", (Component)jPanel);
        springLayout4.putConstraint("East", (Component)this.autoUpdateChBox, 0, "East", (Component)jPanel);
        jPanel.add(this.autoUpdateChBox);
        this.lastUpdateTimeLabel = new JTextArea(this.getMessage("update.macosx.autoupdate.enabled"));
        this.lastUpdateTimeLabel.setEditable(false);
        this.lastUpdateTimeLabel.setLineWrap(true);
        this.lastUpdateTimeLabel.setWrapStyleWord(true);
        this.lastUpdateTimeLabel.setRows(2);
        springLayout4.putConstraint("North", (Component)this.lastUpdateTimeLabel, 6, "South", (Component)this.autoUpdateChBox);
        springLayout4.putConstraint("West", (Component)this.lastUpdateTimeLabel, 8, "West", (Component)this.autoUpdateChBox);
        springLayout4.putConstraint("East", (Component)this.lastUpdateTimeLabel, 10, "East", (Component)this.autoUpdateChBox);
        jPanel.add(this.lastUpdateTimeLabel);
        this.refreshAutoUpdatePanel();
        this.setOpacityOfAllComponents(this);
    }

    final void setOpacityOfAllComponents(JComponent jComponent) {
        if (jComponent == null || jComponent instanceof JScrollPane) {
            return;
        }
        jComponent.setOpaque(false);
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof JComponent)) continue;
            this.setOpacityOfAllComponents((JComponent)component);
        }
    }

    void showProgressPanel(int n) {
        if (n == 2) {
            this.progressCaption.setText(ResourceManager.getString("update.macosx.connecting"));
        } else {
            this.progressCaption.setText(ResourceManager.getString("update.macosx.connected"));
        }
        this.updateStatusPanel.setVisible(false);
        this.progressPanel.setVisible(true);
    }

    void showUpdateInformation(UpdateInfo updateInfo) {
        Object object;
        this.progressPanel.setVisible(false);
        String string = Config.getJavaVersion();
        String[] stringArray = string.split("\\.");
        String string2 = null;
        Object object2 = null;
        if (stringArray.length >= 1) {
            string2 = stringArray[1];
        }
        if (stringArray.length >= 2 && ((String[])(object = stringArray[2].split("[_-]"))).length >= 2) {
            try {
                int n = Integer.parseInt((String)object[1]);
                object2 = object[1];
            }
            catch (NumberFormatException numberFormatException) {
                Trace.ignoredException(numberFormatException);
            }
        }
        if (updateInfo == null) {
            this.headlineLabel.setText(ResourceManager.getString("update.macosx.up-to-date.head"));
            object = object2 != null && ((String)object2).length() > 0 ? ResourceManager.getString("update.macosx.up-to-date.sub", string2, (String)object2) : ResourceManager.getString("update.macosx.up-to-date.sub.noupdate", string2);
            this.subHeadLabel.setText((String)object);
            this.updateBtn.setVisible(false);
        } else {
            String string3;
            String string4;
            object = Integer.valueOf(updateInfo.mSize);
            String string5 = ResourceManager.getString("update.macosx.available.sub", updateInfo.mVersion, (Integer)object / 1024 / 1024);
            this.subHeadLabel.setText(string5);
            if (updateInfo.mType == null) {
                string4 = ResourceManager.getString("update.macosx.critical.available");
                string3 = object2 != null ? ResourceManager.getString("update.macosx.critical.detail", string2, (String)object2) : ResourceManager.getString("update.macosx.critical.detail.noupdate", string2);
            } else {
                string4 = ResourceManager.getString("update.macosx.optional.available");
                string3 = object2 != null ? ResourceManager.getString("update.macosx.optional.detail", string2, (String)object2) : ResourceManager.getString("update.macosx.optional.detail.noupdate", string2);
            }
            this.headlineLabel.setText(string4);
            this.detailsTextArea.setText(string3);
            this.updateBtn.setVisible(true);
            this.updateBtn.setText(this.getMessage("update.macosx.update.button"));
            ControlPanel.showPanel(this);
        }
        this.updateStatusPanel.setVisible(true);
    }

    void showUpdateFailed() {
        this.progressPanel.setVisible(false);
        this.headlineLabel.setText(ResourceManager.getMessage("update.macosx.failed.head"));
        this.subHeadLabel.setText(ResourceManager.getMessage("update.macosx.failed.sub"));
        this.updateBtn.setText(ResourceManager.getMessage("update.macosx.failed.button"));
        this.updateBtn.setVisible(true);
        this.detailsTextArea.setText("");
        this.updateStatusPanel.setVisible(true);
    }

    void startUpdateCheck() {
        final UpdateCheck updateCheck = UpdateCheck.getInstance();
        updateCheck.startUpdateCheck(new UpdateCheckListener(){

            public void updateCheckStateChanged(int n) {
                switch (n) {
                    case 2: 
                    case 3: {
                        MacUpdatePanel.this.showProgressPanel(n);
                        break;
                    }
                    case 5: {
                        UpdateInfo updateInfo = updateCheck.getUpdateInfo();
                        MacUpdatePanel.this.showUpdateInformation(updateInfo);
                        break;
                    }
                    case 4: {
                        MacUpdatePanel.this.showUpdateFailed();
                        break;
                    }
                    case 6: {
                        MacUpdatePanel.this.refreshAutoUpdatePanel();
                    }
                }
            }
        });
    }

    private void refreshAutoUpdatePanel() {
        String string;
        UpdateCheck updateCheck = UpdateCheck.getInstance();
        Calendar calendar = updateCheck.getLastUpdateCheck();
        if (calendar != null) {
            DateFormat dateFormat = DateFormat.getDateInstance(3);
            DateFormat dateFormat2 = DateFormat.getTimeInstance(3);
            string = ResourceManager.getString("update.lastrun.text", dateFormat2.format(calendar.getTime()), dateFormat.format(calendar.getTime()));
        } else {
            string = ResourceManager.getString("update.macosx.last.checked.never");
        }
        this.lastUpdateTimeLabel.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.updateBtn) {
                if (this.updateBtn.getText().equals(this.getMessage("update.macosx.failed.button"))) {
                    this.startUpdateCheck();
                } else {
                    String[] stringArray = new String[]{this.jcontrolPath};
                    Platform.get().getAutoUpdater().checkForUpdate(stringArray, true);
                }
            } else if (actionEvent.getSource() == this.autoUpdateChBox) {
                this.refreshAutoUpdatePanel();
                this.setAutoUpdateCheck(this.autoUpdateChBox.isSelected());
            }
        }
        catch (Exception exception) {
            ToolkitStore.getUI().showExceptionDialog(null, null, exception, null, null, null, null);
        }
    }

    public void setAutoUpdateCheck(boolean bl) {
        int n = 1;
        if (!bl && bl != this.autoUpdateCheck) {
            String string = ResourceManager.getMessage("update.autoupdate.disable.neverCheck");
            String string2 = ResourceManager.getMessage("update.warning");
            String string3 = ResourceManager.getMessage("update.autoupdate.disable.message");
            String string4 = ResourceManager.getMessage("update.autoupdate.disable.info");
            String string5 = ResourceManager.getMessage("update.autoupdate.disable.regularCheck");
            n = ToolkitStore.getUI().showMessageDialog(null, null, 2, string2, string3, string4, null, string5, string, null);
        }
        if (n == 0) {
            this.autoUpdateChBox.setSelected(true);
            bl = true;
        }
        this.autoUpdateCheck = bl;
        Config.setBooleanProperty("deployment.macosx.check.update", this.autoUpdateCheck);
        ControlPanel.propertyHasChanged();
    }

    void resetAutoUpdateCheckbox(boolean bl) {
        this.autoUpdateCheck = bl;
        this.autoUpdateChBox.setSelected(bl);
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public void enableJavaUpdate(boolean bl) {
        this.javaUpdateEnabled = bl;
    }

    void setJControlPath(String string) {
        this.jcontrolPath = string;
    }

    public boolean isJavaUpdateEnabled() {
        return this.javaUpdateEnabled;
    }
}

