/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.DecisionTime;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ValidationState;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.security.ruleset.ExceptionRule;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.SessionProperties;
import com.sun.deploy.util.SessionState;
import com.sun.deploy.util.URLUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLException;

public class SandboxSecurity {
    protected static final String FILENAME = "sandbox.properties";
    private static SessionProperties sessionProps = new SessionProperties("sandbox.properties");
    private static final Set verifiedHttpsConnection;
    private static Object lock;
    private static Object blockLock;
    private static String blockKey;
    private static String masthead;
    private static String runKey;
    private static String cancel;
    private static String securityInfoDescription;
    private static String securityInfoCanel;
    private static String securityInfoTrusted;
    private static String securityRisk;

    public static void addConnectPermission(PermissionCollection permissionCollection, URL uRL) {
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        int n = URLUtil.getPort(uRL);
        if ("https".equalsIgnoreCase(string) && !SandboxSecurity.verifyHttpsConnection(uRL)) {
            return;
        }
        if (Config.isJavaVersionAtLeast18()) {
            permissionCollection.add(new URLPermission(string + "://" + string2 + ":" + n + "/-"));
            permissionCollection.add(new URLPermission(string + "://" + string2 + ":" + n));
        } else {
            permissionCollection.add(new SocketPermission(string2, "connect,accept"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyHttpsConnection(URL uRL) {
        String string = uRL.getHost();
        int n = URLUtil.getPort(uRL);
        String string2 = "https://" + string + ":" + n;
        Object object = lock;
        synchronized (object) {
            if (verifiedHttpsConnection.contains(string2)) {
                return true;
            }
        }
        try {
            object = (HttpURLConnection)uRL.openConnection();
            ((HttpURLConnection)object).getResponseCode();
        }
        catch (SSLException sSLException) {
            Trace.ignored(sSLException);
            return false;
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
            return false;
        }
        object = lock;
        synchronized (object) {
            verifiedHttpsConnection.add(string2);
        }
        return true;
    }

    public static void resetAcceptedVersion(LocalApplicationProperties localApplicationProperties, AppInfo appInfo) {
        if (localApplicationProperties != null) {
            DecisionTime.reset(localApplicationProperties);
            String string = TrustDecider.getLocString(localApplicationProperties.getLocation(), appInfo);
            if (string != null) {
                sessionProps.remove(string);
            }
        }
    }

    public static void isPermissionGranted(CodeSource codeSource, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, Preloader preloader) {
        Config.getHooks().trackUsage(appInfo, deploymentRuleSet);
        if (deploymentRuleSet.isRuleBlock()) {
            SandboxSecurity.showBlockedDialog(appInfo, deploymentRuleSet.getBlockString(), "deployment.blocked.by.rule", deploymentRuleSet.getException(), codeSource);
        }
        if (codeSource != null && codeSource.getCertificates() != null) {
            try {
                DeployManifestChecker.verify(deploymentRuleSet, codeSource.getLocation(), false, appInfo);
            }
            catch (SecurityException securityException) {
                Trace.ignored(securityException);
                SandboxSecurity.showBlockedDialog(appInfo, null, null, securityException, codeSource);
            }
            if (Config.isJavaVersionAtLeast16()) {
                SandboxSecurity.checkSignedSandboxSecurity(codeSource, appInfo, deploymentRuleSet, preloader);
            } else {
                Trace.println("Jar has Certs, treating sandbox app as unsigned due to running old JRE", TraceLevel.SECURITY);
                SandboxSecurity.checkUnsignedSandboxSecurity(appInfo, codeSource, deploymentRuleSet);
            }
        } else {
            SandboxSecurity.checkUnsignedSandboxSecurity(appInfo, codeSource, deploymentRuleSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void checkSignedSandboxSecurity(CodeSource codeSource, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, Preloader preloader) {
        block25: {
            block26: {
                String string = null;
                try {
                    try {
                        List list;
                        TrustDecider.grabDeployLock();
                        ValidationState validationState = new ValidationState();
                        Certificate[] certificateArray = null;
                        X509Certificate x509Certificate = null;
                        Certificate[] certificateArray2 = codeSource.getCertificates();
                        boolean bl = false;
                        try {
                            TrustDecider.ensureBasicStoresLoaded();
                            list = TrustDecider.breakDownMultiSignerChains(certificateArray2);
                        }
                        catch (Exception exception) {
                            BadCertificateDialog.showDialog(codeSource, appInfo, exception);
                            throw new SecurityException(exception.getMessage(), exception);
                        }
                        Iterator iterator = list.iterator();
                        if (iterator.hasNext()) {
                            List list2 = (List)iterator.next();
                            certificateArray = list2.toArray(new X509Certificate[0]);
                            try {
                                x509Certificate = certificateArray[0];
                                boolean bl2 = deploymentRuleSet.isRevocationCheckBestEffort();
                                boolean bl3 = deploymentRuleSet.isRuleRun();
                                validationState = TrustDecider.getValidationState((X509Certificate[])certificateArray, codeSource, 0, true, bl2, bl3, appInfo);
                                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties(appInfo.getLapURL());
                                if (localApplicationProperties != null) {
                                    localApplicationProperties.storeMainPublisherAndTitle(validationState.getPublisher(), appInfo.getDisplayTitle());
                                }
                                bl = validationState.rootCAValid;
                                if (validationState.trustDecision == 0L) {
                                    String string2 = codeSource.getLocation() != null ? codeSource.getLocation().toString() : null;
                                    TrustDecider.notifyOnUserDeclined(preloader, string2);
                                } else if (bl) {
                                    if (deploymentRuleSet.isCaSignedNever()) {
                                        string = "deployment.run.sandbox.signed.never.text";
                                    }
                                } else if (SecurityBaseline.isExpired() && deploymentRuleSet.isSSVModeNever()) {
                                    string = "deployment.ssv2.mode.never.text";
                                } else if (deploymentRuleSet.isSelfSignedNever()) {
                                    string = "deployment.run.sandbox.selfsigned.never.text";
                                }
                                if (string == null && !validationState.timeValid && deploymentRuleSet.isExpiredBlocked()) {
                                    string = "deployment.block.expired.text";
                                }
                                if (string == null && !bl && SandboxSecurity.isLocalApp(appInfo) && deploymentRuleSet.isRunLocalAppletsNever()) {
                                    string = "deployment.local.applet.never.text";
                                }
                            }
                            catch (Exception exception) {
                                BadCertificateDialog.showDialog(codeSource, appInfo, exception);
                                throw new SecurityException(exception.getMessage(), exception);
                            }
                        }
                        if (string != null) {
                            SandboxSecurity.showBlockedDialog(appInfo, null, string, null, codeSource);
                        }
                        if (deploymentRuleSet.isRuleRun()) {
                            validationState.trustDecision = 1L;
                        }
                        if (validationState.trustDecision != 2L) break block25;
                        if (DecisionTime.withinTime(codeSource.getLocation(), appInfo, x509Certificate, "ssv.decision.sandbox.time")) {
                            validationState.trustDecision = 1L;
                            Object var18_21 = null;
                            break block26;
                        }
                        int n = SandboxSecurity.showSandboxDialog(codeSource.getLocation(), appInfo, deploymentRuleSet, (X509Certificate[])certificateArray, !validationState.timeValid, !validationState.rootCAValid, validationState.revStatusUnknown);
                        TrustDecider.recordSandboxAnswer(certificateArray, codeSource, validationState, preloader, n, appInfo);
                        if (n == 0) {
                            DecisionTime.setTime(codeSource.getLocation(), appInfo, x509Certificate, "ssv.decision.sandbox.time");
                        }
                        break block25;
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.ignored(interruptedException);
                        SandboxSecurity.showBlockedDialog(appInfo, null, "deployment.run.sandbox.signed.error", interruptedException, codeSource);
                        Object var18_23 = null;
                        TrustDecider.releaseDeployLock();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var18_24 = null;
                    TrustDecider.releaseDeployLock();
                    throw throwable;
                }
            }
            TrustDecider.releaseDeployLock();
            return;
        }
        Object var18_22 = null;
        TrustDecider.releaseDeployLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkUnsignedSandboxSecurity(AppInfo appInfo, CodeSource codeSource, DeploymentRuleSet deploymentRuleSet) {
        if (!Environment.isWebJava()) {
            return;
        }
        if (deploymentRuleSet.isRuleRun()) {
            return;
        }
        SessionProperties sessionProperties = sessionProps;
        synchronized (sessionProperties) {
            if (SecurityBaseline.isExpired()) {
                SandboxSecurity.checkRunExpired(appInfo, deploymentRuleSet);
            } else if (SandboxSecurity.isLocalApp(appInfo)) {
                SandboxSecurity.checkRunLocal(appInfo, codeSource, deploymentRuleSet);
            } else {
                SandboxSecurity.checkRunUntrusted(appInfo, codeSource, deploymentRuleSet);
            }
            sessionProps.setProperty(TrustDecider.getLocString(appInfo.getLapURL(), appInfo), "true");
        }
    }

    private static void checkRunUntrusted(AppInfo appInfo, CodeSource codeSource, DeploymentRuleSet deploymentRuleSet) {
        if (deploymentRuleSet.isRunUntrustedNever()) {
            SandboxSecurity.showBlockedDialog(appInfo, null, "deployment.run.untrusted.never.text", deploymentRuleSet.getException(), null);
        }
        if (sessionProps.getProperty(TrustDecider.getLocString(appInfo.getLapURL(), appInfo)) != null) {
            return;
        }
        if (DecisionTime.withinTime(codeSource.getLocation(), appInfo, null, "ssv.decision.unsigned.time")) {
            return;
        }
        SandboxSecurity.showUntrustedDialog(appInfo, deploymentRuleSet);
        DecisionTime.setTime(codeSource.getLocation(), appInfo, null, "ssv.decision.unsigned.time");
    }

    private static void checkRunExpired(AppInfo appInfo, DeploymentRuleSet deploymentRuleSet) {
        if (deploymentRuleSet.isSSVModeNever()) {
            SandboxSecurity.showBlockedDialog(appInfo, null, "deployment.ssv2.mode.never.text", deploymentRuleSet.getException(), null);
        }
        if (sessionProps.getProperty(TrustDecider.getLocString(appInfo.getLapURL(), appInfo)) != null) {
            return;
        }
        SandboxSecurity.showExpiredDialog(appInfo, deploymentRuleSet);
    }

    private static void checkRunLocal(AppInfo appInfo, CodeSource codeSource, DeploymentRuleSet deploymentRuleSet) {
        if (deploymentRuleSet.isRunLocalAppletsNever()) {
            SandboxSecurity.showBlockedDialog(appInfo, null, "deployment.local.applet.never.text", deploymentRuleSet.getException(), null);
        }
        if (deploymentRuleSet.isRunUntrustedNever()) {
            SandboxSecurity.showBlockedDialog(appInfo, null, "deployment.run.untrusted.never.text", deploymentRuleSet.getException(), null);
        }
        if (sessionProps.getProperty(TrustDecider.getLocString(appInfo.getLapURL(), appInfo)) != null) {
            return;
        }
        if (DecisionTime.withinTime(codeSource.getLocation(), appInfo, null, "ssv.decision.unsigned.time")) {
            return;
        }
        SandboxSecurity.showUntrustedDialog(appInfo, deploymentRuleSet);
        DecisionTime.setTime(codeSource.getLocation(), appInfo, null, "ssv.decision.unsigned.time");
    }

    private static boolean isLocalApp(AppInfo appInfo) {
        URL uRL = appInfo.getFrom();
        return uRL != null && uRL.getProtocol().equals("file");
    }

    private static LocalApplicationProperties getLap(AppInfo appInfo) {
        return Cache.getLocalApplicationProperties(appInfo.getLapURL());
    }

    public static boolean showUntrustedDialog(AppInfo appInfo, DeploymentRuleSet deploymentRuleSet) {
        String string = "deployment.ssv.title";
        String string2 = "deployment.ssv.masthead";
        String string3 = "deployment.ssv.untrusted.main";
        String string4 = "deployment.ssv.localapp.main";
        String string5 = appInfo.isMultiHost() ? "deployment.ssv.location.multihost" : "deployment.ssv.location";
        Object var7_7 = null;
        String string6 = "deployment.ssv.prompt";
        String string7 = null;
        String string8 = null;
        if (deploymentRuleSet.isRunUntrustedMultiClick()) {
            string7 = "deployment.ssv.multi.prompt";
            string8 = "deployment.ssv.multi.text";
        }
        String string9 = "deployment.ssv.run";
        String string10 = null;
        String string11 = "deployment.ssv.cancel";
        URL uRL = null;
        String string12 = SandboxSecurity.isLocalApp(appInfo) ? string4 : string3;
        LocalApplicationProperties localApplicationProperties = ResourceProvider.get().getLocalApplicationProperties(appInfo.getLapURL(), null, true);
        if (localApplicationProperties != null) {
            localApplicationProperties.storeMainPublisherAndTitle(null, null);
        }
        String string13 = null;
        if (deploymentRuleSet instanceof ExceptionRule) {
            appInfo.setFutureBlockUnsigned(false);
        }
        UIFactory uIFactory = ToolkitStore.getUI();
        int n = uIFactory.showSSV3Dialog(null, appInfo, 2, string, string2, string12, string5, string6, string7, string8, string9, string10, string11, string13, uRL);
        if (n == 2) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        throw new SecurityException("User declined to run unsigned sandbox app", null);
    }

    private static boolean showExpiredDialog(AppInfo appInfo, DeploymentRuleSet deploymentRuleSet) {
        String string = "deployment.ssv.title";
        String string2 = "deployment.ssv.masthead";
        String string3 = SandboxSecurity.isLocalApp(appInfo) ? "deployment.ssv.expired.localapp.main" : "deployment.ssv.expired.main";
        String string4 = appInfo.isMultiHost() ? "deployment.ssv.location.multihost" : "deployment.ssv.location";
        String string5 = "deployment.ssv.update.prompt";
        String string6 = null;
        String string7 = null;
        if (deploymentRuleSet.isSSVModeMultiClick()) {
            string6 = "deployment.ssv.multi.prompt";
            string7 = "deployment.ssv.multi.text";
        }
        String string8 = "deployment.ssv.run";
        String string9 = "deployment.ssv.update";
        String string10 = "deployment.ssv.cancel";
        URL uRL = null;
        try {
            uRL = new URL("http://java.com/download");
        }
        catch (Exception exception) {
            // empty catch block
        }
        UIFactory uIFactory = ToolkitStore.getUI();
        ToolkitStore.getUI();
        int n = uIFactory.showSSV3Dialog(null, appInfo, 2, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, null, uRL);
        ToolkitStore.getUI();
        if (n == 2) {
            return true;
        }
        ToolkitStore.getUI();
        if (n == 0) {
            return false;
        }
        throw new SecurityException("User declined to run on insecure or expired JRE", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showBlockedDialog(AppInfo appInfo, String string, String string2, Exception exception, CodeSource codeSource) {
        String string3 = null;
        String string4 = ResourceManager.getString("deployment.blocked.masthead");
        if (string != null) {
            string3 = string;
            string4 = ResourceManager.getString("deployment.blocked.ruleset.masthead");
        } else if (string2 != null) {
            string3 = ResourceManager.getString(string2);
        }
        Trace.println(string3, TraceLevel.BASIC);
        Object object = blockLock;
        synchronized (object) {
            String string5;
            String string6 = null;
            String string7 = ResourceManager.getString("deployment.blocked.title");
            if (string3 == null) {
                string3 = ResourceManager.getString("deployment.blocked.text");
            }
            String string8 = ResourceManager.getString("common.ok_btn");
            String string9 = ResourceManager.getString("common.detail.button");
            URL uRL = appInfo.getLapURL();
            String string10 = string5 = uRL == null ? null : uRL.toString();
            if (string5 == null || !string5.equals(blockKey)) {
                appInfo.setVendor(null);
                ToolkitStore.getUI().showPublisherInfo(null, appInfo, string7, string4, string3, string8, string9, string6);
            }
            blockKey = string5;
        }
        throw new BlockedException(string3, (Throwable)exception, codeSource, appInfo);
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private static int showSandboxDialog(URL uRL, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, X509Certificate[] x509CertificateArray, boolean bl, boolean bl2, boolean bl3) {
        String string;
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(securityInfoDescription);
        arrayList2.add(securityInfoCanel);
        String string2 = CertUtils.extractSubjectAliasName(x509CertificateArray[0]);
        if (bl2) {
            arrayList = new ArrayList<String>();
            arrayList.add(securityRisk);
            string = SandboxSecurity.getMessage("security.dialog.notverified.subject");
            arrayList2.add(SandboxSecurity.getMessage("security.info.publisher.unknown").replaceAll(string, string.toUpperCase()));
            arrayList2.add(SandboxSecurity.getMessage("sandbox.security.info.selfsigned.state"));
            string2 = string.toUpperCase();
        } else if (bl) {
            arrayList = new ArrayList();
            arrayList.add(SandboxSecurity.combineMessage(securityRisk, SandboxSecurity.getMessage("sandbox.security.dialog.expired.signed.label")));
            arrayList2.add(securityInfoTrusted);
            arrayList2.add(SandboxSecurity.getMessage("sandbox.security.info.expired.state"));
        } else if (bl3) {
            arrayList = new ArrayList();
            arrayList.add(SandboxSecurity.combineMessage(securityRisk, SandboxSecurity.getMessage("sandbox.security.info.selfsigned.revocation.unknown")));
            arrayList2.add(securityInfoTrusted);
            arrayList2.add(SandboxSecurity.getMessage("sandbox.security.info.revocation.unsure.state"));
        } else {
            arrayList2.add(securityInfoTrusted);
            arrayList2.add(SandboxSecurity.getMessage("sandbox.security.info.trusted.state"));
        }
        if (arrayList != null) {
            arrayList.addAll(arrayList2);
        }
        string = arrayList == null ? SandboxSecurity.getMessage("security.dialog.valid.caption") : SandboxSecurity.getMessage("security.dialog.caption");
        boolean bl4 = false;
        boolean bl5 = false;
        if (!bl2 && !bl3) {
            if (appInfo.isMultiHost()) {
                if (DeployManifestChecker.verifyApplicationLibraryAllowableCodebase(uRL, appInfo)) {
                    bl4 = true;
                    bl5 = true;
                }
            } else {
                bl4 = true;
            }
        }
        if (deploymentRuleSet instanceof ExceptionRule) {
            appInfo.setFutureBlockSelfsigned(false);
            appInfo.setFutureBlockPermission(false);
        }
        DeployManifestChecker.printWarningsIfRequired(uRL, appInfo);
        return ToolkitStore.getUI().showSandboxSecurityDialog(bl5 ? AppInfo.createSingleHostAppInfo(appInfo) : new AppInfo(appInfo), string, masthead, string2, uRL, bl4, false, runKey, cancel, arrayList != null ? arrayList.toArray(new String[arrayList.size()]) : null, arrayList == null ? arrayList2.toArray(new String[arrayList2.size()]) : null, true, x509CertificateArray, 0, x509CertificateArray.length, bl2 || bl || bl3, bl2);
    }

    private static String combineMessage(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("\n\n");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    static {
        SessionState.register(sessionProps);
        verifiedHttpsConnection = new HashSet();
        lock = new Object();
        blockLock = new Object();
        blockKey = null;
        masthead = SandboxSecurity.getMessage("deployment.ssv.masthead");
        runKey = "deployment.ssv.run";
        cancel = SandboxSecurity.getMessage("deployment.ssv.cancel");
        securityInfoDescription = SandboxSecurity.getMessage("sandbox.security.info.description");
        securityInfoCanel = SandboxSecurity.getMessage("sandbox.security.info.cancel");
        securityInfoTrusted = SandboxSecurity.getMessage("sandbox.security.info.trusted");
        securityRisk = SandboxSecurity.getMessage("sandbox.security.info.risk");
    }
}

