/*
 * Decompiled with CFR 0.152.
 */
package skygge;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class Sentence {
    private int id;
    private String name;
    private String url;
    private List<Map.Entry<String, String>> information;

    public Sentence(JSONObject sentenceData) {
        this.id = (Integer)sentenceData.get("id");
        this.name = (String)sentenceData.get("name");
        this.url = (String)sentenceData.get("url");
        this.information = new ArrayList<Map.Entry<String, String>>();
        JSONArray sentenceInformation = (JSONArray)sentenceData.get("information");
        int i = 0;
        while (this.information.size() < sentenceInformation.size()) {
            JSONObject infoEntry = this.getInfoEntryById(sentenceInformation, i);
            if (infoEntry != null) {
                String title = (String)infoEntry.get("title");
                String data = (String)infoEntry.get("data");
                this.information.add(new AbstractMap.SimpleEntry<String, String>(title, data));
            }
            ++i;
        }
    }

    private JSONObject getInfoEntryById(JSONArray sentenceInformation, int id) {
        for (int i = 0; i < sentenceInformation.size(); ++i) {
            JSONObject infoEntry = (JSONObject)sentenceInformation.get(i);
            int entryId = (Integer)infoEntry.get("id");
            if (id != entryId) continue;
            return infoEntry;
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public List<Map.Entry<String, String>> getInformation() {
        return this.information;
    }

    public String getInformationEntry(String title) {
        for (int i = 0; i < this.information.size(); ++i) {
            Map.Entry<String, String> e = this.information.get(i);
            if (!e.getKey().equals(title)) continue;
            return e.getValue();
        }
        return null;
    }

    public String toString() {
        return this.getId() + ": " + this.getInformationEntry("Chinese (simp)");
    }
}

