/*
 * Decompiled with CFR 0.152.
 */
package skygge;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JOptionPane;
import skygge.Utils;

public class SoundDeviceManager
extends Thread {
    private static SoundDeviceManager instance = null;
    private Object stateLock;
    private State currentState;
    private State nextState = State.IDLE;
    private byte[] buffer;
    private int BUFFER_SIZE = 100;
    private byte[] audioDataToBePlayed;
    private AudioInputStream audioInputStream;
    private SourceDataLine sourceDataLine;
    private TargetDataLine targetDataLine;
    private ByteArrayOutputStream recordStream;
    private byte[] recordedAudioData;

    protected SoundDeviceManager() {
        this.currentState = State.IDLE;
        this.stateLock = new Object();
    }

    public static SoundDeviceManager getInstance() {
        if (instance == null) {
            instance = new SoundDeviceManager();
            instance.start();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startPlaying(byte[] audioDataToBePlayed) {
        this.stopEverything();
        Object object = this.stateLock;
        synchronized (object) {
            this.audioDataToBePlayed = audioDataToBePlayed;
            this.nextState = State.PLAYING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startLooping(byte[] audioDataToBePlayed) {
        this.stopEverything();
        Object object = this.stateLock;
        synchronized (object) {
            this.audioDataToBePlayed = audioDataToBePlayed;
            this.nextState = State.LOOPING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startRecording() {
        this.stopEverything();
        Object object = this.stateLock;
        synchronized (object) {
            this.nextState = State.RECORDING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopEverything() {
        State currentStateCopy;
        Object object = this.stateLock;
        synchronized (object) {
            this.nextState = State.IDLE;
        }
        do {
            Object object2 = this.stateLock;
            synchronized (object2) {
                currentStateCopy = this.currentState;
                if (this.nextState != State.IDLE) {
                    JOptionPane.showMessageDialog(null, "Synchronization error.", "Sync Error", 0);
                    this.currentState = this.nextState = State.IDLE;
                }
            }
            Thread.yield();
        } while (currentStateCopy != State.IDLE);
    }

    public synchronized byte[] getRecordedAudioData() {
        return this.recordedAudioData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object = this.stateLock;
            synchronized (object) {
                block2 : switch (this.currentState) {
                    case IDLE: {
                        switch (this.nextState) {
                            case PLAYING: {
                                this.setUpPlayingObjects();
                                this.currentState = State.PLAYING;
                                break block2;
                            }
                            case LOOPING: {
                                this.setUpPlayingObjects();
                                this.currentState = State.LOOPING;
                                break block2;
                            }
                            case RECORDING: {
                                this.setUpRecordingObjects();
                                this.currentState = State.RECORDING;
                                break block2;
                            }
                        }
                        break;
                    }
                    case PLAYING: {
                        switch (this.nextState) {
                            case PLAYING: {
                                this.play();
                                break block2;
                            }
                            case IDLE: {
                                this.shutDownPlayingObjects();
                                this.currentState = State.IDLE;
                                break block2;
                            }
                        }
                        break;
                    }
                    case LOOPING: {
                        switch (this.nextState) {
                            case LOOPING: {
                                this.loop();
                                break block2;
                            }
                            case IDLE: {
                                this.shutDownPlayingObjects();
                                this.currentState = State.IDLE;
                                break block2;
                            }
                        }
                        break;
                    }
                    case RECORDING: {
                        switch (this.nextState) {
                            case RECORDING: {
                                this.record();
                                break block2;
                            }
                            case IDLE: {
                                this.shutDownRecordingObjects();
                                this.currentState = State.IDLE;
                                break block2;
                            }
                        }
                    }
                }
            }
            Thread.yield();
        }
    }

    private void setUpPlayingObjects() {
        AudioFormat format = Utils.getFormat();
        ByteArrayInputStream input = new ByteArrayInputStream(this.audioDataToBePlayed);
        this.audioInputStream = new AudioInputStream(input, format, this.audioDataToBePlayed.length / format.getFrameSize());
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            this.sourceDataLine.open(format);
            this.sourceDataLine.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unable to set up speakers for playback.", "Audio Error", 0);
            this.currentState = this.nextState = State.IDLE;
        }
        this.buffer = new byte[this.BUFFER_SIZE];
    }

    private void play() {
        try {
            int count = this.audioInputStream.read(this.buffer, 0, this.buffer.length);
            if (count > 0) {
                this.sourceDataLine.write(this.buffer, 0, count);
            } else {
                this.shutDownPlayingObjects();
                this.nextState = this.currentState = State.IDLE;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unable to play audio data.", "Audio Error", 0);
            this.currentState = this.nextState = State.IDLE;
        }
    }

    private void loop() {
        try {
            int count = this.audioInputStream.read(this.buffer, 0, this.buffer.length);
            if (count > 0) {
                this.sourceDataLine.write(this.buffer, 0, count);
            } else {
                this.audioInputStream.reset();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unable to loop audio data.", "Audio Error", 0);
            this.currentState = this.nextState = State.IDLE;
        }
    }

    private void shutDownPlayingObjects() {
        this.sourceDataLine.drain();
        this.sourceDataLine.close();
    }

    private void setUpRecordingObjects() {
        try {
            AudioFormat format = Utils.getFormat();
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
            this.targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            this.targetDataLine.open(format);
            this.targetDataLine.start();
            this.recordStream = new ByteArrayOutputStream();
            this.buffer = new byte[this.BUFFER_SIZE];
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unable to set up microphone for recording. Do you have a working microphone?", "Audio Error", 0);
            this.currentState = this.nextState = State.IDLE;
        }
    }

    private void record() {
        int count = this.targetDataLine.read(this.buffer, 0, this.buffer.length);
        if (count > 0) {
            this.recordStream.write(this.buffer, 0, count);
        } else {
            this.shutDownRecordingObjects();
            this.nextState = this.currentState = State.IDLE;
        }
    }

    private void shutDownRecordingObjects() {
        try {
            this.recordStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.targetDataLine.close();
        this.recordedAudioData = this.recordStream.toByteArray();
    }

    private static enum State {
        IDLE,
        PLAYING,
        LOOPING,
        RECORDING;

    }
}

