/*
 * Decompiled with CFR 0.152.
 */
package skygge.UI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.ParseException;
import skygge.Sentence;
import skygge.SentencePack;
import skygge.UI.SkyggeFrame;
import skygge.Utils;

public class SentenceLibraryFrame
extends JFrame {
    private SkyggeFrame skyggeFrame;
    private List<SentencePack> sentencePacks;
    private final String URL_SENTENCE_DATA = "https://skygge.s3.amazonaws.com/sentence_data.json";
    private JButton cancelButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JButton openButton;
    private JList sentenceList;
    private JList sentencePackList;

    public SentenceLibraryFrame(SkyggeFrame skyggeFrame) {
        this.initComponents();
        this.skyggeFrame = skyggeFrame;
        Utils.setIconOnFrame(this);
        this.sentencePacks = new ArrayList<SentencePack>();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    String sentenceDataString = Utils.loadUrlIntoString("https://skygge.s3.amazonaws.com/sentence_data.json");
                    Object sentenceData = JSONValue.parseStrict(sentenceDataString);
                    JSONObject sentenceDataObject = (JSONObject)sentenceData;
                    JSONObject languagesMap = (JSONObject)sentenceDataObject.get("languages");
                    JSONArray chineseSentencePacksData = (JSONArray)languagesMap.get("Chinese");
                    for (int i = 0; i < chineseSentencePacksData.size(); ++i) {
                        SentenceLibraryFrame.this.sentencePacks.add(new SentencePack((JSONObject)chineseSentencePacksData.get(i)));
                    }
                    DefaultListModel sentencePackListModel = new DefaultListModel();
                    for (int i = 0; i < SentenceLibraryFrame.this.sentencePacks.size(); ++i) {
                        sentencePackListModel.addElement(SentenceLibraryFrame.this.sentencePacks.get(i));
                    }
                    final DefaultListModel sentencePackListModelFinalCopy = sentencePackListModel;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SentenceLibraryFrame.this.sentencePackList.setModel(sentencePackListModelFinalCopy);
                            SentenceLibraryFrame.this.sentencePackList.setSelectedIndex(0);
                            SentenceLibraryFrame.this.sentencePackSelected(0);
                        }
                    });
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "Unable to load sentence library.", "IO Error", 0);
                }
                catch (ParseException e) {
                    JOptionPane.showMessageDialog(null, "Unable to parse sentence library.", "IO Error", 0);
                }
            }
        };
        t.start();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelButton = new JButton();
        this.openButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.sentencePackList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.sentenceList = new JList();
        this.setLocation(new Point(100, 100));
        this.jPanel1.setMinimumSize(new Dimension(178, 70));
        this.jPanel1.setPreferredSize(new Dimension(453, 40));
        this.jPanel1.setLayout(new FlowLayout(2));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SentenceLibraryFrame.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.openButton.setText("Open");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SentenceLibraryFrame.this.openButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.openButton);
        this.getContentPane().add((Component)this.jPanel1, "Last");
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setDividerSize(5);
        this.jSplitPane1.setMinimumSize(new Dimension(500, 300));
        this.jSplitPane1.setPreferredSize(new Dimension(500, 300));
        this.sentencePackList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Loading..."};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.sentencePackList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SentenceLibraryFrame.this.sentencePackListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.sentencePackList);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.sentenceList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Loading..."};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.sentenceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SentenceLibraryFrame.this.sentenceListMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.sentenceList);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.loadSentence();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void sentencePackListValueChanged(ListSelectionEvent evt) {
        int index = this.sentencePackList.getSelectedIndex();
        this.sentencePackSelected(index);
    }

    private void sentenceListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.loadSentence();
        }
    }

    private void loadSentence() {
        Sentence selectedSentence = (Sentence)this.sentenceList.getSelectedValue();
        this.skyggeFrame.loadSentence(selectedSentence);
        this.setVisible(false);
    }

    private void sentencePackSelected(int index) {
        SentencePack sentencePack = this.sentencePacks.get(index);
        DefaultListModel<Sentence> sentenceListModel = new DefaultListModel<Sentence>();
        for (Sentence sentence : sentencePack.getSentences()) {
            sentenceListModel.addElement(sentence);
        }
        this.sentenceList.setModel(sentenceListModel);
    }
}

