/*
 * Decompiled with CFR 0.152.
 */
package skygge.UI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.ParseException;
import skygge.Sentence;
import skygge.SoundDeviceManager;
import skygge.UI.LoadingFrame;
import skygge.UI.SentenceInfoFrame;
import skygge.UI.SentenceLibraryFrame;
import skygge.UI.WaveFormPanel;
import skygge.Utils;

public class SkyggeFrame
extends JFrame {
    private byte[] sentenceAudioData;
    private byte[] recordingAudioData;
    private SentenceLibraryFrame sentenceLibraryFrame;
    private SentenceInfoFrame sentenceInfoFrame;
    private boolean isRecording = false;
    private final String URL_SKYGGE_INFO = "https://skygge.s3.amazonaws.com/skyyge_info.json";
    private final String STATUS_BAR_MESSAGE_UPDATE = "<html><font color=red>Your version of Skygge is outdated. To update, please go to http://skygge.zaoyin.eu.</font></html>";
    private final String STATUS_BAR_MESSAGE_THANK_YOU = "Thanks for using Skygge.";
    private final String HOTKEY_ACTION_PLAY_SENTENCE = "play sentence button clicked";
    private final String HOTKEY_ACTION_LOOP_SENTENCE = "loop sentence button clicked";
    private final String HOTKEY_ACTION_PLAY_RECORDING = "play recording button clicked";
    private final String HOTKEY_ACTION_RECORD_RECORDING = "record sentence button clicked";
    private Box.Filler filler1;
    private Box.Filler filler10;
    private Box.Filler filler11;
    private Box.Filler filler12;
    private Box.Filler filler13;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private Box.Filler filler5;
    private Box.Filler filler6;
    private Box.Filler filler7;
    private Box.Filler filler9;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel2;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JSeparator jSeparator1;
    private JToggleButton loopSentenceButton;
    private JButton playRecordingButton;
    private JButton playSentenceButton;
    private JToggleButton recordRecordingButton;
    private WaveFormPanel recordingWaveFormPanel;
    private JPanel rootPanel;
    private WaveFormPanel sentenceWaveFormPanel;
    private JButton showLibraryButton;
    private JButton showSentenceInfoButton;
    private JLabel statusBarLabel;

    public SkyggeFrame() {
        this.initComponents();
        this.sentenceLibraryFrame = new SentenceLibraryFrame(this);
        this.sentenceInfoFrame = new SentenceInfoFrame();
        this.checkForNewVersionAndUpdateMOTD();
        this.loadDefaultSentence();
        this.setUpHotkeys();
        Utils.setIconOnFrame(this);
    }

    private void checkForNewVersionAndUpdateMOTD() {
        Thread t = new Thread(){

            @Override
            public void run() {
                String statusMessage = "Thanks for using Skygge.";
                try {
                    String skyggeInfoString = Utils.loadUrlIntoString("https://skygge.s3.amazonaws.com/skyyge_info.json");
                    JSONObject skyggeInfoData = (JSONObject)JSONValue.parseStrict(skyggeInfoString);
                    String newestVersion = (String)skyggeInfoData.get("newest_version");
                    String messageOfTheDay = (String)skyggeInfoData.get("message_of_the_day");
                    statusMessage = !newestVersion.equals("1.0.0") ? "<html><font color=red>Your version of Skygge is outdated. To update, please go to http://skygge.zaoyin.eu.</font></html>" : messageOfTheDay;
                }
                catch (IOException e) {
                }
                catch (ParseException e) {
                    // empty catch block
                }
                final String statusMessageFinalCopy = statusMessage;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SkyggeFrame.this.statusBarLabel.setText(statusMessageFinalCopy);
                    }
                });
            }
        };
        t.start();
    }

    private void loadDefaultSentence() {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    SkyggeFrame.access$102(SkyggeFrame.this, Utils.loadResourceIntoByteArray("/resources/animals2_001.wav"));
                    int i = 0;
                    while (i < SkyggeFrame.this.sentenceAudioData.length) {
                        byte[] byArray = SkyggeFrame.this.sentenceAudioData;
                        int n = i++;
                        byArray[n] = (byte)(byArray[n] + 128);
                    }
                    SkyggeFrame.this.sentenceWaveFormPanel.setAudioData(SkyggeFrame.this.sentenceAudioData);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
    }

    private void setUpHotkeys() {
        InputMap inputMap = this.rootPanel.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke('a'), "play sentence button clicked");
        inputMap.put(KeyStroke.getKeyStroke('s'), "loop sentence button clicked");
        inputMap.put(KeyStroke.getKeyStroke('d'), "play recording button clicked");
        inputMap.put(KeyStroke.getKeyStroke('f'), "record sentence button clicked");
        ActionMap actionMap = this.rootPanel.getActionMap();
        actionMap.put("play sentence button clicked", new PressButtonAction(this.playSentenceButton));
        actionMap.put("loop sentence button clicked", new PressButtonAction(this.loopSentenceButton));
        actionMap.put("play recording button clicked", new PressButtonAction(this.playRecordingButton));
        actionMap.put("record sentence button clicked", new PressButtonAction(this.recordRecordingButton));
    }

    private void initComponents() {
        this.rootPanel = new JPanel();
        this.jPanel7 = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, Short.MAX_VALUE));
        this.filler2 = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, Short.MAX_VALUE));
        this.filler3 = new Box.Filler(new Dimension(0, 10), new Dimension(0, 10), new Dimension(Short.MAX_VALUE, 10));
        this.filler4 = new Box.Filler(new Dimension(0, 10), new Dimension(0, 10), new Dimension(Short.MAX_VALUE, 10));
        this.jPanel8 = new JPanel();
        this.jPanel9 = new JPanel();
        this.jPanel2 = new JPanel();
        this.playSentenceButton = new JButton();
        this.loopSentenceButton = new JToggleButton();
        this.filler7 = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, Short.MAX_VALUE));
        this.sentenceWaveFormPanel = new WaveFormPanel();
        this.jPanel11 = new JPanel();
        this.filler9 = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, Short.MAX_VALUE));
        this.showLibraryButton = new JButton();
        this.showSentenceInfoButton = new JButton();
        this.filler6 = new Box.Filler(new Dimension(0, 8), new Dimension(0, 8), new Dimension(Short.MAX_VALUE, 8));
        this.jSeparator1 = new JSeparator();
        this.filler5 = new Box.Filler(new Dimension(0, 8), new Dimension(0, 8), new Dimension(Short.MAX_VALUE, 8));
        this.jPanel12 = new JPanel();
        this.jPanel13 = new JPanel();
        this.playRecordingButton = new JButton();
        this.recordRecordingButton = new JToggleButton();
        this.filler10 = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, Short.MAX_VALUE));
        this.recordingWaveFormPanel = new WaveFormPanel();
        this.jPanel15 = new JPanel();
        this.filler11 = new Box.Filler(new Dimension(60, 0), new Dimension(60, 0), new Dimension(60, Short.MAX_VALUE));
        this.jPanel16 = new JPanel();
        this.filler12 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.statusBarLabel = new JLabel();
        this.filler13 = new Box.Filler(new Dimension(0, 5), new Dimension(0, 5), new Dimension(Short.MAX_VALUE, 5));
        this.setDefaultCloseOperation(3);
        this.setTitle("Skygge");
        this.setLocation(new Point(200, 200));
        this.setResizable(false);
        this.rootPanel.setLayout(new BorderLayout());
        this.jPanel7.setLayout(new BorderLayout());
        this.jPanel7.add((Component)this.filler1, "Before");
        this.jPanel7.add((Component)this.filler2, "After");
        this.jPanel7.add((Component)this.filler3, "Last");
        this.jPanel7.add((Component)this.filler4, "First");
        this.jPanel8.setLayout(new BoxLayout(this.jPanel8, 1));
        this.jPanel9.setMaximumSize(new Dimension(2000, 2000));
        this.jPanel9.setMinimumSize(new Dimension(0, 0));
        this.jPanel9.setLayout(new BorderLayout());
        this.jPanel2.setMinimumSize(new Dimension(50, 0));
        this.jPanel2.setPreferredSize(new Dimension(60, 100));
        this.jPanel2.setLayout(new GridBagLayout());
        this.playSentenceButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/media-playback-start.png")));
        this.playSentenceButton.setToolTipText("Play the sentence. Hotkey: 'a'");
        this.playSentenceButton.setPreferredSize(new Dimension(50, 50));
        this.playSentenceButton.setSize(new Dimension(50, 50));
        this.playSentenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyggeFrame.this.playSentenceButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel2.add((Component)this.playSentenceButton, gridBagConstraints);
        this.loopSentenceButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/view-refresh.png")));
        this.loopSentenceButton.setToolTipText("Start/stop looping the sentence. Hotkey: 's'");
        this.loopSentenceButton.setPreferredSize(new Dimension(50, 50));
        this.loopSentenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyggeFrame.this.loopSentenceButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.loopSentenceButton, gridBagConstraints);
        this.jPanel2.add((Component)this.filler7, new GridBagConstraints());
        this.jPanel9.add((Component)this.jPanel2, "Before");
        this.sentenceWaveFormPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        this.sentenceWaveFormPanel.setMinimumSize(new Dimension(600, 100));
        this.sentenceWaveFormPanel.setPreferredSize(new Dimension(600, 100));
        GroupLayout sentenceWaveFormPanelLayout = new GroupLayout(this.sentenceWaveFormPanel);
        this.sentenceWaveFormPanel.setLayout(sentenceWaveFormPanelLayout);
        sentenceWaveFormPanelLayout.setHorizontalGroup(sentenceWaveFormPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 679, Short.MAX_VALUE));
        sentenceWaveFormPanelLayout.setVerticalGroup(sentenceWaveFormPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 98, Short.MAX_VALUE));
        this.jPanel9.add((Component)this.sentenceWaveFormPanel, "Center");
        this.jPanel11.setMinimumSize(new Dimension(50, 0));
        this.jPanel11.setLayout(new GridBagLayout());
        this.jPanel11.add((Component)this.filler9, new GridBagConstraints());
        this.showLibraryButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/music-library.png")));
        this.showLibraryButton.setToolTipText("Open sentence library.");
        this.showLibraryButton.setPreferredSize(new Dimension(50, 50));
        this.showLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyggeFrame.this.showLibraryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel11.add((Component)this.showLibraryButton, gridBagConstraints);
        this.showSentenceInfoButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/ibus-panel.png")));
        this.showSentenceInfoButton.setToolTipText("Show sentence information.");
        this.showSentenceInfoButton.setActionCommand("I");
        this.showSentenceInfoButton.setPreferredSize(new Dimension(50, 50));
        this.showSentenceInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyggeFrame.this.showSentenceInfoButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel11.add((Component)this.showSentenceInfoButton, gridBagConstraints);
        this.jPanel9.add((Component)this.jPanel11, "After");
        this.jPanel8.add(this.jPanel9);
        this.jPanel8.add(this.filler6);
        this.jPanel8.add(this.jSeparator1);
        this.jPanel8.add(this.filler5);
        this.jPanel12.setMaximumSize(new Dimension(2000, 2000));
        this.jPanel12.setMinimumSize(new Dimension(0, 0));
        this.jPanel12.setLayout(new BorderLayout());
        this.jPanel13.setMinimumSize(new Dimension(50, 0));
        this.jPanel13.setLayout(new GridBagLayout());
        this.playRecordingButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/media-playback-start.png")));
        this.playRecordingButton.setToolTipText("Play the recording. Hotkey: 'd'");
        this.playRecordingButton.setEnabled(false);
        this.playRecordingButton.setPreferredSize(new Dimension(50, 50));
        this.playRecordingButton.setSize(new Dimension(50, 50));
        this.playRecordingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyggeFrame.this.playRecordingButtonActionPerformed(evt);
            }
        });
        this.jPanel13.add((Component)this.playRecordingButton, new GridBagConstraints());
        this.recordRecordingButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/media-record.png")));
        this.recordRecordingButton.setToolTipText("Record yourself. Hotkey: 'f'");
        this.recordRecordingButton.setMaximumSize(new Dimension(50, 50));
        this.recordRecordingButton.setMinimumSize(new Dimension(50, 50));
        this.recordRecordingButton.setPreferredSize(new Dimension(50, 50));
        this.recordRecordingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SkyggeFrame.this.recordRecordingButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.jPanel13.add((Component)this.recordRecordingButton, gridBagConstraints);
        this.jPanel13.add((Component)this.filler10, new GridBagConstraints());
        this.jPanel12.add((Component)this.jPanel13, "Before");
        this.recordingWaveFormPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        this.recordingWaveFormPanel.setMinimumSize(new Dimension(600, 100));
        this.recordingWaveFormPanel.setPreferredSize(new Dimension(600, 100));
        GroupLayout recordingWaveFormPanelLayout = new GroupLayout(this.recordingWaveFormPanel);
        this.recordingWaveFormPanel.setLayout(recordingWaveFormPanelLayout);
        recordingWaveFormPanelLayout.setHorizontalGroup(recordingWaveFormPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 679, Short.MAX_VALUE));
        recordingWaveFormPanelLayout.setVerticalGroup(recordingWaveFormPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 98, Short.MAX_VALUE));
        this.jPanel12.add((Component)this.recordingWaveFormPanel, "Center");
        this.jPanel15.setMinimumSize(new Dimension(50, 0));
        this.jPanel15.setLayout(new GridBagLayout());
        this.jPanel15.add((Component)this.filler11, new GridBagConstraints());
        this.jPanel12.add((Component)this.jPanel15, "After");
        this.jPanel8.add(this.jPanel12);
        this.jPanel7.add((Component)this.jPanel8, "Center");
        this.rootPanel.add((Component)this.jPanel7, "Center");
        this.jPanel16.setLayout(new BorderLayout());
        this.jPanel16.add((Component)this.filler12, "West");
        this.statusBarLabel.setText(" ");
        this.jPanel16.add((Component)this.statusBarLabel, "Center");
        this.jPanel16.add((Component)this.filler13, "Last");
        this.rootPanel.add((Component)this.jPanel16, "South");
        this.getContentPane().add((Component)this.rootPanel, "Center");
        this.pack();
    }

    private void deselectToggleButtons() {
        this.deselectLoopSentenceButton();
        this.deselectRecordRecordingButton();
    }

    private void deselectLoopSentenceButton() {
        this.loopSentenceButton.setSelected(false);
    }

    private void deselectRecordRecordingButton() {
        this.recordRecordingButton.setSelected(false);
    }

    private void stopEverythingAndUpdateRecordedAudioData() {
        SoundDeviceManager.getInstance().stopEverything();
        if (this.isRecording) {
            this.recordingAudioData = SoundDeviceManager.getInstance().getRecordedAudioData();
            this.recordingWaveFormPanel.setAudioData(this.recordingAudioData);
            this.isRecording = false;
        }
    }

    private void playSentenceButtonActionPerformed(ActionEvent evt) {
        this.deselectToggleButtons();
        this.stopEverythingAndUpdateRecordedAudioData();
        if (this.sentenceAudioData != null) {
            SoundDeviceManager.getInstance().startPlaying(this.sentenceAudioData);
        }
    }

    private void loopSentenceButtonActionPerformed(ActionEvent evt) {
        this.deselectRecordRecordingButton();
        this.stopEverythingAndUpdateRecordedAudioData();
        if (this.loopSentenceButton.isSelected() && this.sentenceAudioData != null) {
            SoundDeviceManager.getInstance().startLooping(this.sentenceAudioData);
        } else {
            SoundDeviceManager.getInstance().stopEverything();
        }
    }

    private void playRecordingButtonActionPerformed(ActionEvent evt) {
        this.deselectToggleButtons();
        this.stopEverythingAndUpdateRecordedAudioData();
        if (this.recordingAudioData != null) {
            SoundDeviceManager.getInstance().startPlaying(this.recordingAudioData);
        }
    }

    private void recordRecordingButtonActionPerformed(ActionEvent evt) {
        this.deselectLoopSentenceButton();
        if (!this.playRecordingButton.isEnabled()) {
            this.playRecordingButton.setEnabled(true);
        }
        if (this.recordRecordingButton.isSelected()) {
            SoundDeviceManager.getInstance().startRecording();
            this.isRecording = true;
        } else {
            this.stopEverythingAndUpdateRecordedAudioData();
        }
    }

    private void showLibraryButtonActionPerformed(ActionEvent evt) {
        this.sentenceLibraryFrame.setVisible(true);
    }

    private void showSentenceInfoButtonActionPerformed(ActionEvent evt) {
        this.sentenceInfoFrame.setVisible(true);
    }

    public void loadSentence(final Sentence sentence) {
        LoadingFrame.getInstance().setVisible(true);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    SkyggeFrame.access$102(SkyggeFrame.this, Utils.loadUrlIntoByteArray(sentence.getUrl()));
                    int i = 0;
                    while (i < SkyggeFrame.this.sentenceAudioData.length) {
                        byte[] byArray = SkyggeFrame.this.sentenceAudioData;
                        int n = i++;
                        byArray[n] = (byte)(byArray[n] + 128);
                    }
                    SkyggeFrame.this.sentenceWaveFormPanel.setAudioData(SkyggeFrame.this.sentenceAudioData);
                    SkyggeFrame.this.sentenceInfoFrame.setInformation(sentence.getInformation());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Unable to load sentence.", "IO Error", 0);
                }
                finally {
                    LoadingFrame.getInstance().setVisible(false);
                }
            }
        };
        t.start();
    }

    static /* synthetic */ byte[] access$102(SkyggeFrame x0, byte[] x1) {
        x0.sentenceAudioData = x1;
        return x1;
    }

    class PressButtonAction
    extends AbstractAction {
        AbstractButton button;

        public PressButtonAction(AbstractButton button) {
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.button.doClick();
        }
    }
}

