/*
 * Decompiled with CFR 0.152.
 */
package skygge.UI;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class WaveFormPanel
extends JPanel {
    private byte[] audioData;

    public WaveFormPanel() {
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.setBackground(new Color(0));
        this.audioData = null;
    }

    public void setAudioData(byte[] audioData) {
        this.audioData = audioData;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.audioData != null) {
            this.drawWaveForm(g);
        }
        g.setColor(Color.white);
        g.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
    }

    private void drawWaveForm(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int[] waveFormXCoords = new int[width];
        int[] waveFormYCoords = new int[width];
        int step = this.audioData.length / width;
        double yScale = (double)height / 255.0;
        waveFormXCoords[0] = 0;
        waveFormYCoords[0] = height / 2;
        for (int i = 1; i < width; ++i) {
            byte sample = this.audioData[i * step];
            waveFormXCoords[i] = i;
            waveFormYCoords[i] = height / 2 - (int)((double)sample * yScale);
        }
        g.setColor(Color.green);
        g.drawPolyline(waveFormXCoords, waveFormYCoords, width);
    }
}

