/*
 * Decompiled with CFR 0.152.
 */
package skygge;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import skygge.Skygge;

public class Utils {
    private static Image logoImage = null;

    public static AudioFormat getFormat() {
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        float rate = 44100.0f;
        int sampleSize = 8;
        boolean bigEndian = true;
        int channels = 1;
        return new AudioFormat(encoding, rate, sampleSize, channels, sampleSize / 8 * channels, rate, bigEndian);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFileIntoByteArray(String path) throws IOException {
        RandomAccessFile f = new RandomAccessFile(path, "r");
        try {
            byte[] data = new byte[(int)f.length()];
            f.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            f.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadUrlIntoByteArray(String urlString) throws IOException {
        URL url = new URL(urlString);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        try {
            int n;
            inputStream = url.openStream();
            byte[] byteChunk = new byte[8192];
            while ((n = inputStream.read(byteChunk)) > 0) {
                outputStream.write(byteChunk, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return outputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadResourceIntoByteArray(String resourcePath) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        try {
            int n;
            inputStream = Skygge.class.getResourceAsStream(resourcePath);
            byte[] byteChunk = new byte[8192];
            while ((n = inputStream.read(byteChunk)) > 0) {
                outputStream.write(byteChunk, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return outputStream.toByteArray();
    }

    public static String loadUrlIntoString(String urlString) throws IOException {
        return new String(Utils.loadUrlIntoByteArray(urlString));
    }

    public static void setIconOnFrame(JFrame frame) {
        if (logoImage == null) {
            URL logoResourceURL = frame.getClass().getResource("/resources/SkyggeLogo.png");
            ImageIcon logoImageIcon = new ImageIcon(logoResourceURL);
            logoImage = logoImageIcon.getImage();
        }
        frame.setIconImage(logoImage);
    }
}

