/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.text.BreakIterator;
import java.util.BitSet;
import java.util.Locale;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.StateInvariantError;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WhitespaceBasedBreakIterator;
import sun.swing.SwingUtilities2;

public class GlyphView
extends View
implements TabableView,
Cloneable {
    private byte[] selections = null;
    int offset = 0;
    int length = 0;
    boolean impliedCR;
    boolean skipWidth;
    TabExpander expander;
    private float minimumSpan = -1.0f;
    private int[] breakSpots = null;
    int x;
    GlyphPainter painter;
    static GlyphPainter defaultPainter;
    private JustificationInfo justificationInfo = null;

    public GlyphView(Element element) {
        super(element);
        Element element2 = element.getParentElement();
        AttributeSet attributeSet = element.getAttributes();
        this.impliedCR = attributeSet != null && attributeSet.getAttribute("CR") != null && element2 != null && element2.getElementCount() > 1;
        this.skipWidth = element.getName().equals("br");
    }

    protected final Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            object = null;
        }
        return object;
    }

    public GlyphPainter getGlyphPainter() {
        return this.painter;
    }

    public void setGlyphPainter(GlyphPainter glyphPainter) {
        this.painter = glyphPainter;
    }

    public Segment getText(int n, int n2) {
        Segment segment = SegmentCache.getSharedSegment();
        try {
            Document document = this.getDocument();
            document.getText(n, n2 - n, segment);
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("GlyphView: Stale view: " + badLocationException);
        }
        return segment;
    }

    public Color getBackground() {
        AttributeSet attributeSet;
        Document document = this.getDocument();
        if (document instanceof StyledDocument && (attributeSet = this.getAttributes()).isDefined(StyleConstants.Background)) {
            return ((StyledDocument)document).getBackground(attributeSet);
        }
        return null;
    }

    public Color getForeground() {
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            AttributeSet attributeSet = this.getAttributes();
            return ((StyledDocument)document).getForeground(attributeSet);
        }
        Container container = this.getContainer();
        if (container != null) {
            return container.getForeground();
        }
        return null;
    }

    public Font getFont() {
        Document document = this.getDocument();
        if (document instanceof StyledDocument) {
            AttributeSet attributeSet = this.getAttributes();
            return ((StyledDocument)document).getFont(attributeSet);
        }
        Container container = this.getContainer();
        if (container != null) {
            return container.getFont();
        }
        return null;
    }

    public boolean isUnderline() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isUnderline(attributeSet);
    }

    public boolean isStrikeThrough() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isStrikeThrough(attributeSet);
    }

    public boolean isSubscript() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isSubscript(attributeSet);
    }

    public boolean isSuperscript() {
        AttributeSet attributeSet = this.getAttributes();
        return StyleConstants.isSuperscript(attributeSet);
    }

    public TabExpander getTabExpander() {
        return this.expander;
    }

    protected void checkPainter() {
        if (this.painter == null) {
            if (defaultPainter == null) {
                String string = "javax.swing.text.GlyphPainter1";
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    Object obj = clazz.newInstance();
                    if (obj instanceof GlyphPainter) {
                        defaultPainter = (GlyphPainter)obj;
                    }
                }
                catch (Throwable throwable) {
                    throw new StateInvariantError("GlyphView: Can't load glyph painter: " + string);
                }
            }
            this.setGlyphPainter(defaultPainter.getPainter(this, this.getStartOffset(), this.getEndOffset()));
        }
    }

    @Override
    public float getTabbedSpan(float f, TabExpander tabExpander) {
        this.checkPainter();
        TabExpander tabExpander2 = this.expander;
        this.expander = tabExpander;
        if (this.expander != tabExpander2) {
            this.preferenceChanged(null, true, false);
        }
        this.x = (int)f;
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        float f2 = this.painter.getSpan(this, n, n2, this.expander, f);
        return f2;
    }

    @Override
    public float getPartialSpan(int n, int n2) {
        this.checkPainter();
        float f = this.painter.getSpan(this, n, n2, this.expander, this.x);
        return f;
    }

    @Override
    public int getStartOffset() {
        Element element = this.getElement();
        return this.length > 0 ? element.getStartOffset() + this.offset : element.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        Element element = this.getElement();
        return this.length > 0 ? element.getStartOffset() + this.offset + this.length : element.getEndOffset();
    }

    private void initSelections(int n, int n2) {
        int n3 = n2 - n + 1;
        if (this.selections == null || n3 > this.selections.length) {
            this.selections = new byte[n3];
            return;
        }
        int n4 = 0;
        while (n4 < n3) {
            this.selections[n4++] = 0;
        }
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        JTextComponent jTextComponent;
        Object object;
        this.checkPainter();
        boolean bl = false;
        Container container = this.getContainer();
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        if (container != null && !container.isEnabled()) {
            Color color3 = color2 = container instanceof JTextComponent ? ((JTextComponent)container).getDisabledTextColor() : UIManager.getColor("textInactiveText");
        }
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (container instanceof JTextComponent && (object = (jTextComponent = (JTextComponent)container).getHighlighter()) instanceof LayeredHighlighter) {
            ((LayeredHighlighter)object).paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, this);
        }
        if (Utilities.isComposedTextElement(this.getElement())) {
            Utilities.paintComposedText(graphics, shape.getBounds(), this);
            bl = true;
        } else if (container instanceof JTextComponent) {
            Highlighter.Highlight[] highlightArray;
            jTextComponent = (JTextComponent)container;
            object = jTextComponent.getSelectedTextColor();
            if (jTextComponent.getHighlighter() != null && object != null && !((Color)object).equals(color2) && (highlightArray = jTextComponent.getHighlighter().getHighlights()).length != 0) {
                int n3;
                int n4;
                int n5;
                boolean bl2 = false;
                int n6 = 0;
                for (n5 = 0; n5 < highlightArray.length; ++n5) {
                    Highlighter.Highlight highlight = highlightArray[n5];
                    n4 = highlight.getStartOffset();
                    n3 = highlight.getEndOffset();
                    if (n4 > n2 || n3 < n || !SwingUtilities2.useSelectedTextColor(highlight, jTextComponent)) continue;
                    if (n4 <= n && n3 >= n2) {
                        this.paintTextUsingColor(graphics, shape, (Color)object, n, n2);
                        bl = true;
                        break;
                    }
                    if (!bl2) {
                        this.initSelections(n, n2);
                        bl2 = true;
                    }
                    n4 = Math.max(n, n4);
                    n3 = Math.min(n2, n3);
                    this.paintTextUsingColor(graphics, shape, (Color)object, n4, n3);
                    int n7 = n4 - n;
                    this.selections[n7] = (byte)(this.selections[n7] + 1);
                    int n8 = n3 - n;
                    this.selections[n8] = (byte)(this.selections[n8] - 1);
                    ++n6;
                }
                if (!bl && n6 > 0) {
                    n5 = -1;
                    int n9 = 0;
                    n4 = n2 - n;
                    while (n5++ < n4) {
                        while (n5 < n4 && this.selections[n5] == 0) {
                            ++n5;
                        }
                        if (n9 != n5) {
                            this.paintTextUsingColor(graphics, shape, color2, n + n9, n + n5);
                        }
                        n3 = 0;
                        while (n5 < n4 && (n3 += this.selections[n5]) != 0) {
                            ++n5;
                        }
                        n9 = n5;
                    }
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.paintTextUsingColor(graphics, shape, color2, n, n2);
        }
    }

    final void paintTextUsingColor(Graphics graphics, Shape shape, Color color, int n, int n2) {
        graphics.setColor(color);
        this.painter.paint(this, graphics, shape, n, n2);
        boolean bl = this.isUnderline();
        boolean bl2 = this.isStrikeThrough();
        if (bl || bl2) {
            int n3;
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            View view = this.getParent();
            if (view != null && view.getEndOffset() == n2) {
                Segment segment = this.getText(n, n2);
                while (Character.isWhitespace(segment.last())) {
                    --n2;
                    --segment.count;
                }
                SegmentCache.releaseSharedSegment(segment);
            }
            int n4 = rectangle.x;
            int n5 = this.getStartOffset();
            if (n5 != n) {
                n4 += (int)this.painter.getSpan(this, n5, n, this.getTabExpander(), n4);
            }
            int n6 = n4 + (int)this.painter.getSpan(this, n, n2, this.getTabExpander(), n4);
            int n7 = rectangle.y + (int)(this.painter.getHeight(this) - this.painter.getDescent(this));
            if (bl) {
                n3 = n7 + 1;
                graphics.drawLine(n4, n3, n6, n3);
            }
            if (bl2) {
                n3 = n7 - (int)(this.painter.getAscent(this) * 0.3f);
                graphics.drawLine(n4, n3, n6, n3);
            }
        }
    }

    @Override
    public float getMinimumSpan(int n) {
        switch (n) {
            case 0: {
                if (this.minimumSpan < 0.0f) {
                    this.minimumSpan = 0.0f;
                    int n2 = this.getStartOffset();
                    int n3 = this.getEndOffset();
                    while (n3 > n2) {
                        int n4 = this.getBreakSpot(n2, n3);
                        if (n4 == -1) {
                            n4 = n2;
                        }
                        this.minimumSpan = Math.max(this.minimumSpan, this.getPartialSpan(n4, n3));
                        n3 = n4 - 1;
                    }
                }
                return this.minimumSpan;
            }
            case 1: {
                return super.getMinimumSpan(n);
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    @Override
    public float getPreferredSpan(int n) {
        if (this.impliedCR) {
            return 0.0f;
        }
        this.checkPainter();
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        switch (n) {
            case 0: {
                if (this.skipWidth) {
                    return 0.0f;
                }
                return this.painter.getSpan(this, n2, n3, this.expander, this.x);
            }
            case 1: {
                float f = this.painter.getHeight(this);
                if (this.isSuperscript()) {
                    f += f / 3.0f;
                }
                return f;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    @Override
    public float getAlignment(int n) {
        this.checkPainter();
        if (n == 1) {
            boolean bl = this.isSuperscript();
            boolean bl2 = this.isSubscript();
            float f = this.painter.getHeight(this);
            float f2 = this.painter.getDescent(this);
            float f3 = this.painter.getAscent(this);
            float f4 = bl ? 1.0f : (bl2 ? (f > 0.0f ? (f - (f2 + f3 / 2.0f)) / f : 0.0f) : (f > 0.0f ? (f - f2) / f : 0.0f));
            return f4;
        }
        return super.getAlignment(n);
    }

    @Override
    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        this.checkPainter();
        return this.painter.modelToView(this, n, bias, shape);
    }

    @Override
    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        this.checkPainter();
        return this.painter.viewToModel(this, f, f2, shape, biasArray);
    }

    @Override
    public int getBreakWeight(int n, float f, float f2) {
        if (n == 0) {
            this.checkPainter();
            int n2 = this.getStartOffset();
            int n3 = this.painter.getBoundedPosition(this, n2, f, f2);
            return n3 == n2 ? 0 : (this.getBreakSpot(n2, n3) != -1 ? 2000 : 1000);
        }
        return super.getBreakWeight(n, f, f2);
    }

    @Override
    public View breakView(int n, int n2, float f, float f2) {
        if (n == 0) {
            this.checkPainter();
            int n3 = this.painter.getBoundedPosition(this, n2, f, f2);
            int n4 = this.getBreakSpot(n2, n3);
            if (n4 != -1) {
                n3 = n4;
            }
            if (n2 == this.getStartOffset() && n3 == this.getEndOffset()) {
                return this;
            }
            GlyphView glyphView = (GlyphView)this.createFragment(n2, n3);
            glyphView.x = (int)f;
            return glyphView;
        }
        return this;
    }

    private int getBreakSpot(int n, int n2) {
        int n3;
        int n4;
        if (this.breakSpots == null) {
            n4 = this.getStartOffset();
            n3 = this.getEndOffset();
            int[] nArray = new int[n3 + 1 - n4];
            int n5 = 0;
            Element element = this.getElement().getParentElement();
            int n6 = element == null ? n4 : element.getStartOffset();
            int n7 = element == null ? n3 : element.getEndOffset();
            Segment segment = this.getText(n6, n7);
            segment.first();
            BreakIterator breakIterator = this.getBreaker();
            breakIterator.setText(segment);
            int n8 = n3 + (n7 > n3 ? 1 : 0);
            while ((n8 = breakIterator.preceding(segment.offset + (n8 - n6)) + (n6 - segment.offset)) > n4) {
                nArray[n5++] = n8;
            }
            SegmentCache.releaseSharedSegment(segment);
            this.breakSpots = new int[n5];
            System.arraycopy(nArray, 0, this.breakSpots, 0, n5);
        }
        n4 = -1;
        for (n3 = 0; n3 < this.breakSpots.length; ++n3) {
            int n9 = this.breakSpots[n3];
            if (n9 > n2) continue;
            if (n9 <= n) break;
            n4 = n9;
            break;
        }
        return n4;
    }

    private BreakIterator getBreaker() {
        Document document = this.getDocument();
        if (document != null && Boolean.TRUE.equals(document.getProperty(AbstractDocument.MultiByteProperty))) {
            Container container = this.getContainer();
            Locale locale = container == null ? Locale.getDefault() : container.getLocale();
            return BreakIterator.getLineInstance(locale);
        }
        return new WhitespaceBasedBreakIterator();
    }

    @Override
    public View createFragment(int n, int n2) {
        this.checkPainter();
        Element element = this.getElement();
        GlyphView glyphView = (GlyphView)this.clone();
        glyphView.offset = n - element.getStartOffset();
        glyphView.length = n2 - n;
        glyphView.painter = this.painter.getPainter(glyphView, n, n2);
        glyphView.justificationInfo = null;
        return glyphView;
    }

    @Override
    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        if (n < -1) {
            throw new BadLocationException("invalid position", n);
        }
        return this.painter.getNextVisualPositionFrom(this, n, bias, shape, n2, biasArray);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.justificationInfo = null;
        this.breakSpots = null;
        this.minimumSpan = -1.0f;
        this.syncCR();
        this.preferenceChanged(null, true, false);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.justificationInfo = null;
        this.breakSpots = null;
        this.minimumSpan = -1.0f;
        this.syncCR();
        this.preferenceChanged(null, true, false);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.minimumSpan = -1.0f;
        this.syncCR();
        this.preferenceChanged(null, true, true);
    }

    private void syncCR() {
        if (this.impliedCR) {
            Element element = this.getElement().getParentElement();
            this.impliedCR = element != null && element.getElementCount() > 1;
        }
    }

    JustificationInfo getJustificationInfo(int n) {
        int n2;
        if (this.justificationInfo != null) {
            return this.justificationInfo;
        }
        int n3 = this.getStartOffset();
        int n4 = this.getEndOffset();
        Segment segment = this.getText(n3, n4);
        int n5 = segment.offset;
        int n6 = segment.offset + segment.count - 1;
        int n7 = n6 + 1;
        int n8 = n5 - 1;
        int n9 = n5 - 1;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        boolean bl = false;
        BitSet bitSet = new BitSet(n4 - n3 + 1);
        int n13 = 0;
        for (n2 = n6; n2 >= n5; --n2) {
            if (' ' == segment.array[n2]) {
                bitSet.set(n2 - n5);
                if (n13 == 0) {
                    ++n10;
                    continue;
                }
                if (n13 == 1) {
                    n13 = 2;
                    n12 = 1;
                    continue;
                }
                if (n13 != 2) continue;
                ++n12;
                continue;
            }
            if ('\t' == segment.array[n2]) {
                bl = true;
                break;
            }
            if (n13 == 0) {
                if ('\n' != segment.array[n2] && '\r' != segment.array[n2]) {
                    n13 = 1;
                    n8 = n2;
                }
            } else if (n13 != 1 && n13 == 2) {
                n11 += n12;
                n12 = 0;
            }
            n7 = n2;
        }
        SegmentCache.releaseSharedSegment(segment);
        n2 = -1;
        if (n7 < n6) {
            n2 = n7 - n5;
        }
        n13 = -1;
        if (n8 > n5) {
            n13 = n8 - n5;
        }
        this.justificationInfo = new JustificationInfo(n2, n13, n12, n11, n10, bl, bitSet);
        return this.justificationInfo;
    }

    public static abstract class GlyphPainter {
        public abstract float getSpan(GlyphView var1, int var2, int var3, TabExpander var4, float var5);

        public abstract float getHeight(GlyphView var1);

        public abstract float getAscent(GlyphView var1);

        public abstract float getDescent(GlyphView var1);

        public abstract void paint(GlyphView var1, Graphics var2, Shape var3, int var4, int var5);

        public abstract Shape modelToView(GlyphView var1, int var2, Position.Bias var3, Shape var4) throws BadLocationException;

        public abstract int viewToModel(GlyphView var1, float var2, float var3, Shape var4, Position.Bias[] var5);

        public abstract int getBoundedPosition(GlyphView var1, int var2, float var3, float var4);

        public GlyphPainter getPainter(GlyphView glyphView, int n, int n2) {
            return this;
        }

        public int getNextVisualPositionFrom(GlyphView glyphView, int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            int n3 = glyphView.getStartOffset();
            int n4 = glyphView.getEndOffset();
            switch (n2) {
                case 1: 
                case 5: {
                    Point point;
                    if (n != -1) {
                        return -1;
                    }
                    Container container = glyphView.getContainer();
                    if (!(container instanceof JTextComponent)) break;
                    Caret caret = ((JTextComponent)container).getCaret();
                    Point point2 = point = caret != null ? caret.getMagicCaretPosition() : null;
                    if (point == null) {
                        biasArray[0] = Position.Bias.Forward;
                        return n3;
                    }
                    int n5 = glyphView.viewToModel(point.x, 0.0f, shape, biasArray);
                    return n5;
                }
                case 3: {
                    if (n3 == glyphView.getDocument().getLength()) {
                        if (n == -1) {
                            biasArray[0] = Position.Bias.Forward;
                            return n3;
                        }
                        return -1;
                    }
                    if (n == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n3;
                    }
                    if (n == n4) {
                        return -1;
                    }
                    if (++n == n4) {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Forward;
                    return n;
                }
                case 7: {
                    if (n3 == glyphView.getDocument().getLength()) {
                        if (n == -1) {
                            biasArray[0] = Position.Bias.Forward;
                            return n3;
                        }
                        return -1;
                    }
                    if (n == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n4 - 1;
                    }
                    if (n == n3) {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Forward;
                    return n - 1;
                }
                default: {
                    throw new IllegalArgumentException("Bad direction: " + n2);
                }
            }
            return n;
        }
    }

    static class JustificationInfo {
        final int start;
        final int end;
        final int leadingSpaces;
        final int contentSpaces;
        final int trailingSpaces;
        final boolean hasTab;
        final BitSet spaceMap;

        JustificationInfo(int n, int n2, int n3, int n4, int n5, boolean bl, BitSet bitSet) {
            this.start = n;
            this.end = n2;
            this.leadingSpaces = n3;
            this.contentSpaces = n4;
            this.trailingSpaces = n5;
            this.hasTab = bl;
            this.spaceMap = bitSet;
        }
    }
}

