/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTPermission;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Window;
import java.util.Objects;
import sun.awt.DisplayChangedListener;
import sun.awt.FullScreenCapable;
import sun.java2d.opengl.CGLGraphicsConfig;

public final class CGraphicsDevice
extends GraphicsDevice
implements DisplayChangedListener {
    private volatile int displayID;
    private volatile Insets screenInsets;
    private volatile double xResolution;
    private volatile double yResolution;
    private volatile int scale;
    private final GraphicsConfiguration[] configs;
    private final int DEFAULT_CONFIG = 0;
    private static AWTPermission fullScreenExclusivePermission;
    private DisplayMode originalMode;

    public CGraphicsDevice(int n) {
        this.displayID = n;
        this.configs = new GraphicsConfiguration[]{CGLGraphicsConfig.getConfig(this, 0)};
    }

    public int getCGDisplayID() {
        return this.displayID;
    }

    @Override
    public GraphicsConfiguration[] getConfigurations() {
        return (GraphicsConfiguration[])this.configs.clone();
    }

    @Override
    public GraphicsConfiguration getDefaultConfiguration() {
        return this.configs[0];
    }

    @Override
    public String getIDstring() {
        return "Display " + this.displayID;
    }

    @Override
    public int getType() {
        return 0;
    }

    public double getXResolution() {
        return this.xResolution;
    }

    public double getYResolution() {
        return this.yResolution;
    }

    public Insets getScreenInsets() {
        return this.screenInsets;
    }

    public int getScaleFactor() {
        return this.scale;
    }

    public void invalidate(int n) {
        this.displayID = n;
    }

    @Override
    public void displayChanged() {
        this.xResolution = CGraphicsDevice.nativeGetXResolution(this.displayID);
        this.yResolution = CGraphicsDevice.nativeGetYResolution(this.displayID);
        this.screenInsets = CGraphicsDevice.nativeGetScreenInsets(this.displayID);
        this.scale = (int)CGraphicsDevice.nativeGetScaleFactor(this.displayID);
    }

    @Override
    public void paletteChanged() {
    }

    @Override
    public synchronized void setFullScreenWindow(Window window) {
        Window window2 = this.getFullScreenWindow();
        if (window == window2) {
            return;
        }
        boolean bl = this.isFullScreenSupported();
        if (bl && window2 != null) {
            CGraphicsDevice.exitFullScreenExclusive(window2);
            if (this.originalMode != null) {
                this.setDisplayMode(this.originalMode);
                this.originalMode = null;
            }
        }
        super.setFullScreenWindow(window);
        if (bl && window != null) {
            if (this.isDisplayChangeSupported()) {
                this.originalMode = this.getDisplayMode();
            }
            CGraphicsDevice.enterFullScreenExclusive(window);
        }
    }

    @Override
    public boolean isFullScreenSupported() {
        return CGraphicsDevice.isFSExclusiveModeAllowed();
    }

    private static boolean isFSExclusiveModeAllowed() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (fullScreenExclusivePermission == null) {
                fullScreenExclusivePermission = new AWTPermission("fullScreenExclusive");
            }
            try {
                securityManager.checkPermission(fullScreenExclusivePermission);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    private static void enterFullScreenExclusive(Window window) {
        FullScreenCapable fullScreenCapable = (FullScreenCapable)((Object)window.getPeer());
        if (fullScreenCapable != null) {
            fullScreenCapable.enterFullScreenMode();
        }
    }

    private static void exitFullScreenExclusive(Window window) {
        FullScreenCapable fullScreenCapable = (FullScreenCapable)((Object)window.getPeer());
        if (fullScreenCapable != null) {
            fullScreenCapable.exitFullScreenMode();
        }
    }

    @Override
    public boolean isDisplayChangeSupported() {
        return true;
    }

    @Override
    public void setDisplayMode(DisplayMode displayMode) {
        if (displayMode == null) {
            throw new IllegalArgumentException("Invalid display mode");
        }
        if (!Objects.equals(displayMode, this.getDisplayMode())) {
            CGraphicsDevice.nativeSetDisplayMode(this.displayID, displayMode.getWidth(), displayMode.getHeight(), displayMode.getBitDepth(), displayMode.getRefreshRate());
            if (this.isFullScreenSupported() && this.getFullScreenWindow() != null) {
                this.getFullScreenWindow().setSize(displayMode.getWidth(), displayMode.getHeight());
            }
        }
    }

    @Override
    public DisplayMode getDisplayMode() {
        return CGraphicsDevice.nativeGetDisplayMode(this.displayID);
    }

    @Override
    public DisplayMode[] getDisplayModes() {
        return CGraphicsDevice.nativeGetDisplayModes(this.displayID);
    }

    private static native double nativeGetScaleFactor(int var0);

    private static native void nativeSetDisplayMode(int var0, int var1, int var2, int var3, int var4);

    private static native DisplayMode nativeGetDisplayMode(int var0);

    private static native DisplayMode[] nativeGetDisplayModes(int var0);

    private static native double nativeGetXResolution(int var0);

    private static native double nativeGetYResolution(int var0);

    private static native Insets nativeGetScreenInsets(int var0);
}

