/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.WindowPeer;
import java.util.List;
import javax.swing.JComponent;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.CausedFocusEvent;
import sun.awt.DisplayChangedListener;
import sun.awt.ExtendedKeyCodes;
import sun.awt.FullScreenCapable;
import sun.awt.SunToolkit;
import sun.awt.TimedWindowEvent;
import sun.awt.UngrabEvent;
import sun.java2d.NullSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.pipe.Region;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.LWContainerPeer;
import sun.lwawt.LWKeyboardFocusManagerPeer;
import sun.lwawt.LWToolkit;
import sun.lwawt.PlatformComponent;
import sun.lwawt.PlatformEventNotifier;
import sun.lwawt.PlatformWindow;
import sun.lwawt.SecurityWarningWindow;
import sun.util.logging.PlatformLogger;

public class LWWindowPeer
extends LWContainerPeer<Window, JComponent>
implements FramePeer,
DialogPeer,
FullScreenCapable,
DisplayChangedListener,
PlatformEventNotifier {
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.lwawt.focus.LWWindowPeer");
    private final PlatformWindow platformWindow;
    private static final int MINIMUM_WIDTH = 1;
    private static final int MINIMUM_HEIGHT = 1;
    private Insets insets = new Insets(0, 0, 0, 0);
    private GraphicsDevice graphicsDevice;
    private GraphicsConfiguration graphicsConfig;
    private SurfaceData surfaceData;
    private final Object surfaceDataLock = new Object();
    private volatile int windowState = 0;
    private volatile boolean isMouseOver = false;
    private static volatile LWComponentPeer<?, ?> lastCommonMouseEventPeer;
    private volatile LWComponentPeer<?, ?> lastMouseEventPeer;
    private static final LWComponentPeer<?, ?>[] mouseDownTarget;
    private static int mouseClickButtons;
    private volatile boolean isOpaque = true;
    private static final Font DEFAULT_FONT;
    private static LWWindowPeer grabbingWindow;
    private volatile boolean skipNextFocusChange;
    private static final Color nonOpaqueBackground;
    private volatile boolean textured;
    private final PeerType peerType;
    private final SecurityWarningWindow warningWindow;
    private LWWindowPeer blocker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LWWindowPeer(Window window, PlatformComponent platformComponent, PlatformWindow platformWindow, PeerType peerType) {
        super(window, platformComponent);
        this.platformWindow = platformWindow;
        this.peerType = peerType;
        Window window2 = window.getOwner();
        LWWindowPeer lWWindowPeer = window2 == null ? null : (LWWindowPeer)AWTAccessor.getComponentAccessor().getPeer(window2);
        PlatformWindow platformWindow2 = lWWindowPeer != null ? lWWindowPeer.getPlatformWindow() : null;
        GraphicsConfiguration graphicsConfiguration = ((Window)this.getTarget()).getGraphicsConfiguration();
        Object object = this.getStateLock();
        synchronized (object) {
            this.graphicsConfig = graphicsConfiguration;
        }
        if (!window.isFontSet()) {
            window.setFont(DEFAULT_FONT);
        }
        if (!window.isBackgroundSet()) {
            window.setBackground(SystemColor.window);
        }
        if (!window.isForegroundSet()) {
            window.setForeground(SystemColor.windowText);
        }
        platformWindow.initialize(window, this, platformWindow2);
        object = null;
        if (window.getWarningString() != null && !AWTAccessor.getWindowAccessor().isTrayIconWindow(window)) {
            LWToolkit lWToolkit = (LWToolkit)Toolkit.getDefaultToolkit();
            object = lWToolkit.createSecurityWarning(window, this);
        }
        this.warningWindow = object;
    }

    @Override
    void initializeImpl() {
        float f;
        super.initializeImpl();
        if (this.getTarget() instanceof Frame) {
            this.setTitle(((Frame)this.getTarget()).getTitle());
            this.setState(((Frame)this.getTarget()).getExtendedState());
        } else if (this.getTarget() instanceof Dialog) {
            this.setTitle(((Dialog)this.getTarget()).getTitle());
        }
        this.updateAlwaysOnTopState();
        this.updateMinimumSize();
        Shape shape = ((Window)this.getTarget()).getShape();
        if (shape != null) {
            this.applyShape(Region.getInstance(shape, null));
        }
        if ((f = ((Window)this.getTarget()).getOpacity()) < 1.0f) {
            this.setOpacity(f);
        }
        this.setOpaque(((Window)this.getTarget()).isOpaque());
        this.updateInsets(this.platformWindow.getInsets());
        if (this.getSurfaceData() == null) {
            this.replaceSurfaceData(false);
        }
        this.activateDisplayListener();
    }

    @Override
    public PlatformWindow getPlatformWindow() {
        return this.platformWindow;
    }

    @Override
    protected LWWindowPeer getWindowPeerOrSelf() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disposeImpl() {
        this.deactivateDisplayListener();
        SurfaceData surfaceData = this.getSurfaceData();
        Object object = this.surfaceDataLock;
        synchronized (object) {
            this.surfaceData = null;
        }
        if (surfaceData != null) {
            surfaceData.invalidate();
        }
        if (this.isGrabbing()) {
            this.ungrab();
        }
        if (this.warningWindow != null) {
            this.warningWindow.dispose();
        }
        this.platformWindow.dispose();
        super.disposeImpl();
    }

    @Override
    protected void setVisibleImpl(boolean bl) {
        if (!bl && this.warningWindow != null) {
            this.warningWindow.setVisible(false, false);
        }
        super.setVisibleImpl(bl);
        this.platformWindow.setVisible(bl);
        if (this.isSimpleWindow()) {
            LWWindowPeer lWWindowPeer;
            LWKeyboardFocusManagerPeer lWKeyboardFocusManagerPeer = LWKeyboardFocusManagerPeer.getInstance();
            if (bl) {
                if (!((Window)this.getTarget()).isAutoRequestFocus()) {
                    return;
                }
                this.requestWindowFocus(CausedFocusEvent.Cause.ACTIVATION);
            } else if (lWKeyboardFocusManagerPeer.getCurrentFocusedWindow() == this.getTarget() && (lWWindowPeer = LWWindowPeer.getOwnerFrameDialog(this)) != null) {
                lWWindowPeer.requestWindowFocus(CausedFocusEvent.Cause.ACTIVATION);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GraphicsConfiguration getGraphicsConfiguration() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.graphicsConfig;
        }
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration graphicsConfiguration) {
        this.setGraphicsConfig(graphicsConfiguration);
        return false;
    }

    protected final Graphics getOnscreenGraphics(Color color, Color color2, Font font) {
        if (this.getSurfaceData() == null) {
            return null;
        }
        if (color == null) {
            color = SystemColor.windowText;
        }
        if (color2 == null) {
            color2 = SystemColor.window;
        }
        if (font == null) {
            font = DEFAULT_FONT;
        }
        return this.platformWindow.transformGraphics(new SunGraphics2D(this.getSurfaceData(), color, color2, font));
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        if ((n5 & 0x4000) == 0 && this.getPeerType() == PeerType.VIEW_EMBEDDED_FRAME) {
            return;
        }
        if ((n5 & 4) != 0) {
            n5 &= 0xFFFFFFFB;
            n5 |= 2;
        }
        Rectangle rectangle = this.constrainBounds(n, n2, n3, n4);
        Rectangle rectangle2 = new Rectangle(this.getBounds());
        if ((n5 & 3) != 0) {
            rectangle2.x = rectangle.x;
            rectangle2.y = rectangle.y;
        }
        if ((n5 & 3) != 0) {
            rectangle2.width = rectangle.width;
            rectangle2.height = rectangle.height;
        }
        this.platformWindow.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public Rectangle constrainBounds(Rectangle rectangle) {
        return this.constrainBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle constrainBounds(int n, int n2, int n3, int n4) {
        if (n3 < 1) {
            n3 = 1;
        }
        if (n4 < 1) {
            n4 = 1;
        }
        int n5 = this.getLWGC().getMaxTextureWidth();
        int n6 = this.getLWGC().getMaxTextureHeight();
        if (n3 > n5) {
            n3 = n5;
        }
        if (n4 > n6) {
            n4 = n6;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    @Override
    public Point getLocationOnScreen() {
        return this.platformWindow.getLocationOnScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Insets getInsets() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.insets;
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.platformWindow.getFontMetrics(font);
    }

    @Override
    public void toFront() {
        this.platformWindow.toFront();
    }

    @Override
    public void toBack() {
        this.platformWindow.toBack();
    }

    @Override
    public void setZOrder(ComponentPeer componentPeer) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void updateAlwaysOnTopState() {
        this.platformWindow.setAlwaysOnTop(((Window)this.getTarget()).isAlwaysOnTop());
    }

    @Override
    public void updateFocusableWindowState() {
        this.platformWindow.updateFocusableWindowState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModalBlocked(Dialog dialog, boolean bl) {
        Object object = LWWindowPeer.getPeerTreeLock();
        synchronized (object) {
            ComponentPeer componentPeer = AWTAccessor.getComponentAccessor().getPeer(dialog);
            this.blocker = bl && componentPeer instanceof LWWindowPeer ? (LWWindowPeer)componentPeer : null;
        }
        this.platformWindow.setModalBlocked(bl);
    }

    @Override
    public void updateMinimumSize() {
        Dimension dimension;
        Dimension dimension2;
        if (((Window)this.getTarget()).isMinimumSizeSet()) {
            dimension2 = ((Window)this.getTarget()).getMinimumSize();
            dimension2.width = Math.max(dimension2.width, 1);
            dimension2.height = Math.max(dimension2.height, 1);
        } else {
            dimension2 = new Dimension(1, 1);
        }
        if (((Window)this.getTarget()).isMaximumSizeSet()) {
            dimension = ((Window)this.getTarget()).getMaximumSize();
            dimension.width = Math.min(dimension.width, this.getLWGC().getMaxTextureWidth());
            dimension.height = Math.min(dimension.height, this.getLWGC().getMaxTextureHeight());
        } else {
            dimension = new Dimension(this.getLWGC().getMaxTextureWidth(), this.getLWGC().getMaxTextureHeight());
        }
        this.platformWindow.setSizeConstraints(dimension2.width, dimension2.height, dimension.width, dimension.height);
    }

    @Override
    public void updateIconImages() {
        this.getPlatformWindow().updateIconImages();
    }

    @Override
    public void setOpacity(float f) {
        this.getPlatformWindow().setOpacity(f);
        this.repaintPeer();
    }

    @Override
    public final void setOpaque(boolean bl) {
        if (this.isOpaque != bl) {
            this.isOpaque = bl;
            this.updateOpaque();
        }
    }

    private void updateOpaque() {
        this.getPlatformWindow().setOpaque(!this.isTranslucent());
        this.replaceSurfaceData(false);
        this.repaintPeer();
    }

    @Override
    public void updateWindow() {
    }

    public final boolean isTextured() {
        return this.textured;
    }

    public final void setTextured(boolean bl) {
        this.textured = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isTranslucent() {
        Object object = this.getStateLock();
        synchronized (object) {
            return !this.isOpaque || this.isShaped() || this.isTextured();
        }
    }

    @Override
    final void applyShapeImpl(Region region) {
        super.applyShapeImpl(region);
        this.updateOpaque();
    }

    @Override
    public void repositionSecurityWarning() {
        if (this.warningWindow != null) {
            AWTAccessor.ComponentAccessor componentAccessor = AWTAccessor.getComponentAccessor();
            Window window = (Window)this.getTarget();
            int n = componentAccessor.getX(window);
            int n2 = componentAccessor.getY(window);
            int n3 = componentAccessor.getWidth(window);
            int n4 = componentAccessor.getHeight(window);
            this.warningWindow.reposition(n, n2, n3, n4);
        }
    }

    @Override
    public void setTitle(String string) {
        this.platformWindow.setTitle(string == null ? "" : string);
    }

    @Override
    public void setMenuBar(MenuBar menuBar) {
        this.platformWindow.setMenuBar(menuBar);
    }

    @Override
    public void setResizable(boolean bl) {
        this.platformWindow.setResizable(bl);
    }

    @Override
    public void setState(int n) {
        this.platformWindow.setWindowState(n);
    }

    @Override
    public int getState() {
        return this.windowState;
    }

    @Override
    public void setMaximizedBounds(Rectangle rectangle) {
    }

    @Override
    public void setBoundsPrivate(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, 16387);
    }

    @Override
    public Rectangle getBoundsPrivate() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void blockWindows(List<Window> list) {
        for (Window window : list) {
            WindowPeer windowPeer = (WindowPeer)AWTAccessor.getComponentAccessor().getPeer(window);
            if (windowPeer == null) continue;
            windowPeer.setModalBlocked((Dialog)this.getTarget(), true);
        }
    }

    @Override
    public void notifyIconify(boolean bl) {
        WindowEvent windowEvent = new WindowEvent((Window)this.getTarget(), bl ? 203 : 204);
        this.postEvent(windowEvent);
        int n = bl ? 1 : 0;
        this.postWindowStateChangedEvent(n);
        if (!bl) {
            this.repaintPeer();
        }
    }

    @Override
    public void notifyZoom(boolean bl) {
        int n = bl ? 6 : 0;
        this.postWindowStateChangedEvent(n);
    }

    @Override
    public void notifyExpose(Rectangle rectangle) {
        this.repaintPeer(rectangle);
    }

    @Override
    public void notifyReshape(int n, int n2, int n3, int n4) {
        boolean bl;
        Rectangle rectangle = this.getBounds();
        boolean bl2 = this.updateInsets(this.platformWindow.getInsets());
        boolean bl3 = n != rectangle.x || n2 != rectangle.y;
        boolean bl4 = bl = n3 != rectangle.width || n4 != rectangle.height;
        if (!(bl3 || bl || bl2)) {
            return;
        }
        this.setBounds(n, n2, n3, n4, 3, false, false);
        boolean bl5 = this.updateGraphicsDevice();
        if (bl || bl5) {
            this.replaceSurfaceData();
        }
        if (bl3 || bl2) {
            this.handleMove(n, n2, true);
        }
        if (bl || bl2 || bl5) {
            this.handleResize(n3, n4, true);
            this.repaintPeer();
        }
        this.repositionSecurityWarning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBackground(int n, int n2) {
        Graphics graphics = this.getOnscreenGraphics(this.getForeground(), this.getBackground(), this.getFont());
        if (graphics != null) {
            try {
                if (graphics instanceof Graphics2D) {
                    ((Graphics2D)graphics).setComposite(AlphaComposite.Src);
                }
                if (this.isTranslucent()) {
                    graphics.setColor(nonOpaqueBackground);
                    graphics.fillRect(0, 0, n, n2);
                }
                if (!this.isTextured()) {
                    if (graphics instanceof SunGraphics2D) {
                        ((SunGraphics2D)graphics).constrain(0, 0, n, n2, this.getRegion());
                    }
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, n, n2);
                }
            }
            finally {
                graphics.dispose();
            }
        }
    }

    @Override
    public void notifyUpdateCursor() {
        this.getLWToolkit().getCursorManager().updateCursorLater(this);
    }

    @Override
    public void notifyActivation(boolean bl, LWWindowPeer lWWindowPeer) {
        Window window = lWWindowPeer == null ? null : (Window)lWWindowPeer.getTarget();
        this.changeFocusedWindow(bl, window);
    }

    @Override
    public void notifyNCMouseDown() {
        if (grabbingWindow != null && grabbingWindow != LWWindowPeer.getOwnerFrameDialog(this)) {
            grabbingWindow.ungrab();
        }
    }

    @Override
    public void notifyMouseEvent(int n, long l, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, byte[] byArray) {
        Rectangle rectangle = this.getBounds();
        LWWindowPeer lWWindowPeer = this.findPeerAt(rectangle.x + n3, rectangle.y + n4);
        if (n == 505) {
            this.isMouseOver = false;
            if (this.lastMouseEventPeer != null) {
                if (this.lastMouseEventPeer.isEnabled()) {
                    Point point = this.lastMouseEventPeer.windowToLocal(n3, n4, this);
                    Object obj = this.lastMouseEventPeer.getTarget();
                    this.postMouseExitedEvent((Component)obj, l, n7, point, n5, n6, n8, bl, n2);
                }
                if (lastCommonMouseEventPeer != null && lastCommonMouseEventPeer.getWindowPeerOrSelf() == this) {
                    lastCommonMouseEventPeer = null;
                }
                this.lastMouseEventPeer = null;
            }
        } else if (n == 504) {
            this.isMouseOver = true;
            if (lWWindowPeer != null) {
                if (lWWindowPeer.isEnabled()) {
                    Point point = lWWindowPeer.windowToLocal(n3, n4, this);
                    Object obj = lWWindowPeer.getTarget();
                    this.postMouseEnteredEvent((Component)obj, l, n7, point, n5, n6, n8, bl, n2);
                }
                lastCommonMouseEventPeer = lWWindowPeer;
                this.lastMouseEventPeer = lWWindowPeer;
            }
        } else {
            int n9;
            LWWindowPeer lWWindowPeer2;
            PlatformWindow platformWindow = this.platformWindow.getTopmostPlatformWindowUnderMouse();
            LWWindowPeer lWWindowPeer3 = lWWindowPeer2 = platformWindow != null ? platformWindow.getPeer() : null;
            if (lWWindowPeer2 == this || lWWindowPeer2 == null) {
                this.generateMouseEnterExitEventsForComponents(l, n2, n3, n4, n5, n6, n7, n8, bl, lWWindowPeer);
            } else {
                LWComponentPeer<?, ?> lWComponentPeer = lWWindowPeer2 != null ? lWWindowPeer2.findPeerAt(rectangle.x + n3, rectangle.y + n4) : null;
                lWWindowPeer2.generateMouseEnterExitEventsForComponents(l, n2, n3, n4, n5, n6, n7, n8, bl, lWComponentPeer);
            }
            int n10 = n2 > 0 ? MouseEvent.getMaskForButton(n2) : 0;
            int n11 = n7 & ~n10;
            int n12 = n9 = n2 > 3 ? 1 : n2 - 1;
            if (n == 501) {
                if (!this.isGrabbing() && grabbingWindow != null && grabbingWindow != LWWindowPeer.getOwnerFrameDialog(this)) {
                    grabbingWindow.ungrab();
                }
                mouseClickButtons = n11 == 0 ? n10 : (mouseClickButtons |= n10);
                this.requestWindowFocus(CausedFocusEvent.Cause.MOUSE_EVENT);
                LWWindowPeer.mouseDownTarget[n9] = lWWindowPeer;
            } else if (n == 506) {
                lWWindowPeer = mouseDownTarget[n9];
                mouseClickButtons &= ~n7;
            } else if (n == 502) {
                lWWindowPeer = mouseDownTarget[n9];
                if ((n7 & n10) == 0) {
                    LWWindowPeer.mouseDownTarget[n9] = null;
                }
            }
            if (lWWindowPeer == null) {
                lWWindowPeer = this;
            }
            Point point = lWWindowPeer.windowToLocal(n3, n4, this);
            if (lWWindowPeer.isEnabled()) {
                MouseEvent mouseEvent = new MouseEvent((Component)lWWindowPeer.getTarget(), n, l, n7, point.x, point.y, n5, n6, n8, bl, n2);
                this.postEvent(mouseEvent);
            }
            if (n == 502) {
                if ((mouseClickButtons & n10) != 0 && lWWindowPeer.isEnabled()) {
                    this.postEvent(new MouseEvent((Component)lWWindowPeer.getTarget(), 500, l, n7, point.x, point.y, n5, n6, n8, bl, n2));
                }
                mouseClickButtons &= ~n10;
            }
        }
        this.notifyUpdateCursor();
    }

    private void generateMouseEnterExitEventsForComponents(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, LWComponentPeer<?, ?> lWComponentPeer) {
        Object obj;
        Point point;
        if (!this.isMouseOver || lWComponentPeer == this.lastMouseEventPeer) {
            return;
        }
        if (this.lastMouseEventPeer != null && this.lastMouseEventPeer.isEnabled()) {
            point = this.lastMouseEventPeer.windowToLocal(n2, n3, this);
            obj = this.lastMouseEventPeer.getTarget();
            this.postMouseExitedEvent((Component)obj, l, n6, point, n4, n5, n7, bl, n);
        }
        lastCommonMouseEventPeer = lWComponentPeer;
        this.lastMouseEventPeer = lWComponentPeer;
        if (lWComponentPeer != null && lWComponentPeer.isEnabled()) {
            point = lWComponentPeer.windowToLocal(n2, n3, this);
            obj = lWComponentPeer.getTarget();
            this.postMouseEnteredEvent((Component)obj, l, n6, point, n4, n5, n7, bl, n);
        }
    }

    private void postMouseEnteredEvent(Component component, long l, int n, Point point, int n2, int n3, int n4, boolean bl, int n5) {
        this.updateSecurityWarningVisibility();
        this.postEvent(new MouseEvent(component, 504, l, n, point.x, point.y, n2, n3, n4, bl, n5));
    }

    private void postMouseExitedEvent(Component component, long l, int n, Point point, int n2, int n3, int n4, boolean bl, int n5) {
        this.updateSecurityWarningVisibility();
        this.postEvent(new MouseEvent(component, 505, l, n, point.x, point.y, n2, n3, n4, bl, n5));
    }

    @Override
    public void notifyMouseWheelEvent(long l, int n, int n2, int n3, int n4, int n5, int n6, double d, byte[] byArray) {
        Rectangle rectangle = this.getBounds();
        LWComponentPeer<?, ?> lWComponentPeer = this.findPeerAt(rectangle.x + n, rectangle.y + n2);
        if (lWComponentPeer == null || !lWComponentPeer.isEnabled()) {
            return;
        }
        Point point = lWComponentPeer.windowToLocal(n, n2, this);
        this.postEvent(new MouseWheelEvent((Component)lWComponentPeer.getTarget(), 507, l, n3, point.x, point.y, 0, 0, 0, false, n4, n5, n6, d));
    }

    @Override
    public void notifyKeyEvent(int n, long l, int n2, int n3, char c, int n4) {
        LWKeyboardFocusManagerPeer lWKeyboardFocusManagerPeer = LWKeyboardFocusManagerPeer.getInstance();
        Component component = lWKeyboardFocusManagerPeer.getCurrentFocusOwner();
        if (component == null && (component = lWKeyboardFocusManagerPeer.getCurrentFocusedWindow()) == null) {
            component = this.getTarget();
        }
        KeyEvent keyEvent = new KeyEvent(component, n, l, n2, n3, c, n4);
        AWTAccessor.getKeyEventAccessor().setExtendedKeyCode(keyEvent, c == '\uffff' ? (long)n3 : (long)ExtendedKeyCodes.getExtendedKeyCodeForChar(c));
        this.postEvent(keyEvent);
    }

    private void activateDisplayListener() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ((SunGraphicsEnvironment)graphicsEnvironment).addDisplayChangedListener(this);
    }

    private void deactivateDisplayListener() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ((SunGraphicsEnvironment)graphicsEnvironment).removeDisplayChangedListener(this);
    }

    private void postWindowStateChangedEvent(int n) {
        if (this.getTarget() instanceof Frame) {
            AWTAccessor.getFrameAccessor().setExtendedState((Frame)this.getTarget(), n);
        }
        WindowEvent windowEvent = new WindowEvent((Window)this.getTarget(), 209, this.windowState, n);
        this.postEvent(windowEvent);
        this.windowState = n;
        this.updateSecurityWarningVisibility();
    }

    private static int getGraphicsConfigScreen(GraphicsConfiguration graphicsConfiguration) {
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            if (graphicsDeviceArray[i] != graphicsDevice) continue;
            return i;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setGraphicsConfig(GraphicsConfiguration graphicsConfiguration) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.graphicsConfig == graphicsConfiguration) {
                return false;
            }
            this.graphicsConfig = graphicsConfiguration;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateGraphicsDevice() {
        GraphicsDevice graphicsDevice = this.platformWindow.getGraphicsDevice();
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.graphicsDevice == graphicsDevice) {
                return false;
            }
            this.graphicsDevice = graphicsDevice;
        }
        object = graphicsDevice.getDefaultConfiguration();
        if (!this.setGraphicsConfig((GraphicsConfiguration)object)) {
            return false;
        }
        SunToolkit.executeOnEventHandlerThread(this.getTarget(), new Runnable((GraphicsConfiguration)object){
            final /* synthetic */ GraphicsConfiguration val$newGC;
            {
                this.val$newGC = graphicsConfiguration;
            }

            @Override
            public void run() {
                AWTAccessor.getComponentAccessor().setGraphicsConfiguration((Component)LWWindowPeer.this.getTarget(), this.val$newGC);
            }
        });
        return true;
    }

    @Override
    public final void displayChanged() {
        this.updateGraphicsDevice();
        this.replaceSurfaceData();
        this.repaintPeer();
    }

    @Override
    public final void paletteChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceData getSurfaceData() {
        Object object = this.surfaceDataLock;
        synchronized (object) {
            return this.surfaceData;
        }
    }

    private void replaceSurfaceData() {
        this.replaceSurfaceData(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSurfaceData(boolean bl) {
        Object object = this.surfaceDataLock;
        synchronized (object) {
            SurfaceData surfaceData = this.getSurfaceData();
            this.surfaceData = this.platformWindow.replaceSurfaceData();
            Rectangle rectangle = this.getSize();
            if (this.getSurfaceData() != null && surfaceData != this.getSurfaceData()) {
                this.clearBackground(rectangle.width, rectangle.height);
            }
            if (bl) {
                this.blitSurfaceData(surfaceData, this.getSurfaceData());
            }
            if (surfaceData != null && surfaceData != this.getSurfaceData()) {
                surfaceData.flush();
            }
        }
        LWWindowPeer.flushOnscreenGraphics();
    }

    private void blitSurfaceData(SurfaceData surfaceData, SurfaceData surfaceData2) {
        if (surfaceData != surfaceData2 && surfaceData != null && surfaceData2 != null && !(surfaceData2 instanceof NullSurfaceData) && !(surfaceData instanceof NullSurfaceData) && surfaceData.getSurfaceType().equals(surfaceData2.getSurfaceType()) && surfaceData.getDefaultScale() == surfaceData2.getDefaultScale()) {
            Rectangle rectangle = surfaceData.getBounds();
            Blit blit = Blit.locate(surfaceData.getSurfaceType(), CompositeType.Src, surfaceData2.getSurfaceType());
            if (blit != null) {
                blit.Blit(surfaceData, surfaceData2, AlphaComposite.Src, null, 0, 0, 0, 0, rectangle.width, rectangle.height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean updateInsets(Insets insets) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.insets.equals(insets)) {
                return false;
            }
            this.insets = insets;
        }
        return true;
    }

    public static LWWindowPeer getWindowUnderCursor() {
        return lastCommonMouseEventPeer != null ? lastCommonMouseEventPeer.getWindowPeerOrSelf() : null;
    }

    public static LWComponentPeer<?, ?> getPeerUnderCursor() {
        return lastCommonMouseEventPeer;
    }

    public boolean requestWindowFocus(CausedFocusEvent.Cause cause) {
        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
            focusLog.fine("requesting native focus to " + this);
        }
        if (!this.focusAllowedFor()) {
            focusLog.fine("focus is not allowed");
            return false;
        }
        if (this.platformWindow.rejectFocusRequest(cause)) {
            return false;
        }
        AppContext appContext = AWTAccessor.getComponentAccessor().getAppContext((Component)this.getTarget());
        KeyboardFocusManager keyboardFocusManager = AWTAccessor.getKeyboardFocusManagerAccessor().getCurrentKeyboardFocusManager(appContext);
        Window window = keyboardFocusManager.getActiveWindow();
        Window window2 = LWKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow();
        if (this.isSimpleWindow()) {
            LWWindowPeer lWWindowPeer = LWWindowPeer.getOwnerFrameDialog(this);
            if (lWWindowPeer != null && !lWWindowPeer.platformWindow.isActive()) {
                LWWindowPeer lWWindowPeer2;
                if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                    focusLog.fine("requesting native focus to the owner " + lWWindowPeer);
                }
                LWWindowPeer lWWindowPeer3 = lWWindowPeer2 = window == null ? null : (LWWindowPeer)AWTAccessor.getComponentAccessor().getPeer(window);
                if (lWWindowPeer2 != null && lWWindowPeer2.platformWindow.isActive()) {
                    if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                        focusLog.fine("the opposite is " + lWWindowPeer2);
                    }
                    lWWindowPeer2.skipNextFocusChange = true;
                }
                lWWindowPeer.skipNextFocusChange = true;
                lWWindowPeer.platformWindow.requestWindowFocus();
            }
            this.changeFocusedWindow(true, window2);
            return true;
        }
        if (this.getTarget() == window && !((Window)this.getTarget()).hasFocus()) {
            this.changeFocusedWindow(true, window2);
            return true;
        }
        return this.platformWindow.requestWindowFocus();
    }

    protected boolean focusAllowedFor() {
        Window window = (Window)this.getTarget();
        return window.isVisible() && window.isEnabled() && this.isFocusableWindow();
    }

    private boolean isFocusableWindow() {
        boolean bl = ((Window)this.getTarget()).isFocusableWindow();
        if (this.isSimpleWindow()) {
            LWWindowPeer lWWindowPeer = LWWindowPeer.getOwnerFrameDialog(this);
            if (lWWindowPeer == null) {
                return false;
            }
            return bl && ((Window)lWWindowPeer.getTarget()).isFocusableWindow();
        }
        return bl;
    }

    public boolean isSimpleWindow() {
        Window window = (Window)this.getTarget();
        return !(window instanceof Dialog) && !(window instanceof Frame);
    }

    @Override
    public void emulateActivation(boolean bl) {
        this.changeFocusedWindow(bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeFocusedWindow(boolean bl, Window window) {
        Object object;
        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
            focusLog.fine((bl ? "gaining" : "loosing") + " focus window: " + this);
        }
        if (this.skipNextFocusChange) {
            focusLog.fine("skipping focus change");
            this.skipNextFocusChange = false;
            return;
        }
        if (!this.isFocusableWindow() && bl) {
            focusLog.fine("the window is not focusable");
            return;
        }
        if (bl) {
            object = LWWindowPeer.getPeerTreeLock();
            synchronized (object) {
                if (this.blocker != null) {
                    if (focusLog.isLoggable(PlatformLogger.Level.FINEST)) {
                        focusLog.finest("the window is blocked by " + this.blocker);
                    }
                    return;
                }
            }
        }
        if (!bl && (this.isGrabbing() || LWWindowPeer.getOwnerFrameDialog(grabbingWindow) == this)) {
            if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                focusLog.fine("ungrabbing on " + grabbingWindow);
            }
            grabbingWindow.ungrab();
        }
        object = LWKeyboardFocusManagerPeer.getInstance();
        object.setCurrentFocusedWindow(bl ? (Window)this.getTarget() : null);
        int n = bl ? 207 : 208;
        TimedWindowEvent timedWindowEvent = new TimedWindowEvent((Window)this.getTarget(), n, window, System.currentTimeMillis());
        this.postEvent(timedWindowEvent);
    }

    static LWWindowPeer getOwnerFrameDialog(LWWindowPeer lWWindowPeer) {
        Window window;
        Window window2 = window = lWWindowPeer != null ? ((Window)lWWindowPeer.getTarget()).getOwner() : null;
        while (window != null && !(window instanceof Frame) && !(window instanceof Dialog)) {
            window = window.getOwner();
        }
        return window == null ? null : (LWWindowPeer)AWTAccessor.getComponentAccessor().getPeer(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LWWindowPeer getBlocker() {
        Object object = LWWindowPeer.getPeerTreeLock();
        synchronized (object) {
            LWWindowPeer lWWindowPeer = this.blocker;
            if (lWWindowPeer == null) {
                return null;
            }
            while (lWWindowPeer.blocker != null) {
                lWWindowPeer = lWWindowPeer.blocker;
            }
            return lWWindowPeer;
        }
    }

    @Override
    public void enterFullScreenMode() {
        this.platformWindow.enterFullScreenMode();
        this.updateSecurityWarningVisibility();
    }

    @Override
    public void exitFullScreenMode() {
        this.platformWindow.exitFullScreenMode();
        this.updateSecurityWarningVisibility();
    }

    public long getLayerPtr() {
        return this.getPlatformWindow().getLayerPtr();
    }

    void grab() {
        if (grabbingWindow != null && !this.isGrabbing()) {
            grabbingWindow.ungrab();
        }
        grabbingWindow = this;
    }

    final void ungrab(boolean bl) {
        if (this.isGrabbing()) {
            grabbingWindow = null;
            if (bl) {
                this.postEvent(new UngrabEvent((Component)this.getTarget()));
            }
        }
    }

    void ungrab() {
        this.ungrab(true);
    }

    private boolean isGrabbing() {
        return this == grabbingWindow;
    }

    public PeerType getPeerType() {
        return this.peerType;
    }

    public void updateSecurityWarningVisibility() {
        if (this.warningWindow == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl = false;
        if (!this.platformWindow.isFullScreenMode() && this.isVisible()) {
            if (LWKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow() == this.getTarget()) {
                bl = true;
            }
            if (this.platformWindow.isUnderMouse() || this.warningWindow.isUnderMouse()) {
                bl = true;
            }
        }
        this.warningWindow.setVisible(bl, true);
    }

    public String toString() {
        return super.toString() + " [target is " + this.getTarget() + "]";
    }

    static {
        mouseDownTarget = new LWComponentPeer[3];
        mouseClickButtons = 0;
        DEFAULT_FONT = new Font("Lucida Grande", 0, 13);
        nonOpaqueBackground = new Color(0, 0, 0, 0);
    }

    public static enum PeerType {
        SIMPLEWINDOW,
        FRAME,
        DIALOG,
        EMBEDDED_FRAME,
        VIEW_EMBEDDED_FRAME,
        LW_FRAME;

    }
}

