/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AcceptPendingException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.NotYetBoundException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.AsynchronousServerSocketChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.Port;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.UnixAsynchronousSocketChannelImpl;

class UnixAsynchronousServerSocketChannelImpl
extends AsynchronousServerSocketChannelImpl
implements Port.PollableChannel {
    private static final NativeDispatcher nd = new SocketDispatcher();
    private final Port port;
    private final int fdVal;
    private final AtomicBoolean accepting = new AtomicBoolean();
    private final Object updateLock = new Object();
    private boolean acceptPending;
    private CompletionHandler<AsynchronousSocketChannel, Object> acceptHandler;
    private Object acceptAttachment;
    private PendingFuture<AsynchronousSocketChannel, Object> acceptFuture;
    private AccessControlContext acceptAcc;

    private void enableAccept() {
        this.accepting.set(false);
    }

    UnixAsynchronousServerSocketChannelImpl(Port port) throws IOException {
        super(port);
        try {
            IOUtil.configureBlocking(this.fd, false);
        }
        catch (IOException iOException) {
            nd.close(this.fd);
            throw iOException;
        }
        this.port = port;
        this.fdVal = IOUtil.fdVal(this.fd);
        port.register(this.fdVal, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void implClose() throws IOException {
        PendingFuture<AsynchronousSocketChannel, Object> pendingFuture;
        Object object;
        CompletionHandler<AsynchronousSocketChannel, Object> completionHandler;
        this.port.unregister(this.fdVal);
        nd.close(this.fd);
        Object object2 = this.updateLock;
        synchronized (object2) {
            if (!this.acceptPending) {
                return;
            }
            this.acceptPending = false;
            completionHandler = this.acceptHandler;
            object = this.acceptAttachment;
            pendingFuture = this.acceptFuture;
        }
        object2 = new AsynchronousCloseException();
        ((Throwable)object2).setStackTrace(new StackTraceElement[0]);
        if (completionHandler == null) {
            pendingFuture.setFailure((Throwable)object2);
        } else {
            Invoker.invokeIndirectly(this, completionHandler, object, null, (Throwable)object2);
        }
    }

    @Override
    public AsynchronousChannelGroupImpl group() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(int n, boolean bl) {
        Object object;
        CompletionHandler<AsynchronousSocketChannel, Object> completionHandler;
        InetSocketAddress[] inetSocketAddressArray;
        Object object2;
        block22: {
            object2 = this.updateLock;
            synchronized (object2) {
                if (!this.acceptPending) {
                    return;
                }
                this.acceptPending = false;
            }
            object2 = new FileDescriptor();
            inetSocketAddressArray = new InetSocketAddress[1];
            completionHandler = null;
            try {
                this.begin();
                int n2 = this.accept0(this.fd, (FileDescriptor)object2, inetSocketAddressArray);
                if (n2 != -2) break block22;
                Object object3 = this.updateLock;
                synchronized (object3) {
                    this.acceptPending = true;
                }
                this.port.startPoll(this.fdVal, 1);
                return;
            }
            catch (Throwable throwable) {
                AsynchronousCloseException asynchronousCloseException;
                if (throwable instanceof ClosedChannelException) {
                    asynchronousCloseException = new AsynchronousCloseException();
                }
                completionHandler = asynchronousCloseException;
            }
            finally {
                this.end();
            }
        }
        AsynchronousSocketChannel asynchronousSocketChannel = null;
        if (completionHandler == null) {
            try {
                asynchronousSocketChannel = this.finishAccept((FileDescriptor)object2, inetSocketAddressArray[0], this.acceptAcc);
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof IOException) && !(throwable instanceof SecurityException)) {
                    object = new IOException(throwable);
                }
                completionHandler = object;
            }
        }
        object = this.acceptHandler;
        Object object4 = this.acceptAttachment;
        PendingFuture<AsynchronousSocketChannel, Object> pendingFuture = this.acceptFuture;
        this.enableAccept();
        if (object == null) {
            pendingFuture.setResult(asynchronousSocketChannel, (Throwable)((Object)completionHandler));
            if (asynchronousSocketChannel != null && pendingFuture.isCancelled()) {
                try {
                    asynchronousSocketChannel.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            Invoker.invoke(this, object, object4, asynchronousSocketChannel, completionHandler);
        }
    }

    private AsynchronousSocketChannel finishAccept(FileDescriptor fileDescriptor, final InetSocketAddress inetSocketAddress, AccessControlContext accessControlContext) throws IOException, SecurityException {
        UnixAsynchronousSocketChannelImpl unixAsynchronousSocketChannelImpl = null;
        try {
            unixAsynchronousSocketChannelImpl = new UnixAsynchronousSocketChannelImpl(this.port, fileDescriptor, inetSocketAddress);
        }
        catch (IOException iOException) {
            nd.close(fileDescriptor);
            throw iOException;
        }
        try {
            if (accessControlContext != null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        SecurityManager securityManager = System.getSecurityManager();
                        if (securityManager != null) {
                            securityManager.checkAccept(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                        }
                        return null;
                    }
                }, accessControlContext);
            } else {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkAccept(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
            }
        }
        catch (SecurityException securityException) {
            try {
                unixAsynchronousSocketChannelImpl.close();
            }
            catch (Throwable throwable) {
                securityException.addSuppressed(throwable);
            }
            throw securityException;
        }
        return unixAsynchronousSocketChannelImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Future<AsynchronousSocketChannel> implAccept(Object object, CompletionHandler<AsynchronousSocketChannel, Object> completionHandler) {
        Throwable throwable;
        InetSocketAddress[] inetSocketAddressArray;
        FileDescriptor fileDescriptor;
        block20: {
            if (!this.isOpen()) {
                ClosedChannelException closedChannelException = new ClosedChannelException();
                if (completionHandler == null) {
                    return CompletedFuture.withFailure(closedChannelException);
                }
                Invoker.invoke(this, completionHandler, object, null, closedChannelException);
                return null;
            }
            if (this.localAddress == null) {
                throw new NotYetBoundException();
            }
            if (this.isAcceptKilled()) {
                throw new RuntimeException("Accept not allowed due cancellation");
            }
            if (!this.accepting.compareAndSet(false, true)) {
                throw new AcceptPendingException();
            }
            fileDescriptor = new FileDescriptor();
            inetSocketAddressArray = new InetSocketAddress[1];
            throwable = null;
            try {
                this.begin();
                int n = this.accept0(this.fd, fileDescriptor, inetSocketAddressArray);
                if (n != -2) break block20;
                PendingFuture pendingFuture = null;
                PendingFuture pendingFuture2 = this.updateLock;
                synchronized (pendingFuture2) {
                    if (completionHandler == null) {
                        this.acceptHandler = null;
                        pendingFuture = new PendingFuture(this);
                        this.acceptFuture = pendingFuture;
                    } else {
                        this.acceptHandler = completionHandler;
                        this.acceptAttachment = object;
                    }
                    this.acceptAcc = System.getSecurityManager() == null ? null : AccessController.getContext();
                    this.acceptPending = true;
                }
                this.port.startPoll(this.fdVal, 1);
                pendingFuture2 = pendingFuture;
                return pendingFuture2;
            }
            catch (Throwable throwable2) {
                AsynchronousCloseException asynchronousCloseException;
                if (throwable2 instanceof ClosedChannelException) {
                    asynchronousCloseException = new AsynchronousCloseException();
                }
                throwable = asynchronousCloseException;
            }
            finally {
                this.end();
            }
        }
        AsynchronousSocketChannel asynchronousSocketChannel = null;
        if (throwable == null) {
            try {
                asynchronousSocketChannel = this.finishAccept(fileDescriptor, inetSocketAddressArray[0], null);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
            }
        }
        this.enableAccept();
        if (completionHandler == null) {
            return CompletedFuture.withResult(asynchronousSocketChannel, throwable);
        }
        Invoker.invokeIndirectly(this, completionHandler, object, asynchronousSocketChannel, throwable);
        return null;
    }

    private static native void initIDs();

    private native int accept0(FileDescriptor var1, FileDescriptor var2, InetSocketAddress[] var3) throws IOException;

    static {
        IOUtil.load();
        UnixAsynchronousServerSocketChannelImpl.initIDs();
    }
}

