/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.InvalidKeyException;
import javax.crypto.spec.DESKeySpec;
import sun.security.krb5.Confounder;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.CksumType;
import sun.security.krb5.internal.crypto.Des;

public class DesMacCksumType
extends CksumType {
    @Override
    public int confounderSize() {
        return 8;
    }

    @Override
    public int cksumType() {
        return 4;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public int cksumSize() {
        return 16;
    }

    @Override
    public int keyType() {
        return 1;
    }

    @Override
    public int keySize() {
        return 8;
    }

    @Override
    public byte[] calculateChecksum(byte[] byArray, int n) {
        return null;
    }

    @Override
    public byte[] calculateKeyedChecksum(byte[] byArray, int n, byte[] byArray2, int n2) throws KrbCryptoException {
        byte[] byArray3 = new byte[n + this.confounderSize()];
        byte[] byArray4 = Confounder.bytes(this.confounderSize());
        System.arraycopy(byArray4, 0, byArray3, 0, this.confounderSize());
        System.arraycopy(byArray, 0, byArray3, this.confounderSize(), n);
        try {
            if (DESKeySpec.isWeak(byArray2, 0)) {
                byArray2[7] = (byte)(byArray2[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        byte[] byArray5 = new byte[byArray2.length];
        byte[] byArray6 = Des.des_cksum(byArray5, byArray3, byArray2);
        byte[] byArray7 = new byte[this.cksumSize()];
        System.arraycopy(byArray4, 0, byArray7, 0, this.confounderSize());
        System.arraycopy(byArray6, 0, byArray7, this.confounderSize(), this.cksumSize() - this.confounderSize());
        byte[] byArray8 = new byte[this.keySize()];
        System.arraycopy(byArray2, 0, byArray8, 0, byArray2.length);
        for (int i = 0; i < byArray8.length; ++i) {
            byArray8[i] = (byte)(byArray8[i] ^ 0xF0);
        }
        try {
            if (DESKeySpec.isWeak(byArray8, 0)) {
                byArray8[7] = (byte)(byArray8[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        byte[] byArray9 = new byte[byArray8.length];
        byte[] byArray10 = new byte[byArray7.length];
        Des.cbc_encrypt(byArray7, byArray10, byArray8, byArray9, true);
        return byArray10;
    }

    @Override
    public boolean verifyKeyedChecksum(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2) throws KrbCryptoException {
        byte[] byArray4 = this.decryptKeyedChecksum(byArray3, byArray2);
        byte[] byArray5 = new byte[n + this.confounderSize()];
        System.arraycopy(byArray4, 0, byArray5, 0, this.confounderSize());
        System.arraycopy(byArray, 0, byArray5, this.confounderSize(), n);
        try {
            if (DESKeySpec.isWeak(byArray2, 0)) {
                byArray2[7] = (byte)(byArray2[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        byte[] byArray6 = new byte[byArray2.length];
        byte[] byArray7 = Des.des_cksum(byArray6, byArray5, byArray2);
        byte[] byArray8 = new byte[this.cksumSize() - this.confounderSize()];
        System.arraycopy(byArray4, this.confounderSize(), byArray8, 0, this.cksumSize() - this.confounderSize());
        return DesMacCksumType.isChecksumEqual(byArray8, byArray7);
    }

    private byte[] decryptKeyedChecksum(byte[] byArray, byte[] byArray2) throws KrbCryptoException {
        byte[] byArray3 = new byte[this.keySize()];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)(byArray3[i] ^ 0xF0);
        }
        try {
            if (DESKeySpec.isWeak(byArray3, 0)) {
                byArray3[7] = (byte)(byArray3[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        byte[] byArray4 = new byte[byArray3.length];
        byte[] byArray5 = new byte[byArray.length];
        Des.cbc_encrypt(byArray, byArray5, byArray3, byArray4, false);
        return byArray5;
    }
}

