/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.DeployEmbeddedFrameIf;
import com.sun.deploy.uitoolkit.SynthesizedEventListener;
import com.sun.deploy.uitoolkit.impl.awt.ui.AWTDialog;
import com.sun.deploy.uitoolkit.ui.AbstractDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Map;
import java.util.Stack;
import sun.lwawt.macosx.CEmbeddedFrame;
import sun.plugin2.main.client.CALayerProvider;
import sun.plugin2.main.client.DetachedAppletController;
import sun.plugin2.main.client.ModalityInterface;
import sun.plugin2.main.client.Plugin2EventListener;
import sun.plugin2.main.client.RemoteCALayer;
import sun.plugin2.message.Pipe;
import sun.plugin2.util.NativeLibLoader;
import sun.plugin2.util.SystemUtil;

public class PluginEmbeddedFrame
extends CEmbeddedFrame
implements DeployEmbeddedFrameIf,
SynthesizedEventListener {
    private static final boolean VERBOSE = SystemUtil.getenv("JPI_PLUGIN2_VERBOSE") != null;
    RemoteCALayer remoteLayer;
    ModalityInterface modality;
    DetachedAppletController detachedAppletController;
    final Stack dialogStack = new Stack();
    Component baseComponent = null;

    public PluginEmbeddedFrame(long l, String string, boolean bl, ModalityInterface modalityInterface, Pipe pipe, int n) {
        this.modality = modalityInterface;
        Trace.println((String)("Creating PluginEmbeddedFrame served by " + string), (TraceLevel)TraceLevel.BASIC);
        CALayerProvider cALayerProvider = CALayerProvider.getInstanceForName(string);
        if (cALayerProvider == null) {
            throw new RuntimeException("Failed to create CALayerProvider");
        }
        this.remoteLayer = cALayerProvider.createRemoteLayerForLayer(this.getLayerPtr());
        Trace.println((String)"Done creating PluginEmbeddedFrame", (TraceLevel)TraceLevel.BASIC);
    }

    public void dispose() {
        if (this.remoteLayer != null) {
            this.remoteLayer.dispose();
        }
        super.dispose();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.remoteLayer != null) {
            this.nativeSetBounds(this.getLayerPtr(), n3, n4);
        }
    }

    private native void nativeSetBounds(long var1, int var3, int var4);

    public void notifyModalBlocked(Dialog dialog, boolean bl) {
        if (this.modality != null) {
            if (bl) {
                this.modality.modalityPushed((AbstractDialog)AWTDialog.getAWTDialog((Dialog)dialog));
            } else {
                this.modality.modalityPopped((AbstractDialog)AWTDialog.getAWTDialog((Dialog)dialog));
            }
        }
    }

    private void synthesizeKeyEvent(Map map) {
        if (VERBOSE) {
            System.out.println("KeyEvent");
        }
        int n = (Integer)map.get("type");
        int n2 = (Integer)map.get("modifierFlags");
        String string = (String)map.get("characters");
        String string2 = (String)map.get("charactersIgnoringModifiers");
        boolean bl = (Boolean)map.get("isARepeat");
        int n3 = (Integer)map.get("keyCode");
        boolean bl2 = (Boolean)map.get("needsKeyTyped");
        this.handleKeyEvent(n, n2, string, string2, bl, (short)n3, bl2);
    }

    private void synthesizeMouseEvent(Map map) {
        if (VERBOSE) {
            System.out.println("MouseEvent");
        }
        int n = (Integer)map.get("type");
        double d = (Double)map.get("pluginX");
        double d2 = (Double)map.get("pluginY");
        int n2 = (Integer)map.get("modifierFlags");
        int n3 = (Integer)map.get("buttonNumber");
        int n4 = (Integer)map.get("clickCount");
        this.handleMouseEvent(n, n2, d, d2, n3, n4);
    }

    private void synthesizeScrollEvent(Map map) {
        if (VERBOSE) {
            System.out.println("ScrollEvent");
        }
        double d = (Double)map.get("pluginX");
        double d2 = (Double)map.get("pluginY");
        int n = (Integer)map.get("modifierFlags");
        double d3 = (Double)map.get("deltaX");
        double d4 = (Double)map.get("deltaY");
        double d5 = (Double)map.get("deltaZ");
        this.handleScrollEvent(d, d2, n, d3, d4, d5);
    }

    private void synthesizeTextEvent(Map map) {
        if (VERBOSE) {
            System.out.println("TextEvent");
        }
        this.handleInputEvent((String)map.get("text"));
    }

    private void synthesizeOverlayWindowMoveEvent(Map map) {
        double d = (Double)map.get("x");
        double d2 = (Double)map.get("y");
        if (VERBOSE) {
            System.out.println("Moving window to " + d + ", " + d2);
        }
        this.setLocation((int)d, (int)d2);
    }

    private void synthesizeWindowActivationEvent(Map map) {
        boolean bl = (Boolean)map.get("hasFocus");
        if (VERBOSE) {
            System.out.println("Setting window active state to " + bl);
        }
        this.handleWindowFocusEvent(bl);
    }

    public void synthesizeWindowActivation(boolean bl) {
        if (VERBOSE) {
            System.out.println("Setting window active state to " + bl);
        }
        this.handleWindowFocusEvent(bl);
    }

    private void synthesizeFocusEvent(Map map) {
        boolean bl = (Boolean)map.get("hasFocus");
        if (VERBOSE) {
            System.out.println("Setting focus to " + bl);
        }
        this.handleFocusEvent(bl);
    }

    public void synthesizeEvent(Map map) {
        int n = (Integer)map.get("type");
        switch (n) {
            case 11: {
                this.synthesizeFocusEvent(map);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                this.synthesizeKeyEvent(map);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.synthesizeMouseEvent(map);
                break;
            }
            case 13: {
                this.synthesizeScrollEvent(map);
                break;
            }
            case 14: {
                this.synthesizeTextEvent(map);
                break;
            }
            case 12: {
                this.synthesizeWindowActivationEvent(map);
                break;
            }
            default: {
                Trace.println((String)("No such event type!! " + n), (TraceLevel)TraceLevel.UI);
            }
        }
    }

    DetachedAppletController getDetachedAppletController() {
        if (this.detachedAppletController != null) {
            return this.detachedAppletController;
        }
        this.detachedAppletController = new DetachedAppletController((Window)((Object)this), null);
        return this.detachedAppletController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component component, Object object, int n) {
        Stack stack = this.dialogStack;
        synchronized (stack) {
            this.baseComponent = component;
            if (this.dialogStack.empty()) {
                super.addImpl(component, object, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Stack stack = this.dialogStack;
        synchronized (stack) {
            this.baseComponent = null;
            if (this.dialogStack.empty()) {
                super.removeAll();
            }
        }
    }

    public void remove(int n) {
        if (n == 0) {
            this.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Component component) {
        Stack stack = this.dialogStack;
        synchronized (stack) {
            this.dialogStack.push(component);
            super.removeAll();
            super.addImpl(component, (Object)"Center", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component pop() {
        Stack stack = this.dialogStack;
        synchronized (stack) {
            Component component = this.dialogStack.empty() ? null : (Component)this.dialogStack.pop();
            Component component2 = this.dialogStack.empty() ? null : (Component)this.dialogStack.peek();
            super.removeAll();
            if (component2 != null) {
                super.addImpl(component2, (Object)"Center", 0);
            } else if (this.baseComponent != null) {
                super.addImpl(this.baseComponent, (Object)"Center", 0);
            }
            return component;
        }
    }

    public int getLayerID() {
        if (this.remoteLayer != null) {
            return this.remoteLayer.getLayerId();
        }
        return -1;
    }

    static {
        Plugin2EventListener.getInstance();
        NativeLibLoader.load(new String[]{"npjp2"});
    }
}

