/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import jdk.nashorn.internal.codegen.types.Type;

final class CompiledFunction
implements Comparable<CompiledFunction> {
    private final MethodType type;
    private final MethodHandle invoker;
    private MethodHandle constructor;

    CompiledFunction(MethodType type, MethodHandle invoker) {
        this(type, invoker, null);
    }

    CompiledFunction(MethodType type, MethodHandle invoker, MethodHandle constructor) {
        assert (type != null);
        this.type = type;
        this.invoker = invoker;
        this.constructor = constructor;
    }

    public String toString() {
        return "<callSiteType= " + this.type + " invoker=" + this.invoker + " ctor=" + this.constructor + ">";
    }

    MethodHandle getInvoker() {
        return this.invoker;
    }

    MethodHandle getConstructor() {
        return this.constructor;
    }

    void setConstructor(MethodHandle constructor) {
        this.constructor = constructor;
    }

    boolean hasConstructor() {
        return this.constructor != null;
    }

    MethodType type() {
        return this.type;
    }

    @Override
    public int compareTo(CompiledFunction o) {
        return CompiledFunction.compareMethodTypes(this.type(), o.type());
    }

    private static int compareMethodTypes(MethodType ownType, MethodType otherType) {
        if (ownType.equals((Object)otherType)) {
            return 0;
        }
        int diff = CompiledFunction.weight(ownType) - CompiledFunction.weight(otherType);
        if (diff != 0) {
            return diff;
        }
        if (ownType.parameterCount() != otherType.parameterCount()) {
            return ownType.parameterCount() - otherType.parameterCount();
        }
        return ownType.hashCode() - otherType.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CompiledFunction && this.type().equals((Object)((CompiledFunction)obj).type());
    }

    public int hashCode() {
        return this.type().hashCode();
    }

    private int weight() {
        return CompiledFunction.weight(this.type());
    }

    private static int weight(MethodType type) {
        if (CompiledFunction.isVarArgsType(type)) {
            return Integer.MAX_VALUE;
        }
        int weight = Type.typeFor(type.returnType()).getWeight();
        for (Class<?> paramType : type.parameterArray()) {
            int pweight = Type.typeFor(paramType).getWeight() * 2;
            weight += pweight;
        }
        return weight;
    }

    private static boolean isVarArgsType(MethodType type) {
        assert (type.parameterCount() >= 1) : type;
        return type.parameterType(type.parameterCount() - 1) == Object[].class;
    }

    boolean moreGenericThan(CompiledFunction o) {
        return this.weight() > o.weight();
    }

    boolean moreGenericThan(MethodType mt) {
        return this.weight() > CompiledFunction.weight(mt);
    }

    boolean typeCompatible(MethodType mt) {
        int existingParamCount;
        int wantedParamCount = mt.parameterCount();
        if (wantedParamCount != (existingParamCount = this.type.parameterCount()) && !CompiledFunction.isVarArgsType(mt)) {
            return false;
        }
        int lastParamIndex = Math.min(wantedParamCount, existingParamCount);
        for (int i = 0; i < lastParamIndex; ++i) {
            Type w = Type.typeFor(mt.parameterType(i));
            Type e = Type.typeFor(this.type.parameterType(i));
            if (w.isBoolean()) {
                return false;
            }
            if (e.isArray()) {
                return true;
            }
            if (Type.widest(w, e) == e) continue;
            return false;
        }
        return true;
    }
}

