/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.beans.BeansLinker;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.internal.dynalink.linker.GuardedTypeConversion;
import jdk.internal.dynalink.linker.GuardingDynamicLinker;
import jdk.internal.dynalink.linker.GuardingTypeConverterFactory;
import jdk.internal.dynalink.linker.LinkRequest;
import jdk.internal.dynalink.linker.LinkerServices;
import jdk.internal.dynalink.support.Guards;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Bootstrap;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import jdk.nashorn.internal.runtime.linker.NashornLinker;

final class NashornBottomLinker
implements GuardingDynamicLinker,
GuardingTypeConverterFactory {
    private static final MethodHandle EMPTY_PROP_GETTER = Lookup.MH.dropArguments(Lookup.MH.constant(Object.class, ScriptRuntime.UNDEFINED), 0, Object.class);
    private static final MethodHandle EMPTY_ELEM_GETTER = Lookup.MH.dropArguments(EMPTY_PROP_GETTER, 0, Object.class);
    private static final MethodHandle EMPTY_PROP_SETTER = Lookup.MH.asType(EMPTY_ELEM_GETTER, EMPTY_ELEM_GETTER.type().changeReturnType(Void.TYPE));
    private static final MethodHandle EMPTY_ELEM_SETTER = Lookup.MH.dropArguments(EMPTY_PROP_SETTER, 0, Object.class);
    private static final Map<Class<?>, MethodHandle> CONVERTERS = new HashMap();
    private static final ClassValue<Method> FUNCTIONAL_IFACE_METHOD;

    NashornBottomLinker() {
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest linkRequest, LinkerServices linkerServices) throws Exception {
        Object self = linkRequest.getReceiver();
        if (self == null) {
            return NashornBottomLinker.linkNull(linkRequest);
        }
        assert (NashornBottomLinker.isExpectedObject(self)) : "Couldn't link " + linkRequest.getCallSiteDescriptor() + " for " + self.getClass().getName();
        return NashornBottomLinker.linkBean(linkRequest, linkerServices);
    }

    private static GuardedInvocation linkBean(LinkRequest linkRequest, LinkerServices linkerServices) throws Exception {
        String operator;
        NashornCallSiteDescriptor desc = (NashornCallSiteDescriptor)linkRequest.getCallSiteDescriptor();
        Object self = linkRequest.getReceiver();
        switch (operator = desc.getFirstOperator()) {
            case "new": {
                if (BeansLinker.isDynamicMethod(self)) {
                    throw ECMAErrors.typeError("method.not.constructor", ScriptRuntime.safeToString(self));
                }
                throw ECMAErrors.typeError("not.a.function", ScriptRuntime.safeToString(self));
            }
            case "call": {
                Method m = NashornBottomLinker.getFunctionalInterfaceMethod(self.getClass());
                if (m != null) {
                    MethodType callType = desc.getMethodType();
                    if (callType.parameterCount() != m.getParameterCount() + 2) {
                        throw ECMAErrors.typeError("no.method.matches.args", ScriptRuntime.safeToString(self));
                    }
                    return new GuardedInvocation(Lookup.MH.dropArguments(desc.getLookup().unreflect(m), 1, new Class[]{callType.parameterType(1)}), Guards.getInstanceOfGuard(m.getDeclaringClass())).asType(callType);
                }
                if (BeansLinker.isDynamicMethod(self)) {
                    throw ECMAErrors.typeError("no.method.matches.args", ScriptRuntime.safeToString(self));
                }
                throw ECMAErrors.typeError("not.a.function", ScriptRuntime.safeToString(self));
            }
            case "callMethod": 
            case "getMethod": {
                throw ECMAErrors.typeError("no.such.function", NashornBottomLinker.getArgument(linkRequest), ScriptRuntime.safeToString(self));
            }
            case "getProp": 
            case "getElem": {
                if (desc.getOperand() != null) {
                    return NashornBottomLinker.getInvocation(EMPTY_PROP_GETTER, self, linkerServices, desc);
                }
                return NashornBottomLinker.getInvocation(EMPTY_ELEM_GETTER, self, linkerServices, desc);
            }
            case "setProp": 
            case "setElem": {
                if (desc.getOperand() != null) {
                    return NashornBottomLinker.getInvocation(EMPTY_PROP_SETTER, self, linkerServices, desc);
                }
                return NashornBottomLinker.getInvocation(EMPTY_ELEM_SETTER, self, linkerServices, desc);
            }
        }
        throw new AssertionError((Object)("unknown call type " + desc));
    }

    @Override
    public GuardedTypeConversion convertToType(Class<?> sourceType, Class<?> targetType) throws Exception {
        GuardedInvocation gi = NashornBottomLinker.convertToTypeNoCast(sourceType, targetType);
        return gi == null ? null : new GuardedTypeConversion(gi.asType(Lookup.MH.type(targetType, sourceType)), true);
    }

    private static GuardedInvocation convertToTypeNoCast(Class<?> sourceType, Class<?> targetType) throws Exception {
        MethodHandle mh = CONVERTERS.get(targetType);
        if (mh != null) {
            return new GuardedInvocation(mh, null);
        }
        return null;
    }

    private static GuardedInvocation getInvocation(MethodHandle handle, Object self, LinkerServices linkerServices, CallSiteDescriptor desc) {
        return Bootstrap.asType(new GuardedInvocation(handle, Guards.getClassGuard(self.getClass())), linkerServices, desc);
    }

    private static boolean isExpectedObject(Object obj) {
        return !NashornLinker.canLinkTypeStatic(obj.getClass());
    }

    private static GuardedInvocation linkNull(LinkRequest linkRequest) {
        String operator;
        NashornCallSiteDescriptor desc = (NashornCallSiteDescriptor)linkRequest.getCallSiteDescriptor();
        switch (operator = desc.getFirstOperator()) {
            case "new": 
            case "call": {
                throw ECMAErrors.typeError("not.a.function", "null");
            }
            case "callMethod": 
            case "getMethod": {
                throw ECMAErrors.typeError("no.such.function", NashornBottomLinker.getArgument(linkRequest), "null");
            }
            case "getProp": 
            case "getElem": {
                throw ECMAErrors.typeError("cant.get.property", NashornBottomLinker.getArgument(linkRequest), "null");
            }
            case "setProp": 
            case "setElem": {
                throw ECMAErrors.typeError("cant.set.property", NashornBottomLinker.getArgument(linkRequest), "null");
            }
        }
        throw new AssertionError((Object)("unknown call type " + desc));
    }

    private static String getArgument(LinkRequest linkRequest) {
        CallSiteDescriptor desc = linkRequest.getCallSiteDescriptor();
        if (desc.getNameTokenCount() > 2) {
            return desc.getNameToken(2);
        }
        return ScriptRuntime.safeToString(linkRequest.getArguments()[1]);
    }

    static Method getFunctionalInterfaceMethod(Class<?> clazz) {
        return FUNCTIONAL_IFACE_METHOD.get(clazz);
    }

    static {
        CONVERTERS.put(Boolean.TYPE, JSType.TO_BOOLEAN.methodHandle());
        CONVERTERS.put(Double.TYPE, JSType.TO_NUMBER.methodHandle());
        CONVERTERS.put(Integer.TYPE, JSType.TO_INTEGER.methodHandle());
        CONVERTERS.put(Long.TYPE, JSType.TO_LONG.methodHandle());
        CONVERTERS.put(String.class, JSType.TO_STRING.methodHandle());
        FUNCTIONAL_IFACE_METHOD = new ClassValue<Method>(){

            @Override
            protected Method computeValue(Class<?> type) {
                return this.findFunctionalInterfaceMethod(type);
            }

            private Method findFunctionalInterfaceMethod(Class<?> clazz) {
                if (clazz == null) {
                    return null;
                }
                for (Class<?> iface : clazz.getInterfaces()) {
                    if (!Context.isAccessibleClass(iface) || !iface.isAnnotationPresent(FunctionalInterface.class)) continue;
                    for (Method m : iface.getMethods()) {
                        if (!Modifier.isAbstract(m.getModifiers())) continue;
                        return m;
                    }
                }
                return this.findFunctionalInterfaceMethod(clazz.getSuperclass());
            }
        };
    }
}

