/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.internal.dynalink.linker.LinkRequest;
import jdk.internal.dynalink.support.CallSiteDescriptorFactory;
import jdk.internal.dynalink.support.Guards;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.ScriptObject;

public final class PrimitiveLookup {
    private PrimitiveLookup() {
    }

    public static GuardedInvocation lookupPrimitive(LinkRequest request, Class<?> receiverClass, ScriptObject wrappedReceiver, MethodHandle wrapFilter) {
        return PrimitiveLookup.lookupPrimitive(request, Guards.getInstanceOfGuard(receiverClass), wrappedReceiver, wrapFilter);
    }

    public static GuardedInvocation lookupPrimitive(LinkRequest request, MethodHandle guard, ScriptObject wrappedReceiver, MethodHandle wrapFilter) {
        String name;
        CallSiteDescriptor desc = request.getCallSiteDescriptor();
        String operator = CallSiteDescriptorFactory.tokenizeOperators(desc).get(0);
        if ("setProp".equals(operator) || "setElem".equals(operator)) {
            MethodType type = desc.getMethodType();
            MethodHandle method = Lookup.MH.asType(Lookup.EMPTY_SETTER, Lookup.MH.type(Void.TYPE, new Class[]{Object.class, type.parameterType(1)}));
            if (type.parameterCount() == 3) {
                method = Lookup.MH.dropArguments(method, 2, new Class[]{type.parameterType(2)});
            }
            return new GuardedInvocation(method, guard);
        }
        if (desc.getNameTokenCount() > 2 && wrappedReceiver.findProperty(name = desc.getNameToken(2), true) == null) {
            return null;
        }
        GuardedInvocation link = wrappedReceiver.lookup(desc, request);
        if (link != null) {
            MethodHandle method = link.getInvocation();
            TypeDescriptor.OfField receiverType = method.type().parameterType(0);
            if (receiverType != Object.class) {
                MethodType wrapType = wrapFilter.type();
                assert (((Class)receiverType).isAssignableFrom((Class<?>)wrapType.returnType()));
                method = Lookup.MH.filterArguments(method, 0, Lookup.MH.asType(wrapFilter, wrapType.changeReturnType((Class<?>)receiverType)));
            }
            return new GuardedInvocation(method, guard, link.getSwitchPoint());
        }
        return null;
    }
}

