/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sun.security.action.GetPropertyAction;
import sun.security.pkcs11.ConfigurationException;
import sun.security.pkcs11.Secmod;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.TemplateManager;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.util.PropertyExpander;

final class Config {
    static final int ERR_HALT = 1;
    static final int ERR_IGNORE_ALL = 2;
    static final int ERR_IGNORE_LIB = 3;
    private static final boolean staticAllowSingleThreadedModules;
    private static final Map<String, Config> configMap;
    private static final boolean DEBUG = false;
    private Reader reader;
    private StreamTokenizer st;
    private Set<String> parsedKeywords;
    private String name;
    private String library;
    private String description;
    private int slotID = -1;
    private int slotListIndex = -1;
    private Set<Long> enabledMechanisms;
    private Set<Long> disabledMechanisms;
    private boolean showInfo = false;
    private TemplateManager templateManager;
    private int handleStartupErrors = 1;
    private boolean keyStoreCompatibilityMode = true;
    private boolean explicitCancel = true;
    private int insertionCheckInterval = 2000;
    private boolean omitInitialize = false;
    private boolean allowSingleThreadedModules = true;
    private String functionList = "C_GetFunctionList";
    private boolean nssUseSecmod;
    private String nssLibraryDirectory;
    private String nssSecmodDirectory;
    private String nssModule;
    private Secmod.DbMode nssDbMode = Secmod.DbMode.READ_WRITE;
    private boolean nssNetscapeDbWorkaround = true;
    private String nssArgs;
    private boolean nssUseSecmodTrust = false;
    private boolean useEcX963Encoding = false;
    private boolean nssOptimizeSpace = false;
    private static final CK_ATTRIBUTE[] CK_A0;

    static Config getConfig(String string, InputStream inputStream) {
        Config config = configMap.get(string);
        if (config != null) {
            return config;
        }
        try {
            config = new Config(string, inputStream);
            configMap.put(string, config);
            return config;
        }
        catch (Exception exception) {
            throw new ProviderException("Error parsing configuration", exception);
        }
    }

    static Config removeConfig(String string) {
        return configMap.remove(string);
    }

    private static void debug(Object object) {
    }

    private Config(String string, InputStream inputStream) throws IOException {
        if (inputStream == null) {
            if (string.startsWith("--")) {
                String string2 = string.substring(2).replace("\\n", "\n");
                this.reader = new StringReader(string2);
            } else {
                inputStream = new FileInputStream(Config.expand(string));
            }
        }
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }
        this.parsedKeywords = new HashSet<String>();
        this.st = new StreamTokenizer(this.reader);
        this.setupTokenizer();
        this.parse();
    }

    String getName() {
        return this.name;
    }

    String getLibrary() {
        return this.library;
    }

    String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return "SunPKCS11-" + this.name + " using library " + this.library;
    }

    int getSlotID() {
        return this.slotID;
    }

    int getSlotListIndex() {
        if (this.slotID == -1 && this.slotListIndex == -1) {
            return 0;
        }
        return this.slotListIndex;
    }

    boolean getShowInfo() {
        return SunPKCS11.debug != null || this.showInfo;
    }

    TemplateManager getTemplateManager() {
        if (this.templateManager == null) {
            this.templateManager = new TemplateManager();
        }
        return this.templateManager;
    }

    boolean isEnabled(long l) {
        if (this.enabledMechanisms != null) {
            return this.enabledMechanisms.contains(l);
        }
        if (this.disabledMechanisms != null) {
            return !this.disabledMechanisms.contains(l);
        }
        return true;
    }

    int getHandleStartupErrors() {
        return this.handleStartupErrors;
    }

    boolean getKeyStoreCompatibilityMode() {
        return this.keyStoreCompatibilityMode;
    }

    boolean getExplicitCancel() {
        return this.explicitCancel;
    }

    int getInsertionCheckInterval() {
        return this.insertionCheckInterval;
    }

    boolean getOmitInitialize() {
        return this.omitInitialize;
    }

    boolean getAllowSingleThreadedModules() {
        return staticAllowSingleThreadedModules && this.allowSingleThreadedModules;
    }

    String getFunctionList() {
        return this.functionList;
    }

    boolean getNssUseSecmod() {
        return this.nssUseSecmod;
    }

    String getNssLibraryDirectory() {
        return this.nssLibraryDirectory;
    }

    String getNssSecmodDirectory() {
        return this.nssSecmodDirectory;
    }

    String getNssModule() {
        return this.nssModule;
    }

    Secmod.DbMode getNssDbMode() {
        return this.nssDbMode;
    }

    public boolean getNssNetscapeDbWorkaround() {
        return this.nssUseSecmod && this.nssNetscapeDbWorkaround;
    }

    String getNssArgs() {
        return this.nssArgs;
    }

    boolean getNssUseSecmodTrust() {
        return this.nssUseSecmodTrust;
    }

    boolean getUseEcX963Encoding() {
        return this.useEcX963Encoding;
    }

    boolean getNssOptimizeSpace() {
        return this.nssOptimizeSpace;
    }

    private static String expand(String string) throws IOException {
        try {
            return PropertyExpander.expand(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    private void setupTokenizer() {
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(48, 57);
        this.st.wordChars(58, 58);
        this.st.wordChars(46, 46);
        this.st.wordChars(95, 95);
        this.st.wordChars(45, 45);
        this.st.wordChars(47, 47);
        this.st.wordChars(92, 92);
        this.st.wordChars(36, 36);
        this.st.wordChars(123, 123);
        this.st.wordChars(125, 125);
        this.st.wordChars(42, 42);
        this.st.wordChars(43, 43);
        this.st.wordChars(126, 126);
        this.st.whitespaceChars(0, 32);
        this.st.commentChar(35);
        this.st.eolIsSignificant(true);
        this.st.quoteChar(34);
    }

    private ConfigurationException excToken(String string) {
        return new ConfigurationException(string + " " + this.st);
    }

    private ConfigurationException excLine(String string) {
        return new ConfigurationException(string + ", line " + this.st.lineno());
    }

    private void parse() throws IOException {
        int n;
        while ((n = this.nextToken()) != -1) {
            if (n == 10) continue;
            if (n != -3) {
                throw this.excToken("Unexpected token:");
            }
            String string = this.st.sval;
            if (string.equals("name")) {
                this.name = this.parseStringEntry(string);
            } else if (string.equals("library")) {
                this.library = this.parseLibrary(string);
            } else if (string.equals("description")) {
                this.parseDescription(string);
            } else if (string.equals("slot")) {
                this.parseSlotID(string);
            } else if (string.equals("slotListIndex")) {
                this.parseSlotListIndex(string);
            } else if (string.equals("enabledMechanisms")) {
                this.parseEnabledMechanisms(string);
            } else if (string.equals("disabledMechanisms")) {
                this.parseDisabledMechanisms(string);
            } else if (string.equals("attributes")) {
                this.parseAttributes(string);
            } else if (string.equals("handleStartupErrors")) {
                this.parseHandleStartupErrors(string);
            } else if (string.endsWith("insertionCheckInterval")) {
                this.insertionCheckInterval = this.parseIntegerEntry(string);
                if (this.insertionCheckInterval < 100) {
                    throw this.excLine(string + " must be at least 100 ms");
                }
            } else if (string.equals("showInfo")) {
                this.showInfo = this.parseBooleanEntry(string);
            } else if (string.equals("keyStoreCompatibilityMode")) {
                this.keyStoreCompatibilityMode = this.parseBooleanEntry(string);
            } else if (string.equals("explicitCancel")) {
                this.explicitCancel = this.parseBooleanEntry(string);
            } else if (string.equals("omitInitialize")) {
                this.omitInitialize = this.parseBooleanEntry(string);
            } else if (string.equals("allowSingleThreadedModules")) {
                this.allowSingleThreadedModules = this.parseBooleanEntry(string);
            } else if (string.equals("functionList")) {
                this.functionList = this.parseStringEntry(string);
            } else if (string.equals("nssUseSecmod")) {
                this.nssUseSecmod = this.parseBooleanEntry(string);
            } else if (string.equals("nssLibraryDirectory")) {
                this.nssLibraryDirectory = this.parseLibrary(string);
                this.nssUseSecmod = true;
            } else if (string.equals("nssSecmodDirectory")) {
                this.nssSecmodDirectory = Config.expand(this.parseStringEntry(string));
                this.nssUseSecmod = true;
            } else if (string.equals("nssModule")) {
                this.nssModule = this.parseStringEntry(string);
                this.nssUseSecmod = true;
            } else if (string.equals("nssDbMode")) {
                String string2 = this.parseStringEntry(string);
                if (string2.equals("readWrite")) {
                    this.nssDbMode = Secmod.DbMode.READ_WRITE;
                } else if (string2.equals("readOnly")) {
                    this.nssDbMode = Secmod.DbMode.READ_ONLY;
                } else if (string2.equals("noDb")) {
                    this.nssDbMode = Secmod.DbMode.NO_DB;
                } else {
                    throw this.excToken("nssDbMode must be one of readWrite, readOnly, and noDb:");
                }
                this.nssUseSecmod = true;
            } else if (string.equals("nssNetscapeDbWorkaround")) {
                this.nssNetscapeDbWorkaround = this.parseBooleanEntry(string);
                this.nssUseSecmod = true;
            } else if (string.equals("nssArgs")) {
                this.parseNSSArgs(string);
            } else if (string.equals("nssUseSecmodTrust")) {
                this.nssUseSecmodTrust = this.parseBooleanEntry(string);
            } else if (string.equals("useEcX963Encoding")) {
                this.useEcX963Encoding = this.parseBooleanEntry(string);
            } else if (string.equals("nssOptimizeSpace")) {
                this.nssOptimizeSpace = this.parseBooleanEntry(string);
            } else {
                throw new ConfigurationException("Unknown keyword '" + string + "', line " + this.st.lineno());
            }
            this.parsedKeywords.add(string);
        }
        this.reader.close();
        this.reader = null;
        this.st = null;
        this.parsedKeywords = null;
        if (this.name == null) {
            throw new ConfigurationException("name must be specified");
        }
        if (!this.nssUseSecmod) {
            if (this.library == null) {
                throw new ConfigurationException("library must be specified");
            }
        } else {
            if (this.library != null) {
                throw new ConfigurationException("library must not be specified in NSS mode");
            }
            if (this.slotID != -1 || this.slotListIndex != -1) {
                throw new ConfigurationException("slot and slotListIndex must not be specified in NSS mode");
            }
            if (this.nssArgs != null) {
                throw new ConfigurationException("nssArgs must not be specified in NSS mode");
            }
            if (this.nssUseSecmodTrust) {
                throw new ConfigurationException("nssUseSecmodTrust is an internal option and must not be specified in NSS mode");
            }
        }
    }

    private int nextToken() throws IOException {
        int n = this.st.nextToken();
        Config.debug(this.st);
        return n;
    }

    private void parseEquals() throws IOException {
        int n = this.nextToken();
        if (n != 61) {
            throw this.excToken("Expected '=', read");
        }
    }

    private void parseOpenBraces() throws IOException {
        int n;
        while ((n = this.nextToken()) == 10) {
        }
        if (n == -3 && this.st.sval.equals("{")) {
            return;
        }
        throw this.excToken("Expected '{', read");
    }

    private boolean isCloseBraces(int n) {
        return n == -3 && this.st.sval.equals("}");
    }

    private String parseWord() throws IOException {
        int n = this.nextToken();
        if (n != -3) {
            throw this.excToken("Unexpected value:");
        }
        return this.st.sval;
    }

    private String parseStringEntry(String string) throws IOException {
        this.checkDup(string);
        this.parseEquals();
        int n = this.nextToken();
        if (n != -3 && n != 34) {
            throw this.excToken("Unexpected value:");
        }
        String string2 = this.st.sval;
        Config.debug(string + ": " + string2);
        return string2;
    }

    private boolean parseBooleanEntry(String string) throws IOException {
        this.checkDup(string);
        this.parseEquals();
        boolean bl = this.parseBoolean();
        Config.debug(string + ": " + bl);
        return bl;
    }

    private int parseIntegerEntry(String string) throws IOException {
        this.checkDup(string);
        this.parseEquals();
        int n = this.decodeNumber(this.parseWord());
        Config.debug(string + ": " + n);
        return n;
    }

    private boolean parseBoolean() throws IOException {
        String string;
        switch (string = this.parseWord()) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw this.excToken("Expected boolean value, read:");
    }

    private String parseLine() throws IOException {
        int n;
        String string = this.parseWord();
        while ((n = this.nextToken()) != 10 && n != -1) {
            if (n != -3) {
                throw this.excToken("Unexpected value");
            }
            string = string + " " + this.st.sval;
        }
        return string;
    }

    private int decodeNumber(String string) throws IOException {
        try {
            if (string.startsWith("0x") || string.startsWith("0X")) {
                return Integer.parseInt(string.substring(2), 16);
            }
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.excToken("Expected number, read");
        }
    }

    private static boolean isNumber(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        return c >= '0' && c <= '9';
    }

    private void parseComma() throws IOException {
        int n = this.nextToken();
        if (n != 44) {
            throw this.excToken("Expected ',', read");
        }
    }

    private static boolean isByteArray(String string) {
        return string.startsWith("0h");
    }

    private byte[] decodeByteArray(String string) throws IOException {
        if (!string.startsWith("0h")) {
            throw this.excToken("Expected byte array value, read");
        }
        string = string.substring(2);
        try {
            return new BigInteger(string, 16).toByteArray();
        }
        catch (NumberFormatException numberFormatException) {
            throw this.excToken("Expected byte array value, read");
        }
    }

    private void checkDup(String string) throws IOException {
        if (this.parsedKeywords.contains(string)) {
            throw this.excLine(string + " must only be specified once");
        }
    }

    private String parseLibrary(String string) throws IOException {
        String string2 = this.parseStringEntry(string);
        int n = (string2 = Config.expand(string2)).indexOf("/$ISA/");
        if (n != -1) {
            String string3 = System.getProperty("os.name", "");
            String string4 = System.getProperty("os.arch", "");
            String string5 = string2.substring(0, n);
            String string6 = string2.substring(n + 5);
            string2 = string3.equals("SunOS") && string4.equals("sparcv9") ? string5 + "/sparcv9" + string6 : (string3.equals("SunOS") && string4.equals("amd64") ? string5 + "/amd64" + string6 : string5 + string6);
        }
        Config.debug(string + ": " + string2);
        if (!new File(string2).isAbsolute()) {
            throw new ConfigurationException("Absolute path required for library value: " + string2);
        }
        return string2;
    }

    private void parseDescription(String string) throws IOException {
        this.checkDup(string);
        this.parseEquals();
        this.description = this.parseLine();
        Config.debug("description: " + this.description);
    }

    private void parseSlotID(String string) throws IOException {
        if (this.slotID >= 0) {
            throw this.excLine("Duplicate slot definition");
        }
        if (this.slotListIndex >= 0) {
            throw this.excLine("Only one of slot and slotListIndex must be specified");
        }
        this.parseEquals();
        String string2 = this.parseWord();
        this.slotID = this.decodeNumber(string2);
        Config.debug("slot: " + this.slotID);
    }

    private void parseSlotListIndex(String string) throws IOException {
        if (this.slotListIndex >= 0) {
            throw this.excLine("Duplicate slotListIndex definition");
        }
        if (this.slotID >= 0) {
            throw this.excLine("Only one of slot and slotListIndex must be specified");
        }
        this.parseEquals();
        String string2 = this.parseWord();
        this.slotListIndex = this.decodeNumber(string2);
        Config.debug("slotListIndex: " + this.slotListIndex);
    }

    private void parseEnabledMechanisms(String string) throws IOException {
        this.enabledMechanisms = this.parseMechanisms(string);
    }

    private void parseDisabledMechanisms(String string) throws IOException {
        this.disabledMechanisms = this.parseMechanisms(string);
    }

    private Set<Long> parseMechanisms(String string) throws IOException {
        int n;
        this.checkDup(string);
        HashSet<Long> hashSet = new HashSet<Long>();
        this.parseEquals();
        this.parseOpenBraces();
        while (!this.isCloseBraces(n = this.nextToken())) {
            if (n == 10) continue;
            if (n != -3) {
                throw this.excToken("Expected mechanism, read");
            }
            long l = this.parseMechanism(this.st.sval);
            hashSet.add(l);
        }
        return hashSet;
    }

    private long parseMechanism(String string) throws IOException {
        if (Config.isNumber(string)) {
            return this.decodeNumber(string);
        }
        try {
            return Functions.getMechanismId(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.excLine("Unknown mechanism: " + string);
        }
    }

    private void parseAttributes(String string) throws IOException {
        int n;
        if (this.templateManager == null) {
            this.templateManager = new TemplateManager();
        }
        if ((n = this.nextToken()) == 61) {
            String string2 = this.parseWord();
            if (!string2.equals("compatibility")) {
                throw this.excLine("Expected 'compatibility', read " + string2);
            }
            this.setCompatibilityAttributes();
            return;
        }
        if (n != 40) {
            throw this.excToken("Expected '(' or '=', read");
        }
        String string3 = this.parseOperation();
        this.parseComma();
        long l = this.parseObjectClass();
        this.parseComma();
        long l2 = this.parseKeyAlgorithm();
        n = this.nextToken();
        if (n != 41) {
            throw this.excToken("Expected ')', read");
        }
        this.parseEquals();
        this.parseOpenBraces();
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        while (!this.isCloseBraces(n = this.nextToken())) {
            if (n == 10) continue;
            if (n != -3) {
                throw this.excToken("Expected mechanism, read");
            }
            String string4 = this.st.sval;
            long l3 = this.decodeAttributeName(string4);
            this.parseEquals();
            String string5 = this.parseWord();
            arrayList.add(this.decodeAttributeValue(l3, string5));
        }
        this.templateManager.addTemplate(string3, l, l2, arrayList.toArray(CK_A0));
    }

    private void setCompatibilityAttributes() {
        this.templateManager.addTemplate("*", 4L, 0x7FFFFF22L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.TOKEN_FALSE, CK_ATTRIBUTE.SENSITIVE_FALSE, CK_ATTRIBUTE.EXTRACTABLE_TRUE, CK_ATTRIBUTE.ENCRYPT_TRUE, CK_ATTRIBUTE.DECRYPT_TRUE, CK_ATTRIBUTE.WRAP_TRUE, CK_ATTRIBUTE.UNWRAP_TRUE});
        this.templateManager.addTemplate("*", 4L, 16L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.SIGN_TRUE, CK_ATTRIBUTE.VERIFY_TRUE, CK_ATTRIBUTE.ENCRYPT_NULL, CK_ATTRIBUTE.DECRYPT_NULL, CK_ATTRIBUTE.WRAP_NULL, CK_ATTRIBUTE.UNWRAP_NULL, CK_ATTRIBUTE.DERIVE_TRUE});
        this.templateManager.addTemplate("*", 3L, 0x7FFFFF22L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.TOKEN_FALSE, CK_ATTRIBUTE.SENSITIVE_FALSE, CK_ATTRIBUTE.EXTRACTABLE_TRUE});
        this.templateManager.addTemplate("*", 2L, 0x7FFFFF22L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.TOKEN_FALSE});
        this.templateManager.addTemplate("*", 3L, 0L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.DECRYPT_TRUE, CK_ATTRIBUTE.SIGN_TRUE, CK_ATTRIBUTE.SIGN_RECOVER_TRUE, CK_ATTRIBUTE.UNWRAP_TRUE});
        this.templateManager.addTemplate("*", 2L, 0L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.ENCRYPT_TRUE, CK_ATTRIBUTE.VERIFY_TRUE, CK_ATTRIBUTE.VERIFY_RECOVER_TRUE, CK_ATTRIBUTE.WRAP_TRUE});
        this.templateManager.addTemplate("*", 3L, 1L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.SIGN_TRUE});
        this.templateManager.addTemplate("*", 2L, 1L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.VERIFY_TRUE});
        this.templateManager.addTemplate("*", 3L, 2L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.DERIVE_TRUE});
        this.templateManager.addTemplate("*", 3L, 3L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.SIGN_TRUE, CK_ATTRIBUTE.DERIVE_TRUE});
        this.templateManager.addTemplate("*", 2L, 3L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.VERIFY_TRUE});
    }

    private String parseOperation() throws IOException {
        String string;
        switch (string = this.parseWord()) {
            case "*": {
                return "*";
            }
            case "generate": {
                return "generate";
            }
            case "import": {
                return "import";
            }
        }
        throw this.excLine("Unknown operation " + string);
    }

    private long parseObjectClass() throws IOException {
        String string = this.parseWord();
        try {
            return Functions.getObjectClassId(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.excLine("Unknown object class " + string);
        }
    }

    private long parseKeyAlgorithm() throws IOException {
        String string = this.parseWord();
        if (Config.isNumber(string)) {
            return this.decodeNumber(string);
        }
        try {
            return Functions.getKeyId(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.excLine("Unknown key algorithm " + string);
        }
    }

    private long decodeAttributeName(String string) throws IOException {
        if (Config.isNumber(string)) {
            return this.decodeNumber(string);
        }
        try {
            return Functions.getAttributeId(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.excLine("Unknown attribute name " + string);
        }
    }

    private CK_ATTRIBUTE decodeAttributeValue(long l, String string) throws IOException {
        if (string.equals("null")) {
            return new CK_ATTRIBUTE(l);
        }
        if (string.equals("true")) {
            return new CK_ATTRIBUTE(l, true);
        }
        if (string.equals("false")) {
            return new CK_ATTRIBUTE(l, false);
        }
        if (Config.isByteArray(string)) {
            return new CK_ATTRIBUTE(l, this.decodeByteArray(string));
        }
        if (Config.isNumber(string)) {
            return new CK_ATTRIBUTE(l, (Object)this.decodeNumber(string));
        }
        throw this.excLine("Unknown attribute value " + string);
    }

    private void parseNSSArgs(String string) throws IOException {
        this.checkDup(string);
        this.parseEquals();
        int n = this.nextToken();
        if (n != 34) {
            throw this.excToken("Expected quoted string");
        }
        this.nssArgs = Config.expand(this.st.sval);
        Config.debug("nssArgs: " + this.nssArgs);
    }

    private void parseHandleStartupErrors(String string) throws IOException {
        this.checkDup(string);
        this.parseEquals();
        String string2 = this.parseWord();
        if (string2.equals("ignoreAll")) {
            this.handleStartupErrors = 2;
        } else if (string2.equals("ignoreMissingLibrary")) {
            this.handleStartupErrors = 3;
        } else if (string2.equals("halt")) {
            this.handleStartupErrors = 1;
        } else {
            throw this.excToken("Invalid value for handleStartupErrors:");
        }
        Config.debug("handleStartupErrors: " + this.handleStartupErrors);
    }

    static {
        String string = "sun.security.pkcs11.allowSingleThreadedModules";
        String string2 = AccessController.doPrivileged(new GetPropertyAction(string));
        staticAllowSingleThreadedModules = !"false".equalsIgnoreCase(string2);
        configMap = new HashMap<String, Config>();
        CK_A0 = new CK_ATTRIBUTE[0];
    }
}

