/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.accessible.mac;

import com.sun.glass.ui.accessible.AccessibleBaseProvider;
import com.sun.glass.ui.accessible.AccessibleLogger;
import com.sun.glass.ui.accessible.mac.MacAccessibleAttributes;
import com.sun.glass.ui.accessible.mac.MacAccessibleEventIds;
import com.sun.glass.ui.accessible.mac.MacAccessibleRoles;
import com.sun.glass.ui.accessible.mac.MacAccessibleRoot;
import com.sun.javafx.accessible.providers.AccessibleProvider;
import com.sun.javafx.accessible.utils.NavigateDirection;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;

public final class MacAccessibleBaseProvider
extends AccessibleBaseProvider {
    private static final HashMap<Integer, MacAccessibleRoles.MacRole> MacRoleMap = new HashMap();
    private static final HashMap<Integer, MacAccessibleEventIds.MacEventId> MacEventIdMap = new HashMap();
    private static final HashMap<Integer, MacAccessibleAttributes.MacAttribute> MacAttributeMap = new HashMap();
    private static final EnumMap<MacAccessibleAttributes.MacAttribute, Integer> FxaAttributeMap = new EnumMap(MacAccessibleAttributes.MacAttribute.class);
    private long nativeAccessible = this._createAccessible();

    private static native void _initIDs();

    private native long _createAccessible();

    private native void _destroyAccessible(long var1);

    private native void _fireEvent(long var1, int var3);

    public MacAccessibleBaseProvider(Object object) {
        super(object);
    }

    long getNativeAccessible() {
        return this.nativeAccessible;
    }

    @Override
    public void destroyAccessible() {
        this._destroyAccessible(this.nativeAccessible);
    }

    @Override
    public void fireEvent(int n) {
        AccessibleLogger.getLogger().fine("this: " + this);
        AccessibleLogger.getLogger().fine("nativeAccessible: " + Long.toHexString(this.nativeAccessible));
        AccessibleLogger.getLogger().fine("eventID: " + n);
        this._fireEvent(this.nativeAccessible, MacEventIdMap.get(n).ordinal());
    }

    @Override
    public void firePropertyChange(int n, int n2, int n3) {
        AccessibleLogger.getLogger().fine("this: " + this);
        AccessibleLogger.getLogger().fine("nativeAccessible: " + Long.toHexString(this.nativeAccessible));
        AccessibleLogger.getLogger().fine("propertyID: " + n);
        AccessibleLogger.getLogger().fine("old: " + n2);
        AccessibleLogger.getLogger().fine("new: " + n3);
        this._fireEvent(this.nativeAccessible, MacAccessibleEventIds.MacEventId.VALUE_CHANGED.ordinal());
    }

    @Override
    public void firePropertyChange(int n, boolean bl, boolean bl2) {
        AccessibleLogger.getLogger().fine("this: " + this);
        AccessibleLogger.getLogger().fine("nativeAccessible: " + Long.toHexString(this.nativeAccessible));
        AccessibleLogger.getLogger().fine("propertyID: " + n);
        AccessibleLogger.getLogger().fine("old: " + bl);
        AccessibleLogger.getLogger().fine("new: " + bl2);
        this._fireEvent(this.nativeAccessible, MacAccessibleEventIds.MacEventId.VALUE_CHANGED.ordinal());
    }

    private long[] getChildren(int n, int n2) {
        Object object;
        AccessibleLogger.getLogger().fine("this: " + this);
        AccessibleLogger.getLogger().fine("offset: " + n);
        AccessibleLogger.getLogger().fine("maxCount: " + n2);
        ArrayList<Long> arrayList = new ArrayList<Long>(100);
        if (n2 == 0 || n2 < -1 || n < 0) {
            return null;
        }
        boolean bl = n2 == -1;
        Object object2 = ((AccessibleProvider)this.node).navigate(NavigateDirection.FirstChild);
        if (object2 == null) {
            AccessibleLogger.getLogger().fine("No children.");
        } else {
            Long l;
            int n3 = 0;
            int n4 = 0;
            if (n == 0) {
                l = new Long(((MacAccessibleBaseProvider)object2).getNativeAccessible());
                arrayList.add(l);
                ++n4;
            }
            ++n3;
            if (bl || n4 < n2) {
                object = object2;
                do {
                    AccessibleProvider accessibleProvider = (AccessibleProvider)((MacAccessibleBaseProvider)object).getNode();
                    object = accessibleProvider.navigate(NavigateDirection.NextSibling);
                    if (n3 >= n && object != null) {
                        l = new Long(((MacAccessibleBaseProvider)object).getNativeAccessible());
                        arrayList.add(l);
                        ++n4;
                    }
                    ++n3;
                } while ((bl || n4 < n2) && object != null);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        object = new long[arrayList.size()];
        int n5 = 0;
        AccessibleLogger.getLogger().fine("returning");
        for (Long l : arrayList) {
            AccessibleLogger.getLogger().fine("child [" + n5 + "]: " + Long.toHexString(l));
            object[n5++] = l;
        }
        return object;
    }

    private long getParent() {
        AccessibleLogger.getLogger().fine("this: " + this);
        long l = 0L;
        Object object = ((AccessibleProvider)this.node).navigate(NavigateDirection.Parent);
        if (object == null) {
            AccessibleLogger.getLogger().fine("No parent.");
        } else {
            l = object instanceof MacAccessibleRoot ? -1L : ((MacAccessibleBaseProvider)object).getNativeAccessible();
        }
        AccessibleLogger.getLogger().fine("returning parent: " + l);
        return l;
    }

    private long getRoot() {
        AccessibleLogger.getLogger().fine("this: " + this);
        long l = 0L;
        Object object = ((AccessibleProvider)this.node).navigate(NavigateDirection.Parent);
        if (object == null) {
            AccessibleLogger.getLogger().fine("No parent.");
        } else if (!(object instanceof MacAccessibleRoot)) {
            AccessibleLogger.getLogger().fine("parent is not a MacAccessibleRoot");
            AccessibleLogger.getLogger().fine("it's a: " + object.toString());
        } else {
            l = ((MacAccessibleRoot)object).getNativeAccessible();
        }
        AccessibleLogger.getLogger().fine("returning root: " + Long.toHexString(l));
        return l;
    }

    @Override
    protected Object getPropertyValue(int n) {
        Object object;
        AccessibleLogger.getLogger().fine("this: " + this);
        AccessibleLogger.getLogger().fine("attributeId: " + n);
        if (n == MacAccessibleAttributes.MacAttribute.ROLE.ordinal()) {
            Integer n2 = (Integer)super.getPropertyValue(FxaAttributeMap.get((Object)MacAccessibleAttributes.MacAttribute.ROLE));
            if (n2 == null) {
                AccessibleLogger.getLogger().fine("role not in role map");
                object = null;
            } else {
                AccessibleLogger.getLogger().fine("fxRole: " + n2);
                object = MacRoleMap.get(n2).ordinal();
            }
        } else if (n == MacAccessibleAttributes.MacAttribute.TITLE.ordinal()) {
            object = (String)super.getPropertyValue(FxaAttributeMap.get((Object)MacAccessibleAttributes.MacAttribute.TITLE));
        } else if (n == MacAccessibleAttributes.MacAttribute.ENABLED.ordinal()) {
            object = (Boolean)super.getPropertyValue(FxaAttributeMap.get((Object)MacAccessibleAttributes.MacAttribute.ENABLED));
        } else if (n == MacAccessibleAttributes.MacAttribute.FOCUSED.ordinal()) {
            object = (Boolean)super.getPropertyValue(FxaAttributeMap.get((Object)MacAccessibleAttributes.MacAttribute.FOCUSED));
        } else {
            object = null;
            AccessibleLogger.getLogger().fine("Attribute not handled, returning null");
        }
        AccessibleLogger.getLogger().fine("returning: " + object);
        return object;
    }

    static {
        MacAccessibleBaseProvider._initIDs();
        MacRoleMap.put(50000, MacAccessibleRoles.MacRole.BUTTON);
        MacRoleMap.put(50002, MacAccessibleRoles.MacRole.CHECK_BOX);
        MacRoleMap.put(50013, MacAccessibleRoles.MacRole.RADIO_BUTTON);
        MacRoleMap.put(50020, MacAccessibleRoles.MacRole.TEXT_FIELD);
        MacRoleMap.put(50008, MacAccessibleRoles.MacRole.LIST);
        MacRoleMap.put(50007, MacAccessibleRoles.MacRole.CELL);
        MacEventIdMap.put(20005, MacAccessibleEventIds.MacEventId.FOCUSED_UI_ELEMENT_CHANGED);
        MacEventIdMap.put(20004, MacAccessibleEventIds.MacEventId.VALUE_CHANGED);
        FxaAttributeMap.put(MacAccessibleAttributes.MacAttribute.ENABLED, 30010);
        MacAttributeMap.put(30010, MacAccessibleAttributes.MacAttribute.ENABLED);
        FxaAttributeMap.put(MacAccessibleAttributes.MacAttribute.FOCUSED, 30008);
        MacAttributeMap.put(30008, MacAccessibleAttributes.MacAttribute.FOCUSED);
        FxaAttributeMap.put(MacAccessibleAttributes.MacAttribute.ROLE, 30003);
        MacAttributeMap.put(30003, MacAccessibleAttributes.MacAttribute.ROLE);
        FxaAttributeMap.put(MacAccessibleAttributes.MacAttribute.SELECTED, 30079);
        MacAttributeMap.put(30079, MacAccessibleAttributes.MacAttribute.SELECTED);
        FxaAttributeMap.put(MacAccessibleAttributes.MacAttribute.TITLE, 30005);
        MacAttributeMap.put(30005, MacAccessibleAttributes.MacAttribute.TITLE);
    }
}

