/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.accessible.mac;

import com.sun.glass.ui.Window;
import com.sun.glass.ui.accessible.AccessibleLogger;
import com.sun.glass.ui.accessible.AccessibleRoot;
import com.sun.glass.ui.accessible.mac.MacAccessibleAttributes;
import com.sun.glass.ui.accessible.mac.MacAccessibleBaseProvider;
import com.sun.glass.ui.accessible.mac.MacAccessibleEventIds;
import com.sun.glass.ui.accessible.mac.MacAccessibleRoles;
import com.sun.javafx.accessible.providers.AccessibleProvider;
import com.sun.javafx.accessible.providers.AccessibleStageProvider;
import com.sun.javafx.accessible.utils.NavigateDirection;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;

public final class MacAccessibleRoot
extends AccessibleRoot {
    private static final HashMap<Integer, MacAccessibleRoles.MacRole> MacRoleMap = new HashMap();
    private static final HashMap<Integer, MacAccessibleEventIds.MacEventId> MacEventIdMap = new HashMap();
    private static final EnumMap<MacAccessibleAttributes.MacAttribute, Integer> FxaAttributeMap = new EnumMap(MacAccessibleAttributes.MacAttribute.class);
    private long nativeWindow;
    private long nativeAccessible = this._createAccessible();

    private static native void _initIDs();

    private native long _createAccessible();

    private native void _setAccessibilityInitIsComplete(long var1, long var3);

    private native void _destroyAccessible(long var1);

    private native void _fireEvent(long var1, int var3);

    public MacAccessibleRoot(Object object, Window window) {
        super(object);
        this.nativeWindow = window.getNativeWindow();
    }

    long getNativeAccessible() {
        return this.nativeAccessible;
    }

    @Override
    public void setAccessibilityInitIsComplete() {
        this._setAccessibilityInitIsComplete(this.nativeWindow, this.nativeAccessible);
    }

    @Override
    public void destroyAccessible() {
        if (this.nativeAccessible != 0L) {
            this._destroyAccessible(this.nativeAccessible);
        }
    }

    @Override
    public void fireEvent(int n) {
        AccessibleLogger.getLogger().fine("this: " + this);
        AccessibleLogger.getLogger().fine("nativeAccessible: " + Long.toHexString(this.nativeAccessible));
        AccessibleLogger.getLogger().fine("eventID: " + n);
        this._fireEvent(this.nativeAccessible, MacEventIdMap.get(n).ordinal());
    }

    private long[] getChildren(int n, int n2) {
        Object object;
        AccessibleLogger.getLogger().fine("this: " + this);
        AccessibleLogger.getLogger().fine("offset: " + n);
        AccessibleLogger.getLogger().fine("maxCount: " + n2);
        ArrayList<Long> arrayList = new ArrayList<Long>(100);
        if (n2 == 0 || n2 < -1 || n < 0) {
            return null;
        }
        boolean bl = n2 == -1;
        Object object2 = ((AccessibleProvider)this.node).navigate(NavigateDirection.FirstChild);
        if (object2 == null) {
            AccessibleLogger.getLogger().fine("No children.");
        } else {
            Long l;
            int n3 = 0;
            int n4 = 0;
            if (n == 0) {
                l = new Long(((MacAccessibleBaseProvider)object2).getNativeAccessible());
                arrayList.add(l);
                ++n4;
            }
            ++n3;
            if (bl || n4 < n2) {
                object = object2;
                do {
                    AccessibleProvider accessibleProvider = (AccessibleProvider)((MacAccessibleBaseProvider)object).getNode();
                    object = accessibleProvider.navigate(NavigateDirection.NextSibling);
                    if (n3 >= n && object != null) {
                        l = new Long(((MacAccessibleBaseProvider)object).getNativeAccessible());
                        arrayList.add(l);
                        ++n4;
                    }
                    ++n3;
                } while ((bl || n4 < n2) && object != null);
            }
        }
        AccessibleLogger.getLogger().fine("children.size: " + arrayList.size());
        if (arrayList.isEmpty()) {
            return null;
        }
        object = new long[arrayList.size()];
        int n5 = 0;
        AccessibleLogger.getLogger().fine("returning");
        for (Long l : arrayList) {
            AccessibleLogger.getLogger().fine("child [" + n5 + "]: " + Long.toHexString(l));
            object[n5++] = l;
        }
        return object;
    }

    @Override
    protected Object getPropertyValue(int n) {
        MacAccessibleRoles.MacRole macRole;
        AccessibleLogger.getLogger().fine("this: " + this);
        AccessibleLogger.getLogger().fine("attributeId: " + n);
        if (n == MacAccessibleAttributes.MacAttribute.ROLE.ordinal()) {
            Integer n2 = (Integer)super.getPropertyValue(FxaAttributeMap.get((Object)MacAccessibleAttributes.MacAttribute.ROLE));
            macRole = MacRoleMap.get(n2);
            AccessibleLogger.getLogger().fine("returning Mac role: " + (Object)((Object)macRole));
        }
        if (n == MacAccessibleAttributes.MacAttribute.TITLE.ordinal()) {
            macRole = null;
        } else {
            macRole = null;
            AccessibleLogger.getLogger().fine("Attribute not handled, returning null");
        }
        return macRole;
    }

    private long elementProviderFromPoint(double d, double d2) {
        AccessibleLogger.getLogger().fine("this: " + this);
        if (this.node instanceof AccessibleStageProvider) {
            AccessibleLogger.getLogger().fine("x: " + d + " y: " + d2);
            Object object = ((AccessibleStageProvider)this.node).elementProviderFromPoint(d, d2);
            if (object != null) {
                long l = ((MacAccessibleBaseProvider)object).getNativeAccessible();
                AccessibleLogger.getLogger().fine("native element: " + l);
                return l;
            }
            AccessibleLogger.getLogger().fine("Not Found");
            return 0L;
        }
        return 0L;
    }

    static {
        MacAccessibleRoot._initIDs();
        MacRoleMap.put(50000, MacAccessibleRoles.MacRole.BUTTON);
        MacRoleMap.put(50002, MacAccessibleRoles.MacRole.CHECK_BOX);
        MacRoleMap.put(50013, MacAccessibleRoles.MacRole.RADIO_BUTTON);
        MacEventIdMap.put(20005, MacAccessibleEventIds.MacEventId.FOCUSED_UI_ELEMENT_CHANGED);
        FxaAttributeMap.put(MacAccessibleAttributes.MacAttribute.ROLE, 30003);
    }
}

