/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.accessible;

import com.sun.javafx.Logging;
import com.sun.javafx.accessible.AccessibleStage;
import com.sun.javafx.accessible.providers.AccessibleProvider;
import com.sun.javafx.accessible.utils.NavigateDirection;
import com.sun.javafx.accessible.utils.Rect;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Screen;
import sun.util.logging.PlatformLogger;

public class AccessibleNode
implements AccessibleProvider {
    Object accElement;
    Node node;
    AccessibleNode parent;
    AccessibleStage accController;
    List<AccessibleNode> children;

    public AccessibleNode(Node node) {
        this.node = node;
        this.parent = null;
        this.children = new ArrayList<AccessibleNode>();
    }

    public Object getAccessibleElement() {
        return this.accElement;
    }

    public void fireEvent(int n) {
        this.accController.stage.impl_getPeer().accessibleFireEvent(this.accElement, n);
    }

    public void firePropertyChange(int n, int n2, int n3) {
        this.accController.stage.impl_getPeer().accessibleFirePropertyChange(this.accElement, n, n2, n3);
    }

    public void firePropertyChange(int n, boolean bl, boolean bl2) {
        this.accController.stage.impl_getPeer().accessibleFirePropertyChange(this.accElement, n, bl, bl2);
    }

    @Override
    public AccessibleProvider hostRawElementProvider() {
        return this;
    }

    @Override
    public Object getPatternProvider(int n) {
        return this;
    }

    @Override
    public Object getPropertyValue(int n) {
        if (n == 30005) {
            return this.node.getClass().toString();
        }
        return null;
    }

    @Override
    public Rect boundingRectangle() {
        Scene scene = this.node.getScene();
        Bounds bounds = this.node.getBoundsInParent();
        double d = Screen.getPrimary().getBounds().getMinX() + scene.getWindow().getX() + scene.getX() + bounds.getMinX();
        double d2 = Screen.getPrimary().getBounds().getMinY() + scene.getWindow().getY() + scene.getY() + bounds.getMinY();
        PlatformLogger platformLogger = Logging.getAccessibilityLogger();
        if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
            platformLogger.finer(this.toString() + "MinX=" + bounds.getMinX() + "MinY=" + bounds.getMinY() + "Width=" + bounds.getWidth() + "Height=" + bounds.getHeight());
        }
        return new Rect(d, d2, bounds.getWidth(), bounds.getHeight());
    }

    public boolean contains(double d, double d2) {
        Bounds bounds = this.node.getBoundsInParent();
        return bounds.contains(d, d2);
    }

    @Override
    public Object fragmentRoot() {
        return this.accController.accRoot;
    }

    @Override
    public AccessibleProvider[] getEmbeddedFragmentRoots() {
        return null;
    }

    @Override
    public int[] getRuntimeId() {
        return null;
    }

    @Override
    public Object navigate(NavigateDirection navigateDirection) {
        PlatformLogger platformLogger = Logging.getAccessibilityLogger();
        if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
            platformLogger.finer("this: " + this.toString());
            platformLogger.finer("navigate direction: " + (Object)((Object)navigateDirection));
        }
        AccessibleNode accessibleNode = null;
        switch (navigateDirection) {
            case Parent: {
                if (this.parent != null) {
                    accessibleNode = this.parent;
                    break;
                }
                return this.accController.accRoot;
            }
            case NextSibling: 
            case PreviousSibling: {
                if (this.parent != null && this.parent.children.size() > 0) {
                    int n = this.parent.children.indexOf(this);
                    if (n == -1 && platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
                        platformLogger.finer(this.toString() + "  children.indexOf returned -1");
                    }
                    n = navigateDirection == NavigateDirection.NextSibling ? ++n : --n;
                    if (n < 0 || n >= this.parent.children.size()) break;
                    accessibleNode = this.parent.children.get(n);
                    break;
                }
                if (this.parent != null || this.accController.accChildren.size() <= 0) break;
                int n = this.accController.accChildren.indexOf(this);
                if (n == -1 && platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
                    platformLogger.finer(this.toString() + "  children.indexOf returned -1");
                }
                n = navigateDirection == NavigateDirection.NextSibling ? ++n : --n;
                if (n < 0 || n >= this.accController.accChildren.size()) break;
                accessibleNode = this.accController.accChildren.get(n);
                break;
            }
            case FirstChild: {
                if (this.children.size() <= 0) break;
                accessibleNode = this.children.get(0);
                break;
            }
            case LastChild: {
                if (this.children.size() <= 0) break;
                accessibleNode = this.children.get(this.children.size() - 1);
            }
        }
        if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
            if (accessibleNode != null) {
                platformLogger.finer("returning: " + accessibleNode.accElement);
            } else {
                platformLogger.finer("returning: null");
            }
        }
        if (accessibleNode != null) {
            return accessibleNode.accElement;
        }
        return null;
    }

    @Override
    public void setFocus() {
        PlatformLogger platformLogger = Logging.getAccessibilityLogger();
        if (platformLogger.isLoggable(PlatformLogger.Level.FINER)) {
            platformLogger.finer(this.toString() + "In AccessibleNode.setFocus");
        }
        this.node.requestFocus();
    }
}

