/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.MapAdapterChange;
import com.sun.javafx.collections.MapListenerHelper;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.collections.WeakMapChangeListener;

public class UnmodifiableObservableMap<K, V>
extends AbstractMap<K, V>
implements ObservableMap<K, V> {
    private MapListenerHelper<K, V> listenerHelper;
    private final ObservableMap<K, V> backingMap;
    private final MapChangeListener<K, V> listener;

    public UnmodifiableObservableMap(ObservableMap<K, V> observableMap) {
        this.backingMap = observableMap;
        this.listener = new MapChangeListener<K, V>(){

            @Override
            public void onChanged(MapChangeListener.Change<? extends K, ? extends V> change) {
                UnmodifiableObservableMap.this.callObservers(new MapAdapterChange(UnmodifiableObservableMap.this, change));
            }
        };
        this.backingMap.addListener(new WeakMapChangeListener<K, V>(this.listener));
    }

    private void callObservers(MapChangeListener.Change<? extends K, ? extends V> change) {
        MapListenerHelper.fireValueChangedEvent(this.listenerHelper, change);
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public void addListener(MapChangeListener<? super K, ? super V> mapChangeListener) {
        this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, mapChangeListener);
    }

    @Override
    public void removeListener(MapChangeListener<? super K, ? super V> mapChangeListener) {
        this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, mapChangeListener);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.backingMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.backingMap.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.backingMap.get(object);
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.backingMap.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.backingMap.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set = this.backingMap.entrySet();
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : set) {
            hashSet.add(new AbstractMap.SimpleImmutableEntry(entry.getKey(), entry.getValue()));
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

