/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.expression;

import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.expression.BinaryExpression;
import com.sun.javafx.fxml.expression.KeyPath;
import com.sun.javafx.fxml.expression.LiteralExpression;
import com.sun.javafx.fxml.expression.UnaryExpression;
import com.sun.javafx.fxml.expression.VariableExpression;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class Expression {
    private static final String NEGATE = "-";
    private static final String NOT = "!";
    private static final String ADD = "+";
    private static final String SUBTRACT = "-";
    private static final String MULTIPLY = "*";
    private static final String DIVIDE = "/";
    private static final String MODULO = "%";
    private static final String GREATER_THAN = ">";
    private static final String GREATER_THAN_OR_EQUAL_TO = ">=";
    private static final String LESS_THAN = "<";
    private static final String LESS_THAN_OR_EQUAL_TO = "<=";
    private static final String EQUAL_TO = "==";
    private static final String NOT_EQUAL_TO = "!=";
    private static final String AND = "&&";
    private static final String OR = "||";
    private static final String LEFT_PARENTHESIS = "(";
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String NULL_KEYWORD = "null";
    private static final String TRUE_KEYWORD = "true";
    private static final String FALSE_KEYWORD = "false";

    public abstract Object evaluate(Object var1);

    public abstract void update(Object var1, Object var2);

    public abstract boolean isDefined(Object var1);

    public abstract boolean isLValue();

    public List<KeyPath> getArguments() {
        ArrayList<KeyPath> arrayList = new ArrayList<KeyPath>();
        this.getArguments(arrayList);
        return arrayList;
    }

    protected abstract void getArguments(List<KeyPath> var1);

    public static <T> T get(Object object, KeyPath keyPath) {
        if (keyPath == null) {
            throw new NullPointerException();
        }
        return Expression.get(object, keyPath.iterator());
    }

    private static <T> T get(Object object, Iterator<String> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        Object object2 = iterator.hasNext() ? Expression.get(Expression.get(object, iterator.next()), iterator) : object;
        return (T)object2;
    }

    public static <T> T get(Object object, String string) {
        T t;
        if (string == null) {
            throw new NullPointerException();
        }
        if (object instanceof List) {
            List list = (List)object;
            t = (T)list.get(Integer.parseInt(string));
        } else if (object != null) {
            Map map = object instanceof Map ? (Map)object : new BeanAdapter(object);
            t = (T)map.get(string);
        } else {
            t = null;
        }
        return t;
    }

    public static void set(Object object, KeyPath keyPath, Object object2) {
        if (keyPath == null) {
            throw new NullPointerException();
        }
        Expression.set(object, keyPath.iterator(), object2);
    }

    private static void set(Object object, Iterator<String> iterator, Object object2) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        String string = iterator.next();
        if (iterator.hasNext()) {
            Expression.set(Expression.get(object, string), iterator, object2);
        } else {
            Expression.set(object, string, object2);
        }
    }

    public static void set(Object object, String string, Object object2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (object instanceof List) {
            List list = (List)object;
            list.set(Integer.parseInt(string), object2);
        } else if (object != null) {
            Map map = object instanceof Map ? (Map)object : new BeanAdapter(object);
            map.put(string, object2);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static boolean isDefined(Object object, KeyPath keyPath) {
        if (keyPath == null) {
            throw new NullPointerException();
        }
        return Expression.isDefined(object, keyPath.iterator());
    }

    private static boolean isDefined(Object object, Iterator<String> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        String string = iterator.next();
        boolean bl = iterator.hasNext() ? Expression.isDefined(Expression.get(object, string), iterator) : Expression.isDefined(object, string);
        return bl;
    }

    public static boolean isDefined(Object object, String string) {
        boolean bl;
        if (string == null) {
            throw new NullPointerException();
        }
        if (object instanceof List) {
            List list = (List)object;
            bl = Integer.parseInt(string) < list.size();
        } else if (object != null) {
            Map map = object instanceof Map ? (Map)object : new BeanAdapter(object);
            bl = map.containsKey(string);
        } else {
            bl = false;
        }
        return bl;
    }

    public static BinaryExpression add(Expression expression, Expression expression2) {
        return new BinaryExpression(expression, expression2){

            @Override
            public String getOperator() {
                return Expression.ADD;
            }

            @Override
            public Object evaluate(Object object) {
                Object object2;
                Object object3 = this.getLeft().evaluate(object);
                Object object4 = this.getRight().evaluate(object);
                if (object3 instanceof String || object4 instanceof String) {
                    object2 = object3.toString().concat(object4.toString());
                } else {
                    Number number = (Number)object3;
                    Number number2 = (Number)object4;
                    if (number instanceof Double || number2 instanceof Double) {
                        object2 = number.doubleValue() + number2.doubleValue();
                    } else if (number instanceof Float || number2 instanceof Float) {
                        object2 = Float.valueOf(number.floatValue() + number2.floatValue());
                    } else if (number instanceof Long || number2 instanceof Long) {
                        object2 = number.longValue() + number2.longValue();
                    } else if (number instanceof Integer || number2 instanceof Integer) {
                        object2 = number.intValue() + number2.intValue();
                    } else if (number instanceof Short || number2 instanceof Short) {
                        object2 = number.shortValue() + number2.shortValue();
                    } else if (number instanceof Byte || number2 instanceof Byte) {
                        object2 = number.byteValue() + number2.byteValue();
                    } else {
                        throw new UnsupportedOperationException();
                    }
                }
                return object2;
            }
        };
    }

    public static BinaryExpression add(Expression expression, Object object) {
        return Expression.add(expression, (Expression)new LiteralExpression(object));
    }

    public static BinaryExpression add(Object object, Expression expression) {
        return Expression.add((Expression)new LiteralExpression(object), expression);
    }

    public static BinaryExpression add(Object object, Object object2) {
        return Expression.add((Expression)new LiteralExpression(object), (Expression)new LiteralExpression(object2));
    }

    public static BinaryExpression subtract(Expression expression, Expression expression2) {
        return new BinaryExpression(expression, expression2){

            @Override
            public String getOperator() {
                return "-";
            }

            @Override
            public Object evaluate(Object object) {
                Number number;
                Number number2 = (Number)this.getLeft().evaluate(object);
                Number number3 = (Number)this.getRight().evaluate(object);
                if (number2 instanceof Double || number3 instanceof Double) {
                    number = number2.doubleValue() - number3.doubleValue();
                } else if (number2 instanceof Float || number3 instanceof Float) {
                    number = Float.valueOf(number2.floatValue() - number3.floatValue());
                } else if (number2 instanceof Long || number3 instanceof Long) {
                    number = number2.longValue() - number3.longValue();
                } else if (number2 instanceof Integer || number3 instanceof Integer) {
                    number = number2.intValue() - number3.intValue();
                } else if (number2 instanceof Short || number3 instanceof Short) {
                    number = number2.shortValue() - number3.shortValue();
                } else if (number2 instanceof Byte || number3 instanceof Byte) {
                    number = number2.byteValue() - number3.byteValue();
                } else {
                    throw new UnsupportedOperationException();
                }
                return number;
            }
        };
    }

    public static BinaryExpression subtract(Expression expression, Number number) {
        return Expression.subtract(expression, (Expression)new LiteralExpression(number));
    }

    public static BinaryExpression subtract(Number number, Expression expression) {
        return Expression.subtract((Expression)new LiteralExpression(number), expression);
    }

    public static BinaryExpression subtract(Number number, Number number2) {
        return Expression.subtract((Expression)new LiteralExpression(number), (Expression)new LiteralExpression(number2));
    }

    public static BinaryExpression multiply(Expression expression, Expression expression2) {
        return new BinaryExpression(expression, expression2){

            @Override
            public String getOperator() {
                return Expression.MULTIPLY;
            }

            @Override
            public Object evaluate(Object object) {
                Number number;
                Number number2 = (Number)this.getLeft().evaluate(object);
                Number number3 = (Number)this.getRight().evaluate(object);
                if (number2 instanceof Double || number3 instanceof Double) {
                    number = number2.doubleValue() * number3.doubleValue();
                } else if (number2 instanceof Float || number3 instanceof Float) {
                    number = Float.valueOf(number2.floatValue() * number3.floatValue());
                } else if (number2 instanceof Long || number3 instanceof Long) {
                    number = number2.longValue() * number3.longValue();
                } else if (number2 instanceof Integer || number3 instanceof Integer) {
                    number = number2.intValue() * number3.intValue();
                } else if (number2 instanceof Short || number3 instanceof Short) {
                    number = number2.shortValue() * number3.shortValue();
                } else if (number2 instanceof Byte || number3 instanceof Byte) {
                    number = number2.byteValue() * number3.byteValue();
                } else {
                    throw new UnsupportedOperationException();
                }
                return number;
            }
        };
    }

    public static BinaryExpression multiply(Expression expression, Number number) {
        return Expression.multiply(expression, (Expression)new LiteralExpression(number));
    }

    public static BinaryExpression multiply(Number number, Expression expression) {
        return Expression.multiply((Expression)new LiteralExpression(number), expression);
    }

    public static BinaryExpression multiply(Number number, Number number2) {
        return Expression.multiply((Expression)new LiteralExpression(number), (Expression)new LiteralExpression(number2));
    }

    public static BinaryExpression divide(Expression expression, Expression expression2) {
        return new BinaryExpression(expression, expression2){

            @Override
            public String getOperator() {
                return Expression.DIVIDE;
            }

            @Override
            public Object evaluate(Object object) {
                Number number;
                Number number2 = (Number)this.getLeft().evaluate(object);
                Number number3 = (Number)this.getRight().evaluate(object);
                if (number2 instanceof Double || number3 instanceof Double) {
                    number = number2.doubleValue() / number3.doubleValue();
                } else if (number2 instanceof Float || number3 instanceof Float) {
                    number = Float.valueOf(number2.floatValue() / number3.floatValue());
                } else if (number2 instanceof Long || number3 instanceof Long) {
                    number = number2.longValue() / number3.longValue();
                } else if (number2 instanceof Integer || number3 instanceof Integer) {
                    number = number2.intValue() / number3.intValue();
                } else if (number2 instanceof Short || number3 instanceof Short) {
                    number = number2.shortValue() / number3.shortValue();
                } else if (number2 instanceof Byte || number3 instanceof Byte) {
                    number = number2.byteValue() / number3.byteValue();
                } else {
                    throw new UnsupportedOperationException();
                }
                return number;
            }
        };
    }

    public static BinaryExpression divide(Expression expression, Number number) {
        return Expression.divide(expression, (Expression)new LiteralExpression(number));
    }

    public static BinaryExpression divide(Number number, Expression expression) {
        return Expression.divide((Expression)new LiteralExpression(number), expression);
    }

    public static BinaryExpression divide(Number number, Number number2) {
        return Expression.divide((Expression)new LiteralExpression(number), (Expression)new LiteralExpression(number2));
    }

    public static BinaryExpression modulo(Expression expression, Expression expression2) {
        return new BinaryExpression(expression, expression2){

            @Override
            public String getOperator() {
                return Expression.MODULO;
            }

            @Override
            public Object evaluate(Object object) {
                Number number;
                Number number2 = (Number)this.getLeft().evaluate(object);
                Number number3 = (Number)this.getRight().evaluate(object);
                if (number2 instanceof Double || number3 instanceof Double) {
                    number = number2.doubleValue() % number3.doubleValue();
                } else if (number2 instanceof Float || number3 instanceof Float) {
                    number = Float.valueOf(number2.floatValue() % number3.floatValue());
                } else if (number2 instanceof Long || number3 instanceof Long) {
                    number = number2.longValue() % number3.longValue();
                } else if (number2 instanceof Integer || number3 instanceof Integer) {
                    number = number2.intValue() % number3.intValue();
                } else if (number2 instanceof Short || number3 instanceof Short) {
                    number = number2.shortValue() % number3.shortValue();
                } else if (number2 instanceof Byte || number3 instanceof Byte) {
                    number = number2.byteValue() % number3.byteValue();
                } else {
                    throw new UnsupportedOperationException();
                }
                return number;
            }
        };
    }

    public static BinaryExpression modulo(Expression expression, Number number) {
        return Expression.modulo(expression, (Expression)new LiteralExpression(number));
    }

    public static BinaryExpression modulo(Number number, Expression expression) {
        return Expression.modulo((Expression)new LiteralExpression(number), expression);
    }

    public static BinaryExpression modulo(Number number, Number number2) {
        return Expression.modulo((Expression)new LiteralExpression(number), (Expression)new LiteralExpression(number2));
    }

    public static BinaryExpression equalTo(Expression expression, Expression expression2) {
        return new BinaryExpression(expression, expression2){

            @Override
            public String getOperator() {
                return Expression.EQUAL_TO;
            }

            @Override
            public Object evaluate(Object object) {
                return ((Comparable)this.getLeft().evaluate(object)).compareTo(this.getRight().evaluate(object)) == 0;
            }
        };
    }

    public static BinaryExpression equalTo(Expression expression, Object object) {
        return Expression.equalTo(expression, (Expression)new LiteralExpression(object));
    }

    public static BinaryExpression equalTo(Object object, Expression expression) {
        return Expression.equalTo((Expression)new LiteralExpression(object), expression);
    }

    public static BinaryExpression equalTo(Object object, Object object2) {
        return Expression.equalTo((Expression)new LiteralExpression(object), (Expression)new LiteralExpression(object2));
    }

    public static BinaryExpression notEqualTo(Expression expression, Expression expression2) {
        return new BinaryExpression(expression, expression2){

            @Override
            public String getOperator() {
                return Expression.NOT_EQUAL_TO;
            }

            @Override
            public Object evaluate(Object object) {
                return ((Comparable)this.getLeft().evaluate(object)).compareTo(this.getRight().evaluate(object)) != 0;
            }
        };
    }

    public static BinaryExpression notEqualTo(Expression expression, Object object) {
        return Expression.notEqualTo(expression, (Expression)new LiteralExpression(object));
    }

    public static BinaryExpression notEqualTo(Object object, Expression expression) {
        return Expression.notEqualTo((Expression)new LiteralExpression(object), expression);
    }

    public static BinaryExpression notEqualTo(Object object, Object object2) {
        return Expression.notEqualTo((Expression)new LiteralExpression(object), (Expression)new LiteralExpression(object2));
    }

    public static BinaryExpression greaterThan(Expression expression, Expression expression2) {
        return new BinaryExpression(expression, expression2){

            @Override
            public String getOperator() {
                return Expression.GREATER_THAN;
            }

            @Override
            public Object evaluate(Object object) {
                return ((Comparable)this.getLeft().evaluate(object)).compareTo(this.getRight().evaluate(object)) > 0;
            }
        };
    }

    public static BinaryExpression greaterThan(Expression expression, Object object) {
        return Expression.greaterThan(expression, (Expression)new LiteralExpression(object));
    }

    public static BinaryExpression greaterThan(Object object, Expression expression) {
        return Expression.greaterThan((Expression)new LiteralExpression(object), expression);
    }

    public static BinaryExpression greaterThan(Object object, Object object2) {
        return Expression.greaterThan((Expression)new LiteralExpression(object), (Expression)new LiteralExpression(object2));
    }

    public static BinaryExpression greaterThanOrEqualTo(Expression expression, Expression expression2) {
        return new BinaryExpression(expression, expression2){

            @Override
            public String getOperator() {
                return Expression.GREATER_THAN_OR_EQUAL_TO;
            }

            @Override
            public Object evaluate(Object object) {
                return ((Comparable)this.getLeft().evaluate(object)).compareTo(this.getRight().evaluate(object)) >= 0;
            }
        };
    }

    public static BinaryExpression greaterThanOrEqualTo(Expression expression, Object object) {
        return Expression.greaterThanOrEqualTo(expression, (Expression)new LiteralExpression(object));
    }

    public static BinaryExpression greaterThanOrEqualTo(Object object, Expression expression) {
        return Expression.greaterThanOrEqualTo((Expression)new LiteralExpression(object), expression);
    }

    public static BinaryExpression greaterThanOrEqualTo(Object object, Object object2) {
        return Expression.greaterThanOrEqualTo((Expression)new LiteralExpression(object), (Expression)new LiteralExpression(object2));
    }

    public static BinaryExpression lessThan(Expression expression, Expression expression2) {
        return new BinaryExpression(expression, expression2){

            @Override
            public String getOperator() {
                return Expression.LESS_THAN;
            }

            @Override
            public Object evaluate(Object object) {
                return ((Comparable)this.getLeft().evaluate(object)).compareTo(this.getRight().evaluate(object)) < 0;
            }
        };
    }

    public static BinaryExpression lessThan(Expression expression, Object object) {
        return Expression.lessThan(expression, (Expression)new LiteralExpression(object));
    }

    public static BinaryExpression lessThan(Object object, Expression expression) {
        return Expression.lessThan((Expression)new LiteralExpression(object), expression);
    }

    public static BinaryExpression lessThan(Object object, Object object2) {
        return Expression.lessThan((Expression)new LiteralExpression(object), (Expression)new LiteralExpression(object2));
    }

    public static BinaryExpression lessThanOrEqualTo(Expression expression, Expression expression2) {
        return new BinaryExpression(expression, expression2){

            @Override
            public String getOperator() {
                return Expression.LESS_THAN_OR_EQUAL_TO;
            }

            @Override
            public Object evaluate(Object object) {
                return ((Comparable)this.getLeft().evaluate(object)).compareTo(this.getRight().evaluate(object)) <= 0;
            }
        };
    }

    public static BinaryExpression lessThanOrEqualTo(Expression expression, Object object) {
        return Expression.lessThanOrEqualTo(expression, (Expression)new LiteralExpression(object));
    }

    public static BinaryExpression lessThanOrEqualTo(Object object, Expression expression) {
        return Expression.lessThanOrEqualTo((Expression)new LiteralExpression(object), expression);
    }

    public static BinaryExpression lessThanOrEqualTo(Object object, Object object2) {
        return Expression.lessThanOrEqualTo((Expression)new LiteralExpression(object), (Expression)new LiteralExpression(object2));
    }

    public static BinaryExpression and(Expression expression, Expression expression2) {
        return new BinaryExpression(expression, expression2){

            @Override
            public String getOperator() {
                return Expression.AND;
            }

            @Override
            public Object evaluate(Object object) {
                return (Boolean)this.getLeft().evaluate(object) != false && (Boolean)this.getRight().evaluate(object) != false;
            }
        };
    }

    public static BinaryExpression and(Expression expression, Boolean bl) {
        return Expression.and(expression, (Expression)new LiteralExpression(bl));
    }

    public static BinaryExpression and(Boolean bl, Expression expression) {
        return Expression.and((Expression)new LiteralExpression(bl), expression);
    }

    public static BinaryExpression and(Boolean bl, Boolean bl2) {
        return Expression.and((Expression)new LiteralExpression(bl), (Expression)new LiteralExpression(bl2));
    }

    public static BinaryExpression or(Expression expression, Expression expression2) {
        return new BinaryExpression(expression, expression2){

            @Override
            public String getOperator() {
                return Expression.OR;
            }

            @Override
            public Object evaluate(Object object) {
                return (Boolean)this.getLeft().evaluate(object) != false || (Boolean)this.getRight().evaluate(object) != false;
            }
        };
    }

    public static BinaryExpression or(Expression expression, Boolean bl) {
        return Expression.or(expression, (Expression)new LiteralExpression(bl));
    }

    public static BinaryExpression or(Boolean bl, Expression expression) {
        return Expression.or((Expression)new LiteralExpression(bl), expression);
    }

    public static BinaryExpression or(Boolean bl, Boolean bl2) {
        return Expression.or((Expression)new LiteralExpression(bl), (Expression)new LiteralExpression(bl2));
    }

    public static UnaryExpression negate(Expression expression) {
        return new UnaryExpression(expression){

            @Override
            public String getOperator() {
                return "-";
            }

            @Override
            public Object evaluate(Object object) {
                Number number = (Number)this.getOperand().evaluate(object);
                Class<?> clazz = number.getClass();
                if (clazz == Byte.class) {
                    number = (int)(-number.byteValue());
                } else if (clazz == Short.class) {
                    number = (int)(-number.shortValue());
                } else if (clazz == Integer.class) {
                    number = -number.intValue();
                } else if (clazz == Long.class) {
                    number = -number.longValue();
                } else if (clazz == Float.class) {
                    number = Float.valueOf(-number.floatValue());
                } else if (clazz == Double.class) {
                    number = -number.doubleValue();
                } else {
                    throw new UnsupportedOperationException();
                }
                return number;
            }
        };
    }

    public UnaryExpression negate(Number number) {
        return Expression.negate(new LiteralExpression(number));
    }

    public static UnaryExpression not(Expression expression) {
        return new UnaryExpression(expression){

            @Override
            public String getOperator() {
                return Expression.NOT;
            }

            @Override
            public Object evaluate(Object object) {
                return (Boolean)this.getOperand().evaluate(object) == false;
            }
        };
    }

    public static UnaryExpression not(Boolean bl) {
        return Expression.not(new LiteralExpression(bl));
    }

    public static Expression valueOf(String string) {
        Expression expression;
        if (string == null) {
            throw new NullPointerException();
        }
        Parser parser = new Parser();
        try {
            expression = parser.parse(new StringReader(string));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return expression;
    }

    private static class Parser {
        private int c = -1;
        private char[] pushbackBuffer = new char[6];
        private static final int MAX_PRIORITY = 6;
        private static final int PUSHBACK_BUFFER_SIZE = 6;

        private Parser() {
        }

        public Expression parse(Reader reader) throws IOException {
            LinkedList<Token> linkedList = this.tokenize(new PushbackReader(reader, 6));
            LinkedList<LiteralExpression> linkedList2 = new LinkedList<LiteralExpression>();
            for (Token token : linkedList) {
                Expression expression;
                switch (token.type) {
                    case LITERAL: {
                        expression = new LiteralExpression(token.value);
                        break;
                    }
                    case VARIABLE: {
                        expression = new VariableExpression((KeyPath)token.value);
                        break;
                    }
                    case FUNCTION: {
                        expression = null;
                        break;
                    }
                    case UNARY_OPERATOR: {
                        String string = (String)token.value;
                        Expression expression2 = (Expression)linkedList2.pop();
                        if (string.equals("-")) {
                            expression = Expression.negate(expression2);
                            break;
                        }
                        if (string.equals(Expression.NOT)) {
                            expression = Expression.not(expression2);
                            break;
                        }
                        throw new UnsupportedOperationException();
                    }
                    case BINARY_OPERATOR: {
                        String string = (String)token.value;
                        Expression expression2 = (Expression)linkedList2.pop();
                        Expression expression3 = (Expression)linkedList2.pop();
                        if (string.equals(Expression.ADD)) {
                            expression = Expression.add(expression3, expression2);
                            break;
                        }
                        if (string.equals("-")) {
                            expression = Expression.subtract(expression3, expression2);
                            break;
                        }
                        if (string.equals(Expression.MULTIPLY)) {
                            expression = Expression.multiply(expression3, expression2);
                            break;
                        }
                        if (string.equals(Expression.DIVIDE)) {
                            expression = Expression.divide(expression3, expression2);
                            break;
                        }
                        if (string.equals(Expression.MODULO)) {
                            expression = Expression.modulo(expression3, expression2);
                            break;
                        }
                        if (string.equals(Expression.GREATER_THAN)) {
                            expression = Expression.greaterThan(expression3, expression2);
                            break;
                        }
                        if (string.equals(Expression.GREATER_THAN_OR_EQUAL_TO)) {
                            expression = Expression.greaterThanOrEqualTo(expression3, expression2);
                            break;
                        }
                        if (string.equals(Expression.LESS_THAN)) {
                            expression = Expression.lessThan(expression3, expression2);
                            break;
                        }
                        if (string.equals(Expression.LESS_THAN_OR_EQUAL_TO)) {
                            expression = Expression.lessThanOrEqualTo(expression3, expression2);
                            break;
                        }
                        if (string.equals(Expression.EQUAL_TO)) {
                            expression = Expression.equalTo(expression3, expression2);
                            break;
                        }
                        if (string.equals(Expression.NOT_EQUAL_TO)) {
                            expression = Expression.notEqualTo(expression3, expression2);
                            break;
                        }
                        if (string.equals(Expression.AND)) {
                            expression = Expression.and(expression3, expression2);
                            break;
                        }
                        if (string.equals(Expression.OR)) {
                            expression = Expression.or(expression3, expression2);
                            break;
                        }
                        throw new UnsupportedOperationException();
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                linkedList2.push((LiteralExpression)expression);
            }
            if (linkedList2.size() != 1) {
                throw new IllegalArgumentException("Invalid expression.");
            }
            return (Expression)linkedList2.peek();
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private LinkedList<Token> tokenize(PushbackReader pushbackReader) throws IOException {
            LinkedList<Token> linkedList = new LinkedList<Token>();
            LinkedList<Token> linkedList2 = new LinkedList<Token>();
            this.c = pushbackReader.read();
            boolean bl = true;
            while (this.c != -1) {
                int n;
                Token token;
                while (this.c != -1 && Character.isWhitespace(this.c)) {
                    this.c = pushbackReader.read();
                }
                if (this.c == -1) continue;
                if (this.c == 110) {
                    if (this.readKeyword(pushbackReader, Expression.NULL_KEYWORD)) {
                        token = new Token(TokenType.LITERAL, null);
                    } else {
                        token = new Token(TokenType.VARIABLE, KeyPath.parse(pushbackReader));
                        this.c = pushbackReader.read();
                    }
                } else if (this.c == 34 || this.c == 39) {
                    StringBuilder stringBuilder = new StringBuilder();
                    n = this.c;
                    this.c = pushbackReader.read();
                    while (this.c != -1 && this.c != n) {
                        if (!Character.isISOControl(this.c)) {
                            if (this.c == 92) {
                                this.c = pushbackReader.read();
                                if (this.c == 98) {
                                    this.c = 8;
                                } else if (this.c == 102) {
                                    this.c = 12;
                                } else if (this.c == 110) {
                                    this.c = 10;
                                } else if (this.c == 114) {
                                    this.c = 13;
                                } else if (this.c == 116) {
                                    this.c = 9;
                                } else if (this.c == 117) {
                                    StringBuilder stringBuilder2 = new StringBuilder();
                                    while (stringBuilder2.length() < 4) {
                                        this.c = pushbackReader.read();
                                        stringBuilder2.append((char)this.c);
                                    }
                                    String string = stringBuilder2.toString();
                                    this.c = (char)Integer.parseInt(string, 16);
                                } else if (this.c != 92 && this.c != 47 && this.c != 34 && this.c != 39 && this.c != n) {
                                    throw new IllegalArgumentException("Unsupported escape sequence.");
                                }
                            }
                            stringBuilder.append((char)this.c);
                        }
                        this.c = pushbackReader.read();
                    }
                    if (this.c != n) {
                        throw new IllegalArgumentException("Unterminated string.");
                    }
                    this.c = pushbackReader.read();
                    token = new Token(TokenType.LITERAL, stringBuilder.toString());
                } else if (Character.isDigit(this.c)) {
                    void var8_14;
                    StringBuilder stringBuilder = new StringBuilder();
                    n = 1;
                    while (this.c != -1 && (Character.isDigit(this.c) || this.c == 46 || this.c == 101 || this.c == 69)) {
                        stringBuilder.append((char)this.c);
                        n &= this.c != 46 ? 1 : 0;
                        this.c = pushbackReader.read();
                    }
                    if (n != 0) {
                        Long l = Long.parseLong(stringBuilder.toString());
                    } else {
                        Double d = Double.parseDouble(stringBuilder.toString());
                    }
                    token = new Token(TokenType.LITERAL, var8_14);
                } else if (this.c == 116) {
                    if (this.readKeyword(pushbackReader, Expression.TRUE_KEYWORD)) {
                        token = new Token(TokenType.LITERAL, true);
                    } else {
                        token = new Token(TokenType.VARIABLE, KeyPath.parse(pushbackReader));
                        this.c = pushbackReader.read();
                    }
                } else if (this.c == 102) {
                    if (this.readKeyword(pushbackReader, Expression.FALSE_KEYWORD)) {
                        token = new Token(TokenType.LITERAL, false);
                    } else {
                        token = new Token(TokenType.VARIABLE, KeyPath.parse(pushbackReader));
                        this.c = pushbackReader.read();
                    }
                } else if (Character.isJavaIdentifierStart(this.c)) {
                    pushbackReader.unread(this.c);
                    token = new Token(TokenType.VARIABLE, KeyPath.parse(pushbackReader));
                    this.c = pushbackReader.read();
                } else {
                    if (this.c == "-".charAt(0) && bl) {
                        token = new Token(TokenType.UNARY_OPERATOR, "-");
                    } else if (this.c == Expression.NOT.charAt(0) && bl) {
                        token = new Token(TokenType.UNARY_OPERATOR, Expression.NOT);
                    } else if (this.c == Expression.ADD.charAt(0)) {
                        token = new Token(TokenType.BINARY_OPERATOR, Expression.ADD);
                    } else if (this.c == "-".charAt(0)) {
                        token = new Token(TokenType.BINARY_OPERATOR, "-");
                    } else if (this.c == Expression.MULTIPLY.charAt(0)) {
                        token = new Token(TokenType.BINARY_OPERATOR, Expression.MULTIPLY);
                    } else if (this.c == Expression.DIVIDE.charAt(0)) {
                        token = new Token(TokenType.BINARY_OPERATOR, Expression.DIVIDE);
                    } else if (this.c == Expression.MODULO.charAt(0)) {
                        token = new Token(TokenType.BINARY_OPERATOR, Expression.MODULO);
                    } else if (this.c == Expression.EQUAL_TO.charAt(0)) {
                        this.c = pushbackReader.read();
                        if (this.c != Expression.EQUAL_TO.charAt(1)) throw new IllegalArgumentException();
                        token = new Token(TokenType.BINARY_OPERATOR, Expression.EQUAL_TO);
                    } else if (this.c == Expression.NOT_EQUAL_TO.charAt(0)) {
                        this.c = pushbackReader.read();
                        if (this.c != Expression.NOT_EQUAL_TO.charAt(1)) throw new IllegalArgumentException();
                        token = new Token(TokenType.BINARY_OPERATOR, Expression.NOT_EQUAL_TO);
                    } else if (this.c == Expression.GREATER_THAN.charAt(0)) {
                        this.c = pushbackReader.read();
                        token = this.c == Expression.GREATER_THAN_OR_EQUAL_TO.charAt(1) ? new Token(TokenType.BINARY_OPERATOR, Expression.GREATER_THAN_OR_EQUAL_TO) : new Token(TokenType.BINARY_OPERATOR, Expression.GREATER_THAN);
                    } else if (this.c == Expression.LESS_THAN.charAt(0)) {
                        this.c = pushbackReader.read();
                        token = this.c == Expression.LESS_THAN_OR_EQUAL_TO.charAt(1) ? new Token(TokenType.BINARY_OPERATOR, Expression.LESS_THAN_OR_EQUAL_TO) : new Token(TokenType.BINARY_OPERATOR, Expression.LESS_THAN);
                    } else if (this.c == Expression.AND.charAt(0)) {
                        this.c = pushbackReader.read();
                        if (this.c != Expression.AND.charAt(0)) throw new IllegalArgumentException();
                        token = new Token(TokenType.BINARY_OPERATOR, Expression.AND);
                    } else if (this.c == Expression.OR.charAt(0)) {
                        this.c = pushbackReader.read();
                        if (this.c != Expression.OR.charAt(0)) throw new IllegalArgumentException();
                        token = new Token(TokenType.BINARY_OPERATOR, Expression.OR);
                    } else if (this.c == 40) {
                        token = new Token(TokenType.BEGIN_GROUP, Expression.LEFT_PARENTHESIS);
                    } else {
                        if (this.c != 41) throw new IllegalArgumentException("Unexpected character in expression.");
                        token = new Token(TokenType.END_GROUP, Expression.RIGHT_PARENTHESIS);
                    }
                    this.c = pushbackReader.read();
                }
                switch (token.type) {
                    case LITERAL: 
                    case VARIABLE: {
                        linkedList.add(token);
                        break;
                    }
                    case UNARY_OPERATOR: 
                    case BINARY_OPERATOR: {
                        int n2 = this.getPriority((String)token.value);
                        while (!linkedList2.isEmpty() && ((Token)linkedList2.peek()).type != TokenType.BEGIN_GROUP && this.getPriority((String)((Token)linkedList2.peek()).value) >= n2 && this.getPriority((String)((Token)linkedList2.peek()).value) != 6) {
                            linkedList.add((Token)linkedList2.pop());
                        }
                        linkedList2.push(token);
                        break;
                    }
                    case BEGIN_GROUP: {
                        linkedList2.push(token);
                        break;
                    }
                    case END_GROUP: {
                        token = (Token)linkedList2.pop();
                        while (token.type != TokenType.BEGIN_GROUP) {
                            linkedList.add(token);
                            token = (Token)linkedList2.pop();
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                bl = token.type != TokenType.LITERAL && token.type != TokenType.VARIABLE;
            }
            while (!linkedList2.isEmpty()) {
                linkedList.add((Token)linkedList2.pop());
            }
            return linkedList;
        }

        private boolean readKeyword(PushbackReader pushbackReader, String string) throws IOException {
            boolean bl;
            int n;
            int n2 = string.length();
            for (n = 0; this.c != -1 && n < n2; ++n) {
                this.pushbackBuffer[n] = (char)this.c;
                if (string.charAt(n) != this.c) break;
                this.c = pushbackReader.read();
            }
            if (n < n2) {
                pushbackReader.unread(this.pushbackBuffer, 0, n + 1);
                bl = false;
            } else {
                bl = true;
            }
            return bl;
        }

        private int getPriority(String string) {
            int n;
            if (string.equals("-") || string.equals(Expression.NOT)) {
                n = 6;
            } else if (string.equals(Expression.MULTIPLY) || string.equals(Expression.DIVIDE) || string.equals(Expression.MODULO)) {
                n = 5;
            } else if (string.equals(Expression.ADD) || string.equals("-")) {
                n = 4;
            } else if (string.equals(Expression.GREATER_THAN) || string.equals(Expression.GREATER_THAN_OR_EQUAL_TO) || string.equals(Expression.LESS_THAN) || string.equals(Expression.LESS_THAN_OR_EQUAL_TO)) {
                n = 3;
            } else if (string.equals(Expression.EQUAL_TO) || string.equals(Expression.NOT_EQUAL_TO)) {
                n = 2;
            } else if (string.equals(Expression.AND)) {
                n = 1;
            } else if (string.equals(Expression.OR)) {
                n = 0;
            } else {
                throw new IllegalArgumentException();
            }
            return n;
        }

        public static enum TokenType {
            LITERAL,
            VARIABLE,
            FUNCTION,
            UNARY_OPERATOR,
            BINARY_OPERATOR,
            BEGIN_GROUP,
            END_GROUP;

        }

        public static class Token {
            public final TokenType type;
            public final Object value;

            public Token(TokenType tokenType, Object object) {
                this.type = tokenType;
                this.value = object;
            }

            public String toString() {
                return this.value.toString();
            }
        }
    }
}

