/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.TwoLevelFocusBehavior;
import com.sun.javafx.scene.traversal.Direction;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class TwoLevelFocusListBehavior
extends TwoLevelFocusBehavior {
    final EventDispatcher preemptiveEventDispatcher = new EventDispatcher(){

        @Override
        public Event dispatchEvent(Event event, EventDispatchChain eventDispatchChain) {
            if (event instanceof KeyEvent && event.getEventType() == KeyEvent.KEY_PRESSED && !((KeyEvent)event).isMetaDown() && !((KeyEvent)event).isControlDown() && !((KeyEvent)event).isAltDown() && TwoLevelFocusListBehavior.this.isExternalFocus()) {
                EventTarget eventTarget = event.getTarget();
                switch (((KeyEvent)event).getCode()) {
                    case TAB: {
                        if (((KeyEvent)event).isShiftDown()) {
                            ((Node)eventTarget).impl_traverse(Direction.PREVIOUS);
                        } else {
                            ((Node)eventTarget).impl_traverse(Direction.NEXT);
                        }
                        event.consume();
                        break;
                    }
                    case UP: {
                        ((Node)eventTarget).impl_traverse(Direction.UP);
                        event.consume();
                        break;
                    }
                    case DOWN: {
                        ((Node)eventTarget).impl_traverse(Direction.DOWN);
                        event.consume();
                        break;
                    }
                    case LEFT: {
                        ((Node)eventTarget).impl_traverse(Direction.LEFT);
                        event.consume();
                        break;
                    }
                    case RIGHT: {
                        ((Node)eventTarget).impl_traverse(Direction.RIGHT);
                        event.consume();
                        break;
                    }
                    case ENTER: {
                        TwoLevelFocusListBehavior.this.setExternalFocus(false);
                        event.consume();
                        break;
                    }
                    default: {
                        Scene scene = TwoLevelFocusListBehavior.this.tlNode.getScene();
                        Event.fireEvent(scene, event);
                        event.consume();
                    }
                }
            }
            return event;
        }
    };
    final EventDispatcher tlfEventDispatcher = new EventDispatcher(){

        @Override
        public Event dispatchEvent(Event event, EventDispatchChain eventDispatchChain) {
            if (event instanceof KeyEvent && TwoLevelFocusListBehavior.this.isExternalFocus()) {
                eventDispatchChain = eventDispatchChain.prepend(TwoLevelFocusListBehavior.this.preemptiveEventDispatcher);
                return eventDispatchChain.dispatchEvent(event);
            }
            return TwoLevelFocusListBehavior.this.origEventDispatcher.dispatchEvent(event, eventDispatchChain);
        }
    };
    private final EventHandler<KeyEvent> keyEventListener = new EventHandler<KeyEvent>(){

        @Override
        public void handle(KeyEvent keyEvent) {
            TwoLevelFocusListBehavior.this.postDispatchTidyup((Event)keyEvent);
        }
    };
    final ChangeListener<Boolean> focusListener = new ChangeListener<Boolean>(){

        @Override
        public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
            if (bl2.booleanValue() && TwoLevelFocusListBehavior.this.tlPopup != null) {
                TwoLevelFocusListBehavior.this.setExternalFocus(false);
            } else {
                Parent parent;
                boolean bl3 = true;
                if (TwoLevelFocusListBehavior.this.tlNode != null && (parent = TwoLevelFocusListBehavior.this.tlNode.getParent()) != null && "combo-box-popup".equals(parent.getStyleClass().toString())) {
                    bl3 = false;
                }
                TwoLevelFocusListBehavior.this.setExternalFocus(bl3);
            }
        }
    };
    private final EventHandler<MouseEvent> mouseEventListener = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent mouseEvent) {
            TwoLevelFocusListBehavior.this.setExternalFocus(false);
        }
    };

    public TwoLevelFocusListBehavior(Node node) {
        this.tlNode = node;
        this.tlNode.addEventHandler(KeyEvent.ANY, this.keyEventListener);
        this.tlNode.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventListener);
        this.tlNode.focusedProperty().addListener(this.focusListener);
        this.origEventDispatcher = this.tlNode.getEventDispatcher();
        this.tlNode.setEventDispatcher(this.tlfEventDispatcher);
    }

    @Override
    public void dispose() {
        this.tlNode.removeEventHandler(KeyEvent.ANY, this.keyEventListener);
        this.tlNode.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventListener);
        this.tlNode.focusedProperty().removeListener(this.focusListener);
        this.tlNode.setEventDispatcher(this.origEventDispatcher);
    }

    private Event postDispatchTidyup(Event event) {
        if (!(!(event instanceof KeyEvent) || event.getEventType() != KeyEvent.KEY_PRESSED || this.isExternalFocus() || ((KeyEvent)event).isMetaDown() || ((KeyEvent)event).isControlDown() || ((KeyEvent)event).isAltDown())) {
            switch (((KeyEvent)event).getCode()) {
                case TAB: 
                case UP: 
                case DOWN: 
                case LEFT: 
                case RIGHT: {
                    event.consume();
                    break;
                }
                case ENTER: {
                    this.setExternalFocus(true);
                    event.consume();
                    break;
                }
            }
        }
        return event;
    }
}

