/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.css.converters.StringConverter;
import com.sun.javafx.scene.control.behavior.ColorPickerBehavior;
import com.sun.javafx.scene.control.skin.ColorPalette;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin;
import com.sun.javafx.scene.control.skin.ComboBoxMode;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class ColorPickerSkin
extends ComboBoxPopupControl<Color> {
    private Label displayNode;
    private StackPane pickerColorBox;
    private Rectangle colorRect;
    private ColorPalette popupContent;
    BooleanProperty colorLabelVisible = new StyleableBooleanProperty(true){

        @Override
        public void invalidated() {
            if (ColorPickerSkin.this.displayNode != null) {
                if (ColorPickerSkin.this.colorLabelVisible.get()) {
                    ColorPickerSkin.this.displayNode.setText(ColorPickerSkin.colorValueToWeb((Color)((ColorPicker)ColorPickerSkin.this.getSkinnable()).getValue()));
                } else {
                    ColorPickerSkin.this.displayNode.setText("");
                }
            }
        }

        @Override
        public Object getBean() {
            return ColorPickerSkin.this;
        }

        @Override
        public String getName() {
            return "colorLabelVisible";
        }

        @Override
        public CssMetaData<ColorPicker, Boolean> getCssMetaData() {
            return StyleableProperties.COLOR_LABEL_VISIBLE;
        }
    };
    private final StyleableStringProperty imageUrl = new StyleableStringProperty(){

        @Override
        public void applyStyle(StyleOrigin styleOrigin, String string) {
            super.applyStyle(styleOrigin, string);
            if (string == null) {
                if (ColorPickerSkin.this.pickerColorBox.getChildren().size() == 2) {
                    ColorPickerSkin.this.pickerColorBox.getChildren().remove(1);
                }
            } else if (ColorPickerSkin.this.pickerColorBox.getChildren().size() == 2) {
                ImageView imageView = (ImageView)ColorPickerSkin.this.pickerColorBox.getChildren().get(1);
                imageView.setImage(StyleManager.getInstance().getCachedImage(string));
            } else {
                ColorPickerSkin.this.pickerColorBox.getChildren().add(new ImageView(StyleManager.getInstance().getCachedImage(string)));
            }
        }

        @Override
        public Object getBean() {
            return ColorPickerSkin.this;
        }

        @Override
        public String getName() {
            return "imageUrl";
        }

        @Override
        public CssMetaData<ColorPicker, String> getCssMetaData() {
            return StyleableProperties.GRAPHIC;
        }
    };
    private final StyleableDoubleProperty colorRectWidth = new StyleableDoubleProperty(12.0){

        @Override
        protected void invalidated() {
            if (ColorPickerSkin.this.pickerColorBox != null) {
                ColorPickerSkin.this.pickerColorBox.requestLayout();
            }
        }

        @Override
        public CssMetaData<ColorPicker, Number> getCssMetaData() {
            return StyleableProperties.COLOR_RECT_WIDTH;
        }

        @Override
        public Object getBean() {
            return ColorPickerSkin.this;
        }

        @Override
        public String getName() {
            return "colorRectWidth";
        }
    };
    private final StyleableDoubleProperty colorRectHeight = new StyleableDoubleProperty(12.0){

        @Override
        protected void invalidated() {
            if (ColorPickerSkin.this.pickerColorBox != null) {
                ColorPickerSkin.this.pickerColorBox.requestLayout();
            }
        }

        @Override
        public CssMetaData<ColorPicker, Number> getCssMetaData() {
            return StyleableProperties.COLOR_RECT_HEIGHT;
        }

        @Override
        public Object getBean() {
            return ColorPickerSkin.this;
        }

        @Override
        public String getName() {
            return "colorRectHeight";
        }
    };
    private final StyleableDoubleProperty colorRectX = new StyleableDoubleProperty(0.0){

        @Override
        protected void invalidated() {
            if (ColorPickerSkin.this.pickerColorBox != null) {
                ColorPickerSkin.this.pickerColorBox.requestLayout();
            }
        }

        @Override
        public CssMetaData<ColorPicker, Number> getCssMetaData() {
            return StyleableProperties.COLOR_RECT_X;
        }

        @Override
        public Object getBean() {
            return ColorPickerSkin.this;
        }

        @Override
        public String getName() {
            return "colorRectX";
        }
    };
    private final StyleableDoubleProperty colorRectY = new StyleableDoubleProperty(0.0){

        @Override
        protected void invalidated() {
            if (ColorPickerSkin.this.pickerColorBox != null) {
                ColorPickerSkin.this.pickerColorBox.requestLayout();
            }
        }

        @Override
        public CssMetaData<ColorPicker, Number> getCssMetaData() {
            return StyleableProperties.COLOR_RECT_Y;
        }

        @Override
        public Object getBean() {
            return ColorPickerSkin.this;
        }

        @Override
        public String getName() {
            return "colorRectY";
        }
    };
    private static final Map<Color, String> colorNameMap = new HashMap<Color, String>(147);

    public StringProperty imageUrlProperty() {
        return this.imageUrl;
    }

    public ColorPickerSkin(ColorPicker colorPicker) {
        super(colorPicker, new ColorPickerBehavior(colorPicker));
        this.updateComboBoxMode();
        if (this.getMode() == ComboBoxMode.BUTTON || this.getMode() == ComboBoxMode.COMBOBOX) {
            if (this.arrowButton.getOnMouseReleased() == null) {
                this.arrowButton.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                    @Override
                    public void handle(MouseEvent mouseEvent) {
                        ((ColorPickerBehavior)ColorPickerSkin.this.getBehavior()).mouseReleased(mouseEvent, true);
                        mouseEvent.consume();
                    }
                });
            }
        } else if (this.getMode() == ComboBoxMode.SPLITBUTTON && this.arrowButton.getOnMouseReleased() == null) {
            this.arrowButton.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ((ColorPickerBehavior)ColorPickerSkin.this.getBehavior()).mouseReleased(mouseEvent, true);
                    mouseEvent.consume();
                }
            });
        }
        this.registerChangeListener(colorPicker.valueProperty(), "VALUE");
        this.displayNode = new Label();
        this.displayNode.getStyleClass().add("color-picker-label");
        if (this.getMode() == ComboBoxMode.BUTTON || this.getMode() == ComboBoxMode.COMBOBOX) {
            if (this.displayNode.getOnMouseReleased() == null) {
                this.displayNode.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                    @Override
                    public void handle(MouseEvent mouseEvent) {
                        ((ColorPickerBehavior)ColorPickerSkin.this.getBehavior()).mouseReleased(mouseEvent, true);
                    }
                });
            }
        } else if (this.displayNode.getOnMouseReleased() == null) {
            this.displayNode.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ((ColorPickerBehavior)ColorPickerSkin.this.getBehavior()).mouseReleased(mouseEvent, false);
                    mouseEvent.consume();
                }
            });
        }
        this.pickerColorBox = new PickerColorBox();
        this.pickerColorBox.getStyleClass().add("picker-color");
        this.colorRect = new Rectangle(12.0, 12.0);
        this.colorRect.getStyleClass().add("picker-color-rect");
        this.updateColor();
        colorPicker.addEventHandler(ActionEvent.ACTION, new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                ColorPickerSkin.this.updateColor();
            }
        });
        this.pickerColorBox.getChildren().add(this.colorRect);
        this.displayNode.setGraphic(this.pickerColorBox);
        if (this.displayNode.getOnMouseReleased() == null) {
            this.displayNode.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ((ColorPickerBehavior)ColorPickerSkin.this.getBehavior()).mouseReleased(mouseEvent, false);
                    mouseEvent.consume();
                }
            });
        }
    }

    private void updateComboBoxMode() {
        if (((ComboBoxBase)this.getSkinnable()).getStyleClass().contains("button")) {
            this.setMode(ComboBoxMode.BUTTON);
        } else if (((ComboBoxBase)this.getSkinnable()).getStyleClass().contains("split-button")) {
            this.setMode(ComboBoxMode.SPLITBUTTON);
        }
    }

    static String colorValueToWeb(Color color) {
        if (color == null) {
            return null;
        }
        String string = colorNameMap.get(color);
        if (string == null) {
            string = String.format((Locale)null, "%02x%02x%02x", Math.round(color.getRed() * 255.0), Math.round(color.getGreen() * 255.0), Math.round(color.getBlue() * 255.0));
        }
        return string;
    }

    @Override
    protected Node getPopupContent() {
        if (this.popupContent == null) {
            this.popupContent = new ColorPalette((Color)((ComboBoxBase)this.getSkinnable()).getValue(), (ColorPicker)this.getSkinnable());
            this.popupContent.setPopupControl(this.getPopup());
        }
        return this.popupContent;
    }

    @Override
    protected void focusLost() {
    }

    @Override
    public void show() {
        super.show();
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        this.popupContent.updateSelection((Color)colorPicker.getValue());
        this.popupContent.clearFocus();
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("SHOWING".equals(string)) {
            if (((ComboBoxBase)this.getSkinnable()).isShowing()) {
                this.show();
            } else if (!this.popupContent.isCustomColorDialogShowing()) {
                this.hide();
            }
        } else if ("VALUE".equals(string)) {
            this.updateColor();
            if (this.popupContent != null) {
                // empty if block
            }
        }
    }

    @Override
    public Node getDisplayNode() {
        return this.displayNode;
    }

    private void updateColor() {
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        this.colorRect.setFill((Paint)colorPicker.getValue());
        if (this.colorLabelVisible.get()) {
            this.displayNode.setText(ColorPickerSkin.colorValueToWeb((Color)colorPicker.getValue()));
        } else {
            this.displayNode.setText("");
        }
    }

    public void syncWithAutoUpdate() {
        if (!this.getPopup().isShowing() && ((ComboBoxBase)this.getSkinnable()).isShowing()) {
            ((ComboBoxBase)this.getSkinnable()).hide();
        }
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        this.updateComboBoxMode();
        super.layoutChildren(d, d2, d3, d4);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ColorPickerSkin.getClassCssMetaData();
    }

    static {
        colorNameMap.put(Color.TRANSPARENT, "Transparent");
        colorNameMap.put(Color.ALICEBLUE, "Alice Blue");
        colorNameMap.put(Color.ANTIQUEWHITE, "Antique White");
        colorNameMap.put(Color.AQUA, "Aqua");
        colorNameMap.put(Color.AQUAMARINE, "Aquamarine");
        colorNameMap.put(Color.AZURE, "Azure");
        colorNameMap.put(Color.BEIGE, "Beige");
        colorNameMap.put(Color.BISQUE, "Bisque");
        colorNameMap.put(Color.BLACK, "Black");
        colorNameMap.put(Color.BLANCHEDALMOND, "Blanched Almond");
        colorNameMap.put(Color.BLUE, "Blue");
        colorNameMap.put(Color.BLUEVIOLET, "Blue Violet");
        colorNameMap.put(Color.BROWN, "Brown");
        colorNameMap.put(Color.BURLYWOOD, "Burlywood");
        colorNameMap.put(Color.CADETBLUE, "Cadet Blue");
        colorNameMap.put(Color.CHARTREUSE, "Chartreuse");
        colorNameMap.put(Color.CHOCOLATE, "Chocolate");
        colorNameMap.put(Color.CORAL, "Coral");
        colorNameMap.put(Color.CORNFLOWERBLUE, "Cornflower Blue");
        colorNameMap.put(Color.CORNSILK, "Cornsilk");
        colorNameMap.put(Color.CRIMSON, "Crimson");
        colorNameMap.put(Color.CYAN, "Cyan");
        colorNameMap.put(Color.DARKBLUE, "Dark Blue");
        colorNameMap.put(Color.DARKCYAN, "Dark Cyan");
        colorNameMap.put(Color.DARKGOLDENROD, "Dark Goldenrod");
        colorNameMap.put(Color.DARKGRAY, "Dark Gray");
        colorNameMap.put(Color.DARKGREEN, "Dark Green");
        colorNameMap.put(Color.DARKGREY, "Dark Grey");
        colorNameMap.put(Color.DARKKHAKI, "Dark Khaki");
        colorNameMap.put(Color.DARKMAGENTA, "Dark Magenta");
        colorNameMap.put(Color.DARKOLIVEGREEN, "Dark Olive Green");
        colorNameMap.put(Color.DARKORANGE, "Dark Orange");
        colorNameMap.put(Color.DARKORCHID, "Dark Orchid");
        colorNameMap.put(Color.DARKRED, "Dark Red");
        colorNameMap.put(Color.DARKSALMON, "Dark Salmon");
        colorNameMap.put(Color.DARKSEAGREEN, "Dark Sea Green");
        colorNameMap.put(Color.DARKSLATEBLUE, "Dark Slate Blue");
        colorNameMap.put(Color.DARKSLATEGRAY, "Dark Slate Gray");
        colorNameMap.put(Color.DARKSLATEGREY, "Dark Slate Grey");
        colorNameMap.put(Color.DARKTURQUOISE, "Dark Turquoise");
        colorNameMap.put(Color.DARKVIOLET, "Dark Violet");
        colorNameMap.put(Color.DEEPPINK, "Deep Pink");
        colorNameMap.put(Color.DEEPSKYBLUE, "Deep Sky Blue");
        colorNameMap.put(Color.DIMGRAY, "Dim Gray");
        colorNameMap.put(Color.DIMGREY, "Dim Grey");
        colorNameMap.put(Color.DODGERBLUE, "Dodger Blue");
        colorNameMap.put(Color.FIREBRICK, "Firebrick");
        colorNameMap.put(Color.FLORALWHITE, "Floral White");
        colorNameMap.put(Color.FORESTGREEN, "Forest Green");
        colorNameMap.put(Color.FUCHSIA, "Fuchsia");
        colorNameMap.put(Color.GAINSBORO, "Gainsboro");
        colorNameMap.put(Color.GHOSTWHITE, "Ghost White");
        colorNameMap.put(Color.GOLD, "Gold");
        colorNameMap.put(Color.GOLDENROD, "Goldenrod");
        colorNameMap.put(Color.GRAY, "Gray");
        colorNameMap.put(Color.GREEN, "Green");
        colorNameMap.put(Color.GREENYELLOW, "Green Yellow");
        colorNameMap.put(Color.GREY, "Grey");
        colorNameMap.put(Color.HONEYDEW, "Honeydew");
        colorNameMap.put(Color.HOTPINK, "Hot Pink");
        colorNameMap.put(Color.INDIANRED, "Indian Red");
        colorNameMap.put(Color.INDIGO, "Indigo");
        colorNameMap.put(Color.IVORY, "Ivory");
        colorNameMap.put(Color.KHAKI, "Khaki");
        colorNameMap.put(Color.LAVENDER, "Lavender");
        colorNameMap.put(Color.LAVENDERBLUSH, "Lavender Blush");
        colorNameMap.put(Color.LAWNGREEN, "Lawn Green");
        colorNameMap.put(Color.LEMONCHIFFON, "Lemon Chiffon");
        colorNameMap.put(Color.LIGHTBLUE, "Light Blue");
        colorNameMap.put(Color.LIGHTCORAL, "Light Coral");
        colorNameMap.put(Color.LIGHTCYAN, "Light Cyan");
        colorNameMap.put(Color.LIGHTGOLDENRODYELLOW, "Light Goldenrod Yellow");
        colorNameMap.put(Color.LIGHTGRAY, "Light Gray");
        colorNameMap.put(Color.LIGHTGREEN, "Light Green");
        colorNameMap.put(Color.LIGHTGREY, "Light Grey");
        colorNameMap.put(Color.LIGHTPINK, "Light Pink");
        colorNameMap.put(Color.LIGHTSALMON, "Light Salmon");
        colorNameMap.put(Color.LIGHTSEAGREEN, "Light Sea Green");
        colorNameMap.put(Color.LIGHTSKYBLUE, "Light Sky Blue");
        colorNameMap.put(Color.LIGHTSLATEGRAY, "Light Slate Gray");
        colorNameMap.put(Color.LIGHTSLATEGREY, "Light Slate Grey");
        colorNameMap.put(Color.LIGHTSTEELBLUE, "Light Steel Blue");
        colorNameMap.put(Color.LIGHTYELLOW, "Light Yellow");
        colorNameMap.put(Color.LIME, "Lime");
        colorNameMap.put(Color.LIMEGREEN, "Lime Green");
        colorNameMap.put(Color.LINEN, "Linen");
        colorNameMap.put(Color.MAGENTA, "Magenta");
        colorNameMap.put(Color.MAROON, "Maroon");
        colorNameMap.put(Color.MEDIUMAQUAMARINE, "Medium Aquamarine");
        colorNameMap.put(Color.MEDIUMBLUE, "Medium Blue");
        colorNameMap.put(Color.MEDIUMORCHID, "Medium Orchid");
        colorNameMap.put(Color.MEDIUMPURPLE, "Medium Purple");
        colorNameMap.put(Color.MEDIUMSEAGREEN, "Medium Sea Green");
        colorNameMap.put(Color.MEDIUMSLATEBLUE, "Medium Slate Blue");
        colorNameMap.put(Color.MEDIUMSPRINGGREEN, "Medium Spring Green");
        colorNameMap.put(Color.MEDIUMTURQUOISE, "Medium Turquoise");
        colorNameMap.put(Color.MEDIUMVIOLETRED, "Medium Violet Red");
        colorNameMap.put(Color.MIDNIGHTBLUE, "Midnight Blue");
        colorNameMap.put(Color.MINTCREAM, "Mint Cream");
        colorNameMap.put(Color.MISTYROSE, "Misty Rose");
        colorNameMap.put(Color.MOCCASIN, "Moccasin");
        colorNameMap.put(Color.NAVAJOWHITE, "Navajo White");
        colorNameMap.put(Color.NAVY, "Navy");
        colorNameMap.put(Color.OLDLACE, "Old Lace");
        colorNameMap.put(Color.OLIVE, "Olive");
        colorNameMap.put(Color.OLIVEDRAB, "Olive Drab");
        colorNameMap.put(Color.ORANGE, "Orange");
        colorNameMap.put(Color.ORANGERED, "Orange Red");
        colorNameMap.put(Color.ORCHID, "Orchid");
        colorNameMap.put(Color.PALEGOLDENROD, "Pale Goldenrod");
        colorNameMap.put(Color.PALEGREEN, "Pale Green");
        colorNameMap.put(Color.PALETURQUOISE, "Pale Turquoise");
        colorNameMap.put(Color.PALEVIOLETRED, "Pale Violet Red");
        colorNameMap.put(Color.PAPAYAWHIP, "Papaya Whip");
        colorNameMap.put(Color.PEACHPUFF, "Peach Puff");
        colorNameMap.put(Color.PERU, "Peru");
        colorNameMap.put(Color.PINK, "Pink");
        colorNameMap.put(Color.PLUM, "Plum");
        colorNameMap.put(Color.POWDERBLUE, "Powder Blue");
        colorNameMap.put(Color.PURPLE, "Purple");
        colorNameMap.put(Color.RED, "Red");
        colorNameMap.put(Color.ROSYBROWN, "Rosy Brown");
        colorNameMap.put(Color.ROYALBLUE, "Royal Blue");
        colorNameMap.put(Color.SADDLEBROWN, "Saddle Brown");
        colorNameMap.put(Color.SALMON, "Salmon");
        colorNameMap.put(Color.SANDYBROWN, "Sandy Brown");
        colorNameMap.put(Color.SEAGREEN, "Sea Green");
        colorNameMap.put(Color.SEASHELL, "Seashell");
        colorNameMap.put(Color.SIENNA, "Sienna");
        colorNameMap.put(Color.SILVER, "Silver");
        colorNameMap.put(Color.SKYBLUE, "Sky Blue");
        colorNameMap.put(Color.SLATEBLUE, "Slate Blue");
        colorNameMap.put(Color.SLATEGRAY, "Slate Gray");
        colorNameMap.put(Color.SLATEGREY, "Slate Grey");
        colorNameMap.put(Color.SNOW, "Snow");
        colorNameMap.put(Color.SPRINGGREEN, "Spring Green");
        colorNameMap.put(Color.STEELBLUE, "Steel Blue");
        colorNameMap.put(Color.TAN, "Tan");
        colorNameMap.put(Color.TEAL, "Teal");
        colorNameMap.put(Color.THISTLE, "Thistle");
        colorNameMap.put(Color.TOMATO, "Tomato");
        colorNameMap.put(Color.TURQUOISE, "Turquoise");
        colorNameMap.put(Color.VIOLET, "Violet");
        colorNameMap.put(Color.WHEAT, "Wheat");
        colorNameMap.put(Color.WHITE, "White");
        colorNameMap.put(Color.WHITESMOKE, "White Smoke");
        colorNameMap.put(Color.YELLOW, "Yellow");
        colorNameMap.put(Color.YELLOWGREEN, "Yellow Green");
    }

    private static class StyleableProperties {
        private static final CssMetaData<ColorPicker, Boolean> COLOR_LABEL_VISIBLE = new CssMetaData<ColorPicker, Boolean>("-fx-color-label-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(ColorPicker colorPicker) {
                ColorPickerSkin colorPickerSkin = (ColorPickerSkin)colorPicker.getSkin();
                return colorPickerSkin.colorLabelVisible == null || !colorPickerSkin.colorLabelVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(ColorPicker colorPicker) {
                ColorPickerSkin colorPickerSkin = (ColorPickerSkin)colorPicker.getSkin();
                return (StyleableProperty)((Object)colorPickerSkin.colorLabelVisible);
            }
        };
        private static final CssMetaData<ColorPicker, Number> COLOR_RECT_WIDTH = new CssMetaData<ColorPicker, Number>("-fx-color-rect-width", SizeConverter.getInstance(), (Number)12.0){

            @Override
            public boolean isSettable(ColorPicker colorPicker) {
                ColorPickerSkin colorPickerSkin = (ColorPickerSkin)colorPicker.getSkin();
                return !colorPickerSkin.colorRectWidth.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ColorPicker colorPicker) {
                ColorPickerSkin colorPickerSkin = (ColorPickerSkin)colorPicker.getSkin();
                return colorPickerSkin.colorRectWidth;
            }
        };
        private static final CssMetaData<ColorPicker, Number> COLOR_RECT_HEIGHT = new CssMetaData<ColorPicker, Number>("-fx-color-rect-height", SizeConverter.getInstance(), (Number)12.0){

            @Override
            public boolean isSettable(ColorPicker colorPicker) {
                ColorPickerSkin colorPickerSkin = (ColorPickerSkin)colorPicker.getSkin();
                return !colorPickerSkin.colorRectHeight.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ColorPicker colorPicker) {
                ColorPickerSkin colorPickerSkin = (ColorPickerSkin)colorPicker.getSkin();
                return colorPickerSkin.colorRectHeight;
            }
        };
        private static final CssMetaData<ColorPicker, Number> COLOR_RECT_X = new CssMetaData<ColorPicker, Number>("-fx-color-rect-x", SizeConverter.getInstance(), (Number)0){

            @Override
            public boolean isSettable(ColorPicker colorPicker) {
                ColorPickerSkin colorPickerSkin = (ColorPickerSkin)colorPicker.getSkin();
                return !colorPickerSkin.colorRectX.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ColorPicker colorPicker) {
                ColorPickerSkin colorPickerSkin = (ColorPickerSkin)colorPicker.getSkin();
                return colorPickerSkin.colorRectX;
            }
        };
        private static final CssMetaData<ColorPicker, Number> COLOR_RECT_Y = new CssMetaData<ColorPicker, Number>("-fx-color-rect-y", SizeConverter.getInstance(), (Number)0){

            @Override
            public boolean isSettable(ColorPicker colorPicker) {
                ColorPickerSkin colorPickerSkin = (ColorPickerSkin)colorPicker.getSkin();
                return !colorPickerSkin.colorRectY.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ColorPicker colorPicker) {
                ColorPickerSkin colorPickerSkin = (ColorPickerSkin)colorPicker.getSkin();
                return colorPickerSkin.colorRectY;
            }
        };
        private static final CssMetaData<ColorPicker, String> GRAPHIC = new CssMetaData<ColorPicker, String>("-fx-graphic", StringConverter.getInstance()){

            @Override
            public boolean isSettable(ColorPicker colorPicker) {
                ColorPickerSkin colorPickerSkin = (ColorPickerSkin)colorPicker.getSkin();
                return !colorPickerSkin.imageUrl.isBound();
            }

            @Override
            public StyleableProperty<String> getStyleableProperty(ColorPicker colorPicker) {
                ColorPickerSkin colorPickerSkin = (ColorPickerSkin)colorPicker.getSkin();
                return colorPickerSkin.imageUrl;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(ComboBoxBaseSkin.getClassCssMetaData());
            arrayList.add(COLOR_LABEL_VISIBLE);
            arrayList.add(COLOR_RECT_WIDTH);
            arrayList.add(COLOR_RECT_HEIGHT);
            arrayList.add(COLOR_RECT_X);
            arrayList.add(COLOR_RECT_Y);
            arrayList.add(GRAPHIC);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    private class PickerColorBox
    extends StackPane {
        private PickerColorBox() {
        }

        @Override
        protected void layoutChildren() {
            double d = this.snappedTopInset();
            double d2 = this.snappedLeftInset();
            double d3 = this.getWidth();
            double d4 = this.getHeight();
            double d5 = this.snappedRightInset();
            double d6 = this.snappedBottomInset();
            ColorPickerSkin.this.colorRect.setX(this.snapPosition(ColorPickerSkin.this.colorRectX.get()));
            ColorPickerSkin.this.colorRect.setY(this.snapPosition(ColorPickerSkin.this.colorRectY.get()));
            ColorPickerSkin.this.colorRect.setWidth(this.snapSize(ColorPickerSkin.this.colorRectWidth.get()));
            ColorPickerSkin.this.colorRect.setHeight(this.snapSize(ColorPickerSkin.this.colorRectHeight.get()));
            if (this.getChildren().size() == 2) {
                ImageView imageView = (ImageView)this.getChildren().get(1);
                Pos pos = StackPane.getAlignment(imageView);
                this.layoutInArea(imageView, d2, d, d3 - d2 - d5, d4 - d - d6, 0.0, PickerColorBox.getMargin(imageView), pos != null ? pos.getHpos() : this.getAlignment().getHpos(), pos != null ? pos.getVpos() : this.getAlignment().getVpos());
                ColorPickerSkin.this.colorRect.setLayoutX(imageView.getLayoutX());
                ColorPickerSkin.this.colorRect.setLayoutY(imageView.getLayoutY());
            } else {
                Pos pos = StackPane.getAlignment(ColorPickerSkin.this.colorRect);
                this.layoutInArea(ColorPickerSkin.this.colorRect, d2, d, d3 - d2 - d5, d4 - d - d6, 0.0, PickerColorBox.getMargin(ColorPickerSkin.this.colorRect), pos != null ? pos.getHpos() : this.getAlignment().getHpos(), pos != null ? pos.getVpos() : this.getAlignment().getVpos());
            }
        }
    }
}

