/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.behavior.ProgressBarBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javafx.util.Duration;

public class ProgressBarSkin
extends BehaviorSkinBase<ProgressBar, ProgressBarBehavior<ProgressBar>> {
    private Bar bar;
    private StackPane track;
    private Region clipRegion;
    private double barWidth;
    private DoubleProperty indeterminateBarLength = null;
    private BooleanProperty indeterminateBarEscape = null;
    private BooleanProperty indeterminateBarFlip = null;
    private DoubleProperty indeterminateBarAnimationTime = null;
    private Timeline indeterminateTimeline;
    private boolean timelineNulled = false;
    private static final Duration CLIPPED_DELAY = new Duration(300.0);
    private static final Duration UNCLIPPED_DELAY = new Duration(0.0);

    private DoubleProperty indeterminateBarLengthProperty() {
        if (this.indeterminateBarLength == null) {
            this.indeterminateBarLength = new StyleableDoubleProperty(60.0){

                @Override
                public Object getBean() {
                    return ProgressBarSkin.this;
                }

                @Override
                public String getName() {
                    return "indeterminateBarLength";
                }

                @Override
                public CssMetaData<ProgressBar, Number> getCssMetaData() {
                    return StyleableProperties.INDETERMINATE_BAR_LENGTH;
                }
            };
        }
        return this.indeterminateBarLength;
    }

    private Double getIndeterminateBarLength() {
        return this.indeterminateBarLength == null ? 60.0 : this.indeterminateBarLength.get();
    }

    private BooleanProperty indeterminateBarEscapeProperty() {
        if (this.indeterminateBarEscape == null) {
            this.indeterminateBarEscape = new StyleableBooleanProperty(true){

                @Override
                public Object getBean() {
                    return ProgressBarSkin.this;
                }

                @Override
                public String getName() {
                    return "indeterminateBarEscape";
                }

                @Override
                public CssMetaData<ProgressBar, Boolean> getCssMetaData() {
                    return StyleableProperties.INDETERMINATE_BAR_ESCAPE;
                }
            };
        }
        return this.indeterminateBarEscape;
    }

    private Boolean getIndeterminateBarEscape() {
        return this.indeterminateBarEscape == null ? true : this.indeterminateBarEscape.get();
    }

    private BooleanProperty indeterminateBarFlipProperty() {
        if (this.indeterminateBarFlip == null) {
            this.indeterminateBarFlip = new StyleableBooleanProperty(true){

                @Override
                public Object getBean() {
                    return ProgressBarSkin.this;
                }

                @Override
                public String getName() {
                    return "indeterminateBarFlip";
                }

                @Override
                public CssMetaData<ProgressBar, Boolean> getCssMetaData() {
                    return StyleableProperties.INDETERMINATE_BAR_FLIP;
                }
            };
        }
        return this.indeterminateBarFlip;
    }

    private Boolean getIndeterminateBarFlip() {
        return this.indeterminateBarFlip == null ? true : this.indeterminateBarFlip.get();
    }

    private DoubleProperty indeterminateBarAnimationTimeProperty() {
        if (this.indeterminateBarAnimationTime == null) {
            this.indeterminateBarAnimationTime = new StyleableDoubleProperty(2.0){

                @Override
                public Object getBean() {
                    return ProgressBarSkin.this;
                }

                @Override
                public String getName() {
                    return "indeterminateBarAnimationTime";
                }

                @Override
                public CssMetaData<ProgressBar, Number> getCssMetaData() {
                    return StyleableProperties.INDETERMINATE_BAR_ANIMATION_TIME;
                }
            };
        }
        return this.indeterminateBarAnimationTime;
    }

    private Double getIndeterminateBarAnimationTime() {
        return this.indeterminateBarAnimationTime == null ? 2.0 : this.indeterminateBarAnimationTime.get();
    }

    public ProgressBarSkin(ProgressBar progressBar) {
        super(progressBar, new ProgressBarBehavior<ProgressBar>(progressBar));
        InvalidationListener invalidationListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                ProgressBarSkin.this.initialize();
            }
        };
        progressBar.indeterminateProperty().addListener(invalidationListener);
        InvalidationListener invalidationListener2 = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (((ProgressBar)ProgressBarSkin.this.getSkinnable()).isIndeterminate() && ProgressBarSkin.this.timelineNulled && ProgressBarSkin.this.indeterminateTimeline == null) {
                    ProgressBarSkin.this.timelineNulled = false;
                    ProgressBarSkin.this.createIndeterminateTimeline();
                }
                if (ProgressBarSkin.this.indeterminateTimeline != null) {
                    if (((ProgressBar)ProgressBarSkin.this.getSkinnable()).impl_isTreeVisible() && ((ProgressBar)ProgressBarSkin.this.getSkinnable()).getScene() != null) {
                        ProgressBarSkin.this.indeterminateTimeline.play();
                    } else {
                        ProgressBarSkin.this.indeterminateTimeline.pause();
                        ProgressBarSkin.this.indeterminateTimeline = null;
                        ProgressBarSkin.this.timelineNulled = true;
                    }
                }
            }
        };
        progressBar.visibleProperty().addListener(invalidationListener2);
        progressBar.parentProperty().addListener(invalidationListener2);
        InvalidationListener invalidationListener3 = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (ProgressBarSkin.this.indeterminateTimeline != null) {
                    if (((ProgressBar)ProgressBarSkin.this.getSkinnable()).getScene() == null) {
                        ProgressBarSkin.this.indeterminateTimeline.pause();
                        ProgressBarSkin.this.indeterminateTimeline = null;
                        ProgressBarSkin.this.timelineNulled = true;
                    }
                } else if (((ProgressBar)ProgressBarSkin.this.getSkinnable()).getScene() != null && ((ProgressBar)ProgressBarSkin.this.getSkinnable()).isIndeterminate()) {
                    ProgressBarSkin.this.timelineNulled = false;
                    ProgressBarSkin.this.createIndeterminateTimeline();
                    if (((ProgressBar)ProgressBarSkin.this.getSkinnable()).impl_isTreeVisible()) {
                        ProgressBarSkin.this.indeterminateTimeline.play();
                    }
                    ((ProgressBar)ProgressBarSkin.this.getSkinnable()).requestLayout();
                }
            }
        };
        progressBar.sceneProperty().addListener(invalidationListener3);
        this.barWidth = (double)((int)(progressBar.getWidth() - this.snappedLeftInset() - this.snappedRightInset()) * 2) * Math.min(1.0, Math.max(0.0, progressBar.getProgress())) / 2.0;
        InvalidationListener invalidationListener4 = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                ProgressBarSkin.this.updateProgress();
            }
        };
        progressBar.widthProperty().addListener(invalidationListener4);
        progressBar.progressProperty().addListener(invalidationListener4);
        this.initialize();
        ((ProgressBar)this.getSkinnable()).requestLayout();
    }

    private void initialize() {
        ProgressBar progressBar = (ProgressBar)this.getSkinnable();
        this.track = new StackPane();
        this.track.getStyleClass().setAll((String[])new String[]{"track"});
        this.bar = new Bar(this);
        this.bar.getStyleClass().setAll((String[])new String[]{"bar"});
        this.getChildren().setAll((Node[])new Node[]{this.track, this.bar});
        this.clipRegion = new Region();
        this.bar.backgroundProperty().addListener(new ChangeListener<Background>(){

            @Override
            public void changed(ObservableValue<? extends Background> observableValue, Background background, Background background2) {
                if (background2 != null && !background2.getFills().isEmpty()) {
                    BackgroundFill[] backgroundFillArray = new BackgroundFill[background2.getFills().size()];
                    for (int i = 0; i < background2.getFills().size(); ++i) {
                        BackgroundFill backgroundFill = background2.getFills().get(i);
                        backgroundFillArray[i] = new BackgroundFill(Color.BLACK, backgroundFill.getRadii(), backgroundFill.getInsets());
                    }
                    ProgressBarSkin.this.clipRegion.setBackground(new Background(backgroundFillArray));
                }
            }
        });
    }

    void pauseBar(boolean bl) {
        if (this.indeterminateTimeline != null) {
            if (bl) {
                this.indeterminateTimeline.pause();
            } else {
                this.indeterminateTimeline.play();
            }
        }
    }

    private boolean isVisibleInClip() {
        Object object;
        Bounds bounds = ((Node)object).localToScene(((ProgressBar)this.getSkinnable()).getLayoutBounds());
        for (object = this.getSkinnable(); object != null; object = ((Node)object).getParent()) {
            Bounds bounds2;
            Node node = ((Node)object).getClip();
            if (node == null || bounds.intersects(bounds2 = ((Node)object).localToScene(node.getLayoutBounds()))) continue;
            return false;
        }
        return true;
    }

    private boolean isInvisibleOrDisconnected() {
        Scene scene = ((ProgressBar)this.getSkinnable()).getScene();
        if (scene == null) {
            return true;
        }
        Window window = scene.getWindow();
        if (window == null) {
            return true;
        }
        if (window.impl_getPeer() == null) {
            return true;
        }
        return !((ProgressBar)this.getSkinnable()).impl_isTreeVisible();
    }

    private boolean stopIfInvisibleOrDisconnected() {
        if (this.isInvisibleOrDisconnected()) {
            if (this.indeterminateTimeline != null) {
                this.indeterminateTimeline.stop();
                this.indeterminateTimeline = null;
            }
            return true;
        }
        return false;
    }

    private void createIndeterminateTimeline() {
        if (this.indeterminateTimeline != null) {
            this.indeterminateTimeline.stop();
        }
        ProgressBar progressBar = (ProgressBar)this.getSkinnable();
        double d = progressBar.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        double d2 = this.getIndeterminateBarEscape() != false ? -this.getIndeterminateBarLength().doubleValue() : 0.0;
        double d3 = this.getIndeterminateBarEscape() != false ? d : d - this.getIndeterminateBarLength();
        this.indeterminateTimeline = new Timeline();
        this.indeterminateTimeline.setCycleCount(-1);
        this.indeterminateTimeline.setDelay(UNCLIPPED_DELAY);
        if (this.getIndeterminateBarFlip().booleanValue()) {
            this.indeterminateTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.millis(0.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    ProgressBarSkin.this.bar.setScaleX(-1.0);
                    if (ProgressBarSkin.this.indeterminateTimeline != null) {
                        ProgressBarSkin.this.stopIfInvisibleOrDisconnected();
                        if (!ProgressBarSkin.this.isVisibleInClip()) {
                            Platform.runLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (ProgressBarSkin.this.indeterminateTimeline != null) {
                                        if (ProgressBarSkin.this.indeterminateTimeline.getDelay().compareTo(CLIPPED_DELAY) != 0) {
                                            ProgressBarSkin.this.indeterminateTimeline.setDelay(CLIPPED_DELAY);
                                        }
                                        ProgressBarSkin.this.indeterminateTimeline.stop();
                                        ProgressBarSkin.this.indeterminateTimeline.jumpTo(Duration.ZERO);
                                        ProgressBarSkin.this.indeterminateTimeline.play();
                                    }
                                }
                            });
                        } else {
                            Platform.runLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (ProgressBarSkin.this.indeterminateTimeline != null && ProgressBarSkin.this.indeterminateTimeline.getDelay().compareTo(UNCLIPPED_DELAY) != 0) {
                                        ProgressBarSkin.this.indeterminateTimeline.setDelay(UNCLIPPED_DELAY);
                                    }
                                }
                            });
                        }
                    }
                }
            }, new KeyValue(this.clipRegion.translateXProperty(), d2 - (d - this.getIndeterminateBarLength())), new KeyValue(this.bar.translateXProperty(), d2)), new KeyFrame(Duration.millis(this.getIndeterminateBarAnimationTime() * 1000.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    ProgressBarSkin.this.bar.setScaleX(1.0);
                }
            }, new KeyValue(this.clipRegion.translateXProperty(), d3 - (d - this.getIndeterminateBarLength())), new KeyValue(this.bar.translateXProperty(), d3)), new KeyFrame(Duration.millis(this.getIndeterminateBarAnimationTime() * 1000.0 + 1.0), new KeyValue(this.clipRegion.translateXProperty(), -d3)), new KeyFrame(Duration.millis(this.getIndeterminateBarAnimationTime() * 2000.0), new KeyValue(this.clipRegion.translateXProperty(), -d2), new KeyValue(this.bar.translateXProperty(), d2))});
        } else {
            this.indeterminateTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.millis(0.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    if (ProgressBarSkin.this.indeterminateTimeline != null) {
                        ProgressBarSkin.this.stopIfInvisibleOrDisconnected();
                        if (!ProgressBarSkin.this.isVisibleInClip()) {
                            Platform.runLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (ProgressBarSkin.this.indeterminateTimeline != null) {
                                        if (ProgressBarSkin.this.indeterminateTimeline.getDelay().compareTo(CLIPPED_DELAY) != 0) {
                                            ProgressBarSkin.this.indeterminateTimeline.setDelay(CLIPPED_DELAY);
                                        }
                                        ProgressBarSkin.this.indeterminateTimeline.stop();
                                        ProgressBarSkin.this.indeterminateTimeline.jumpTo(Duration.ZERO);
                                        ProgressBarSkin.this.indeterminateTimeline.play();
                                    }
                                }
                            });
                        } else {
                            Platform.runLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (ProgressBarSkin.this.indeterminateTimeline != null && ProgressBarSkin.this.indeterminateTimeline.getDelay().compareTo(UNCLIPPED_DELAY) != 0) {
                                        ProgressBarSkin.this.indeterminateTimeline.setDelay(UNCLIPPED_DELAY);
                                    }
                                }
                            });
                        }
                    }
                }
            }, new KeyValue(this.clipRegion.translateXProperty(), d2 - (d - this.getIndeterminateBarLength())), new KeyValue(this.bar.translateXProperty(), d2)), new KeyFrame(Duration.millis(this.getIndeterminateBarAnimationTime() * 1000.0 * 2.0), new KeyValue(this.clipRegion.translateXProperty(), d3 - (d - this.getIndeterminateBarLength())), new KeyValue(this.bar.translateXProperty(), d3))});
        }
    }

    private void updateProgress() {
        ProgressBar progressBar = (ProgressBar)this.getSkinnable();
        this.barWidth = (double)((int)(progressBar.getWidth() - this.snappedLeftInset() - this.snappedRightInset()) * 2) * Math.min(1.0, Math.max(0.0, progressBar.getProgress())) / 2.0;
        ((ProgressBar)this.getSkinnable()).requestLayout();
    }

    @Override
    public double computeBaselineOffset(double d, double d2, double d3, double d4) {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.indeterminateTimeline != null) {
            this.indeterminateTimeline.stop();
            this.indeterminateTimeline.getKeyFrames().clear();
            this.indeterminateTimeline = null;
        }
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        return Math.max(100.0, d5 + this.bar.prefWidth(((ProgressBar)this.getSkinnable()).getWidth()) + d3);
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        return d2 + this.bar.prefHeight(d) + d4;
    }

    @Override
    protected double computeMaxWidth(double d, double d2, double d3, double d4, double d5) {
        return ((ProgressBar)this.getSkinnable()).prefWidth(d);
    }

    @Override
    protected double computeMaxHeight(double d, double d2, double d3, double d4, double d5) {
        return ((ProgressBar)this.getSkinnable()).prefHeight(d);
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        ProgressBar progressBar = (ProgressBar)this.getSkinnable();
        boolean bl = progressBar.isIndeterminate();
        this.clipRegion.resizeRelocate(0.0, 0.0, d3, d4);
        this.track.resizeRelocate(d, d2, d3, d4);
        this.bar.resizeRelocate(d, d2, bl ? this.getIndeterminateBarLength() : this.barWidth, d4);
        this.track.setVisible(true);
        if (bl) {
            this.createIndeterminateTimeline();
            if (((ProgressBar)this.getSkinnable()).impl_isTreeVisible()) {
                this.indeterminateTimeline.play();
            }
            if (this.getIndeterminateBarFlip().booleanValue()) {
                this.bar.setClip(this.clipRegion);
            } else {
                this.bar.setClip(null);
            }
        } else if (this.indeterminateTimeline != null) {
            this.indeterminateTimeline.stop();
            this.indeterminateTimeline = null;
            this.bar.setClip(null);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ProgressBarSkin.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<ProgressBar, Number> INDETERMINATE_BAR_LENGTH = new CssMetaData<ProgressBar, Number>("-fx-indeterminate-bar-length", SizeConverter.getInstance(), (Number)60.0){

            @Override
            public boolean isSettable(ProgressBar progressBar) {
                ProgressBarSkin progressBarSkin = (ProgressBarSkin)progressBar.getSkin();
                return progressBarSkin.indeterminateBarLength == null || !progressBarSkin.indeterminateBarLength.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ProgressBar progressBar) {
                ProgressBarSkin progressBarSkin = (ProgressBarSkin)progressBar.getSkin();
                return (StyleableProperty)((Object)progressBarSkin.indeterminateBarLengthProperty());
            }
        };
        private static final CssMetaData<ProgressBar, Boolean> INDETERMINATE_BAR_ESCAPE = new CssMetaData<ProgressBar, Boolean>("-fx-indeterminate-bar-escape", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(ProgressBar progressBar) {
                ProgressBarSkin progressBarSkin = (ProgressBarSkin)progressBar.getSkin();
                return progressBarSkin.indeterminateBarEscape == null || !progressBarSkin.indeterminateBarEscape.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(ProgressBar progressBar) {
                ProgressBarSkin progressBarSkin = (ProgressBarSkin)progressBar.getSkin();
                return (StyleableProperty)((Object)progressBarSkin.indeterminateBarEscapeProperty());
            }
        };
        private static final CssMetaData<ProgressBar, Boolean> INDETERMINATE_BAR_FLIP = new CssMetaData<ProgressBar, Boolean>("-fx-indeterminate-bar-flip", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(ProgressBar progressBar) {
                ProgressBarSkin progressBarSkin = (ProgressBarSkin)progressBar.getSkin();
                return progressBarSkin.indeterminateBarFlip == null || !progressBarSkin.indeterminateBarFlip.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(ProgressBar progressBar) {
                ProgressBarSkin progressBarSkin = (ProgressBarSkin)progressBar.getSkin();
                return (StyleableProperty)((Object)progressBarSkin.indeterminateBarFlipProperty());
            }
        };
        private static final CssMetaData<ProgressBar, Number> INDETERMINATE_BAR_ANIMATION_TIME = new CssMetaData<ProgressBar, Number>("-fx-indeterminate-bar-animation-time", SizeConverter.getInstance(), (Number)2.0){

            @Override
            public boolean isSettable(ProgressBar progressBar) {
                ProgressBarSkin progressBarSkin = (ProgressBarSkin)progressBar.getSkin();
                return progressBarSkin.indeterminateBarAnimationTime == null || !progressBarSkin.indeterminateBarAnimationTime.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ProgressBar progressBar) {
                ProgressBarSkin progressBarSkin = (ProgressBarSkin)progressBar.getSkin();
                return (StyleableProperty)((Object)progressBarSkin.indeterminateBarAnimationTimeProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(SkinBase.getClassCssMetaData());
            arrayList.add(INDETERMINATE_BAR_LENGTH);
            arrayList.add(INDETERMINATE_BAR_ESCAPE);
            arrayList.add(INDETERMINATE_BAR_FLIP);
            arrayList.add(INDETERMINATE_BAR_ANIMATION_TIME);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    class Bar
    extends StackPane {
        ProgressBarSkin pbSkin;

        Bar(ProgressBarSkin progressBarSkin2) {
            this.pbSkin = progressBarSkin2;
            InvalidationListener invalidationListener = new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    if (((ProgressBar)ProgressBarSkin.this.getSkinnable()).impl_isTreeVisible()) {
                        Bar.this.pbSkin.pauseBar(false);
                    } else {
                        Bar.this.pbSkin.pauseBar(true);
                    }
                }
            };
            this.impl_treeVisibleProperty().addListener(invalidationListener);
        }
    }
}

