/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.animation.FadeTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import javafx.util.Duration;

public abstract class TableRowSkinBase<T, C extends IndexedCell, B extends CellBehaviorBase<C>, R extends IndexedCell>
extends CellSkinBase<C, B> {
    private static boolean IS_STUB_TOOLKIT = Toolkit.getToolkit().toString().contains("StubToolkit");
    private static boolean DO_ANIMATIONS = !IS_STUB_TOOLKIT && !PlatformUtil.isEmbedded();
    private static final Duration FADE_DURATION = Duration.millis(200.0);
    static final Map<Control, Double> maxDisclosureWidthMap = new WeakHashMap<Control, Double>();
    private static final int DEFAULT_FULL_REFRESH_COUNTER = 100;
    protected WeakHashMap<TableColumnBase, R> cellsMap;
    protected final List<R> cells = new ArrayList<R>();
    private int fullRefreshCounter = 100;
    protected boolean isDirty = false;
    protected boolean updateCells = false;
    private double fixedCellSize;
    private boolean fixedCellSizeEnabled;
    private int columnCount = 0;
    private ListChangeListener<TableColumnBase> visibleLeafColumnsListener = new ListChangeListener<TableColumnBase>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumnBase> change) {
            TableRowSkinBase.this.isDirty = true;
            ((IndexedCell)TableRowSkinBase.this.getSkinnable()).requestLayout();
        }
    };
    private WeakListChangeListener<TableColumnBase> weakVisibleLeafColumnsListener = new WeakListChangeListener<TableColumnBase>(this.visibleLeafColumnsListener);

    public TableRowSkinBase(C c, B b) {
        super(c, b);
    }

    protected void init(C c) {
        ((IndexedCell)this.getSkinnable()).setPickOnBounds(false);
        this.recreateCells();
        this.updateCells(true);
        this.getVisibleLeafColumns().addListener(this.weakVisibleLeafColumnsListener);
        this.registerChangeListener(((Cell)c).itemProperty(), "ITEM");
        if (this.fixedCellSizeProperty() != null) {
            this.registerChangeListener(this.fixedCellSizeProperty(), "FIXED_CELL_SIZE");
            this.fixedCellSize = this.fixedCellSizeProperty().get();
            this.fixedCellSizeEnabled = this.fixedCellSize > 0.0;
        }
    }

    protected abstract ObjectProperty<Node> graphicProperty();

    protected abstract Control getVirtualFlowOwner();

    protected abstract ObservableList<? extends TableColumnBase> getVisibleLeafColumns();

    protected abstract void updateCell(R var1, C var2);

    protected abstract DoubleProperty fixedCellSizeProperty();

    protected abstract boolean isColumnPartiallyOrFullyVisible(TableColumnBase var1);

    protected abstract R getCell(TableColumnBase var1);

    protected abstract TableColumnBase<T, ?> getTableColumnBase(R var1);

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("ITEM".equals(string)) {
            this.updateCells = true;
            ((IndexedCell)this.getSkinnable()).requestLayout();
            int n = ((IndexedCell)this.getSkinnable()).getIndex();
            int n2 = this.cells.size();
            for (int i = 0; i < n2; ++i) {
                ((IndexedCell)this.cells.get(i)).updateIndex(n);
            }
        } else if ("FIXED_CELL_SIZE".equals(string)) {
            this.fixedCellSize = this.fixedCellSizeProperty().get();
            this.fixedCellSizeEnabled = this.fixedCellSize > 0.0;
        }
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        double d5;
        this.checkState(true);
        if (this.cellsMap.isEmpty()) {
            return;
        }
        ObservableList<TableColumnBase> observableList = this.getVisibleLeafColumns();
        if (observableList.isEmpty()) {
            super.layoutChildren(d, d2, d3, d4);
            return;
        }
        IndexedCell indexedCell = (IndexedCell)this.getSkinnable();
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        boolean bl = this.isIndentationRequired();
        boolean bl2 = this.isDisclosureNodeVisible();
        int n = 0;
        Node node = null;
        if (bl) {
            double d9;
            TableColumnBase tableColumnBase = this.getTreeColumn();
            n = tableColumnBase == null ? 0 : observableList.indexOf(tableColumnBase);
            n = n < 0 ? 0 : n;
            int n2 = this.getIndentationLevel(indexedCell);
            if (!this.isShowRoot()) {
                --n2;
            }
            d5 = this.getIndentationPerLevel();
            d6 = (double)n2 * d5;
            Control control = this.getVirtualFlowOwner();
            d7 = d9 = maxDisclosureWidthMap.containsKey(control) ? maxDisclosureWidthMap.get(control) : 0.0;
            node = this.getDisclosureNode();
            if (node != null) {
                node.setVisible(bl2);
                if (bl2 && (d7 = node.prefWidth(d4)) > d9) {
                    maxDisclosureWidthMap.put(control, d7);
                }
            }
        }
        double d10 = this.snappedTopInset() + this.snappedBottomInset();
        double d11 = this.snappedLeftInset() + this.snappedRightInset();
        double d12 = indexedCell.getHeight();
        int n3 = indexedCell.getIndex();
        if (n3 < 0) {
            return;
        }
        int n4 = this.cells.size();
        for (int i = 0; i < n4; ++i) {
            IndexedCell indexedCell2 = (IndexedCell)this.cells.get(i);
            TableColumnBase<T, ?> tableColumnBase = this.getTableColumnBase(indexedCell2);
            double d13 = this.snapSize(indexedCell2.prefWidth(-1.0)) - this.snapSize(d11);
            boolean bl3 = true;
            if (this.fixedCellSizeEnabled) {
                bl3 = this.isColumnPartiallyOrFullyVisible(tableColumnBase);
                d5 = this.fixedCellSize;
            } else {
                d5 = Math.max(d12, indexedCell2.prefHeight(-1.0));
                d5 = this.snapSize(d5) - this.snapSize(d10);
            }
            if (bl3) {
                boolean bl4;
                if (this.fixedCellSizeEnabled && indexedCell2.getParent() == null) {
                    this.getChildren().add(indexedCell2);
                }
                boolean bl5 = bl4 = d4 <= 24.0;
                if (!bl4 && indexedCell2.getAlignment() == Pos.CENTER_LEFT) {
                    indexedCell2.setAlignment(Pos.TOP_LEFT);
                }
                if (bl && i == n) {
                    ObjectProperty<Node> objectProperty;
                    Node node2;
                    if (bl2) {
                        double d14 = node.prefHeight(d7);
                        if (d13 < d7 + d6) {
                            this.fadeOut(node);
                        } else {
                            this.fadeIn(node);
                            node.resize(d7, d14);
                            node.relocate(d + d6, bl4 ? d4 / 2.0 - d14 / 2.0 : d2 + indexedCell2.getPadding().getTop());
                            node.toFront();
                        }
                    }
                    Node node3 = node2 = (objectProperty = this.graphicProperty()) == null ? null : (Node)objectProperty.get();
                    if (node2 != null) {
                        d8 = node2.prefWidth(-1.0) + 3.0;
                        double d15 = node2.prefHeight(d8);
                        if (d13 < d7 + d6 + d8) {
                            this.fadeOut(node2);
                        } else {
                            this.fadeIn(node2);
                            node2.relocate(d + d6 + d7, bl4 ? d4 / 2.0 - d15 / 2.0 : d2 + indexedCell2.getPadding().getTop());
                            node2.toFront();
                        }
                    }
                }
                indexedCell2.resize(d13, d5);
                indexedCell2.relocate(d, this.snappedTopInset());
                indexedCell2.requestLayout();
            } else if (this.fixedCellSizeEnabled) {
                this.getChildren().remove(indexedCell2);
            }
            d += d13;
        }
    }

    protected int getIndentationLevel(C c) {
        return 0;
    }

    protected double getIndentationPerLevel() {
        return 0.0;
    }

    protected boolean isIndentationRequired() {
        return false;
    }

    protected TableColumnBase getTreeColumn() {
        return null;
    }

    protected Node getDisclosureNode() {
        return null;
    }

    protected boolean isDisclosureNodeVisible() {
        return false;
    }

    protected boolean isShowRoot() {
        return true;
    }

    protected TableColumnBase<T, ?> getVisibleLeafColumn(int n) {
        ObservableList<TableColumnBase> observableList = this.getVisibleLeafColumns();
        if (n < 0 || n >= observableList.size()) {
            return null;
        }
        return (TableColumnBase)observableList.get(n);
    }

    protected void updateCells(boolean bl) {
        boolean bl2 = this.cells.isEmpty();
        this.cells.clear();
        IndexedCell indexedCell = (IndexedCell)this.getSkinnable();
        int n = indexedCell.getIndex();
        ObservableList<TableColumnBase> observableList = this.getVisibleLeafColumns();
        int n2 = observableList.size();
        for (int i = 0; i < n2; ++i) {
            TableColumnBase tableColumnBase = (TableColumnBase)observableList.get(i);
            IndexedCell<Object> indexedCell2 = (IndexedCell)this.cellsMap.get(tableColumnBase);
            if (indexedCell2 == null) {
                indexedCell2 = this.createCell(tableColumnBase);
            }
            this.updateCell(indexedCell2, indexedCell);
            indexedCell2.updateIndex(n);
            this.cells.add(indexedCell2);
            if (!bl) continue;
            indexedCell2.impl_processCSS(false);
        }
        if (!this.fixedCellSizeEnabled && (bl || bl2)) {
            this.getChildren().setAll((Collection<Node>)this.cells);
        }
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        double d6 = 0.0;
        ObservableList<TableColumnBase> observableList = this.getVisibleLeafColumns();
        int n = observableList.size();
        for (int i = 0; i < n; ++i) {
            d6 += ((TableColumnBase)observableList.get(i)).getWidth();
        }
        return d6;
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        this.checkState(false);
        if (this.getCellSize() < 24.0) {
            return this.getCellSize();
        }
        double d6 = 0.0;
        int n = this.cells.size();
        for (int i = 0; i < n; ++i) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i);
            d6 = Math.max(d6, indexedCell.prefHeight(-1.0));
        }
        double d7 = Math.max(d6, Math.max(this.getCellSize(), ((IndexedCell)this.getSkinnable()).minHeight(-1.0)));
        return d7;
    }

    @Override
    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        this.checkState(false);
        if (this.getCellSize() < 24.0) {
            return this.getCellSize();
        }
        double d6 = 0.0;
        int n = this.cells.size();
        for (int i = 0; i < n; ++i) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i);
            d6 = Math.max(d6, indexedCell.minHeight(-1.0));
        }
        return d6;
    }

    @Override
    protected double computeMaxHeight(double d, double d2, double d3, double d4, double d5) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        return super.computeMaxHeight(d, d2, d3, d4, d5);
    }

    protected final void checkState(boolean bl) {
        if (this.isDirty) {
            if (bl) {
                this.recreateCells();
            }
            this.updateCells(true);
            this.isDirty = false;
        } else if (this.updateCells) {
            this.updateCells(false);
            this.updateCells = false;
        }
    }

    private void recreateCells() {
        Collection collection;
        if (this.cellsMap != null) {
            collection = this.cellsMap.values();
            for (IndexedCell eventTarget : collection) {
                eventTarget.updateIndex(-1);
                eventTarget.getSkin().dispose();
            }
            this.cellsMap.clear();
        }
        if ((collection = this.getVisibleLeafColumns()).size() != this.columnCount || this.fullRefreshCounter == 0 || this.cellsMap == null) {
            this.cellsMap = new WeakHashMap(collection.size());
            this.fullRefreshCounter = 100;
            this.getChildren().clear();
        }
        this.columnCount = collection.size();
        --this.fullRefreshCounter;
        for (TableColumnBase tableColumnBase : collection) {
            if (this.cellsMap.containsKey(tableColumnBase)) continue;
            this.createCell(tableColumnBase);
        }
    }

    private R createCell(TableColumnBase tableColumnBase) {
        R r = this.getCell(tableColumnBase);
        this.cellsMap.put(tableColumnBase, r);
        return r;
    }

    private void fadeOut(Node node) {
        if (node.getOpacity() < 1.0) {
            return;
        }
        if (!DO_ANIMATIONS) {
            node.setOpacity(0.0);
            return;
        }
        FadeTransition fadeTransition = new FadeTransition(FADE_DURATION, node);
        fadeTransition.setToValue(0.0);
        fadeTransition.play();
    }

    private void fadeIn(Node node) {
        if (node.getOpacity() > 0.0) {
            return;
        }
        if (!DO_ANIMATIONS) {
            node.setOpacity(1.0);
            return;
        }
        FadeTransition fadeTransition = new FadeTransition(FADE_DURATION, node);
        fadeTransition.setToValue(1.0);
        fadeTransition.play();
    }
}

