/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.javafx.embed.EmbeddedSceneDSInterface;
import com.sun.javafx.embed.EmbeddedSceneDTInterface;
import com.sun.javafx.tk.quantum.EmbeddedSceneDnD;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import java.util.concurrent.Callable;
import javafx.scene.input.TransferMode;

final class EmbeddedSceneDT
implements EmbeddedSceneDTInterface {
    private final EmbeddedSceneDnD dnd;
    private final GlassSceneDnDEventHandler dndHandler;
    private EmbeddedSceneDSInterface dragSource;
    private ClipboardAssistance assistant;

    public EmbeddedSceneDT(EmbeddedSceneDnD embeddedSceneDnD, GlassSceneDnDEventHandler glassSceneDnDEventHandler) {
        this.dnd = embeddedSceneDnD;
        this.dndHandler = glassSceneDnDEventHandler;
    }

    private void close() {
        this.dnd.onDropTargetReleased(this);
        this.assistant = null;
    }

    @Override
    public TransferMode handleDragEnter(final int n, final int n2, final int n3, final int n4, final TransferMode transferMode, final EmbeddedSceneDSInterface embeddedSceneDSInterface) {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(new Callable<TransferMode>(){

            @Override
            public TransferMode call() {
                assert (EmbeddedSceneDT.this.dragSource == null);
                assert (EmbeddedSceneDT.this.assistant == null);
                EmbeddedSceneDT.this.dragSource = embeddedSceneDSInterface;
                EmbeddedSceneDT.this.assistant = new EmbeddedDTAssistant(EmbeddedSceneDT.this.dragSource);
                return EmbeddedSceneDT.this.dndHandler.handleDragEnter(n, n2, n3, n4, transferMode, EmbeddedSceneDT.this.assistant);
            }
        });
    }

    @Override
    public void handleDragLeave() {
        assert (this.dnd.isHostThread());
        this.dnd.executeOnFXThread(new Callable<Void>(){

            @Override
            public Void call() {
                assert (EmbeddedSceneDT.this.assistant != null);
                try {
                    EmbeddedSceneDT.this.dndHandler.handleDragLeave(EmbeddedSceneDT.this.assistant);
                }
                finally {
                    EmbeddedSceneDT.this.close();
                }
                return null;
            }
        });
    }

    @Override
    public TransferMode handleDragDrop(final int n, final int n2, final int n3, final int n4, final TransferMode transferMode) {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(new Callable<TransferMode>(){

            @Override
            public TransferMode call() {
                assert (EmbeddedSceneDT.this.assistant != null);
                try {
                    TransferMode transferMode2 = EmbeddedSceneDT.this.dndHandler.handleDragDrop(n, n2, n3, n4, transferMode, EmbeddedSceneDT.this.assistant);
                    return transferMode2;
                }
                finally {
                    EmbeddedSceneDT.this.close();
                }
            }
        });
    }

    @Override
    public TransferMode handleDragOver(final int n, final int n2, final int n3, final int n4, final TransferMode transferMode) {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(new Callable<TransferMode>(){

            @Override
            public TransferMode call() {
                assert (EmbeddedSceneDT.this.assistant != null);
                return EmbeddedSceneDT.this.dndHandler.handleDragOver(n, n2, n3, n4, transferMode, EmbeddedSceneDT.this.assistant);
            }
        });
    }

    private static class EmbeddedDTAssistant
    extends ClipboardAssistance {
        private EmbeddedSceneDSInterface dragSource;

        EmbeddedDTAssistant(EmbeddedSceneDSInterface embeddedSceneDSInterface) {
            super("DND-Embedded");
            this.dragSource = embeddedSceneDSInterface;
        }

        @Override
        public void flush() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getData(String string) {
            return this.dragSource.getData(string);
        }

        @Override
        public int getSupportedSourceActions() {
            return QuantumClipboard.transferModesToClipboardActions(this.dragSource.getSupportedActions());
        }

        @Override
        public void setTargetAction(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getMimeTypes() {
            return this.dragSource.getMimeTypes();
        }
    }
}

