/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.scene.input.KeyCodeMap;
import com.sun.javafx.tk.quantum.GestureRecognizers;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.SwipeGestureRecognizer;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.TouchPoint;
import javafx.scene.input.TransferMode;
import javafx.scene.input.ZoomEvent;

class GlassViewEventHandler
extends View.EventHandler {
    private ViewScene scene;
    private final GlassSceneDnDEventHandler dndHandler;
    private final GestureRecognizers gestures;
    private final PaintCollector collector = PaintCollector.getInstance();
    private final KeyEventNotification keyNotification = new KeyEventNotification();
    private int mouseButtonPressedMask = 0;
    private final MouseEventNotification mouseNotification = new MouseEventNotification();
    private static final byte ATTR_INPUT = 0;
    private static final byte ATTR_TARGET_CONVERTED = 1;
    private static final byte ATTR_CONVERTED = 2;
    private static final byte ATTR_TARGET_NOTCONVERTED = 3;
    private static final byte ATTR_INPUT_ERROR = 4;
    private ClipboardAssistance dropSourceAssistant;
    private final ViewEventNotification viewNotification = new ViewEventNotification();

    public GlassViewEventHandler(ViewScene viewScene) {
        this.scene = viewScene;
        this.dndHandler = new GlassSceneDnDEventHandler(viewScene);
        this.gestures = new GestureRecognizers();
        if (PlatformUtil.isWindows() || PlatformUtil.isIOS() || PlatformUtil.isEmbedded()) {
            this.gestures.add(new SwipeGestureRecognizer(viewScene));
        }
    }

    private static boolean allowableFullScreenKeys(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    private boolean checkFullScreenKeyEvent(int n, int n2, char[] cArray, int n3) {
        return this.scene.getWindowStage().isTrustedFullScreen() || GlassViewEventHandler.allowableFullScreenKeys(n2);
    }

    private static EventType<KeyEvent> keyEventType(int n) {
        switch (n) {
            case 111: {
                return KeyEvent.KEY_PRESSED;
            }
            case 112: {
                return KeyEvent.KEY_RELEASED;
            }
            case 113: {
                return KeyEvent.KEY_TYPED;
            }
        }
        if (QuantumToolkit.verbose) {
            System.err.println("Unknown Glass key event type: " + n);
        }
        return null;
    }

    @Override
    public void handleKeyEvent(View view, long l, int n, int n2, char[] cArray, int n3) {
        this.keyNotification.view = view;
        this.keyNotification.time = l;
        this.keyNotification.type = n;
        this.keyNotification.key = n2;
        this.keyNotification.chars = cArray;
        this.keyNotification.modifiers = n3;
        AccessController.doPrivileged(this.keyNotification, this.scene.getAccessControlContext());
    }

    private static EventType<MouseEvent> mouseEventType(int n) {
        switch (n) {
            case 221: {
                return MouseEvent.MOUSE_PRESSED;
            }
            case 222: {
                return MouseEvent.MOUSE_RELEASED;
            }
            case 225: {
                return MouseEvent.MOUSE_ENTERED;
            }
            case 226: {
                return MouseEvent.MOUSE_EXITED;
            }
            case 224: {
                return MouseEvent.MOUSE_MOVED;
            }
            case 223: {
                return MouseEvent.MOUSE_DRAGGED;
            }
            case 228: {
                throw new IllegalArgumentException("WHEEL event cannot be translated to MouseEvent, must be translated to ScrollEvent");
            }
        }
        if (QuantumToolkit.verbose) {
            System.err.println("Unknown Glass mouse event type: " + n);
        }
        return null;
    }

    private static MouseButton mouseEventButton(int n) {
        switch (n) {
            case 212: {
                return MouseButton.PRIMARY;
            }
            case 213: {
                return MouseButton.SECONDARY;
            }
            case 214: {
                return MouseButton.MIDDLE;
            }
        }
        return MouseButton.NONE;
    }

    @Override
    public void handleMouseEvent(View view, long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        this.mouseNotification.view = view;
        this.mouseNotification.time = l;
        this.mouseNotification.type = n;
        this.mouseNotification.button = n2;
        this.mouseNotification.x = n3;
        this.mouseNotification.y = n4;
        this.mouseNotification.xAbs = n5;
        this.mouseNotification.yAbs = n6;
        this.mouseNotification.modifiers = n7;
        this.mouseNotification.isPopupTrigger = bl;
        this.mouseNotification.isSynthesized = bl2;
        AccessController.doPrivileged(this.mouseNotification, this.scene.getAccessControlContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMenuEvent(View view, final int n, final int n2, final int n3, final int n4, final boolean bl) {
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.menuEvent(n, n2, n3, n4, bl);
                    }
                    return null;
                }
            }, this.scene.getAccessControlContext());
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleScrollEvent(View view, long l, final int n, final int n2, final int n3, final int n4, final double d, final double d2, final int n5, final int n6, final int n7, final int n8, final int n9, final double d3, final double d4) {
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.scrollEvent(ScrollEvent.SCROLL, d, d2, 0.0, 0.0, d3, d4, 0, n7, n6, n9, n8, n, n2, n3, n4, (n5 & 1) != 0, (n5 & 4) != 0, (n5 & 8) != 0, (n5 & 0x10) != 0, false, false);
                    }
                    return null;
                }
            }, this.scene.getAccessControlContext());
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
    }

    private static byte inputMethodEventAttrValue(int n, int[] nArray, byte[] byArray) {
        if (nArray != null) {
            for (int i = 0; i < nArray.length - 1; ++i) {
                if (n < nArray[i] || n >= nArray[i + 1]) continue;
                return byArray[i];
            }
        }
        return 4;
    }

    private static ObservableList<InputMethodTextRun> inputMethodEventComposed(String string, int n, int[] nArray, int[] nArray2, byte[] byArray) {
        TrackableObservableList<InputMethodTextRun> trackableObservableList = new TrackableObservableList<InputMethodTextRun>(){

            @Override
            protected void onChanged(ListChangeListener.Change<InputMethodTextRun> change) {
            }
        };
        if (n < string.length()) {
            if (nArray == null) {
                trackableObservableList.add(new InputMethodTextRun(string.substring(n), InputMethodHighlight.UNSELECTED_RAW));
            } else {
                for (int i = 0; i < nArray.length - 1; ++i) {
                    InputMethodHighlight inputMethodHighlight;
                    if (nArray[i] < n) continue;
                    switch (GlassViewEventHandler.inputMethodEventAttrValue(nArray[i], nArray2, byArray)) {
                        case 1: {
                            inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED;
                            break;
                        }
                        case 2: {
                            inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED;
                            break;
                        }
                        case 3: {
                            inputMethodHighlight = InputMethodHighlight.SELECTED_RAW;
                            break;
                        }
                        default: {
                            inputMethodHighlight = InputMethodHighlight.UNSELECTED_RAW;
                        }
                    }
                    trackableObservableList.add(new InputMethodTextRun(string.substring(nArray[i], nArray[i + 1]), inputMethodHighlight));
                }
            }
        }
        return trackableObservableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInputMethodEvent(long l, final String string, final int[] nArray, final int[] nArray2, final byte[] byArray, final int n, final int n2) {
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        String string3 = string != null ? string : "";
                        EventType<InputMethodEvent> eventType = InputMethodEvent.INPUT_METHOD_TEXT_CHANGED;
                        ObservableList observableList = GlassViewEventHandler.inputMethodEventComposed(string3, n, nArray, nArray2, byArray);
                        String string2 = string3.substring(0, n);
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.inputMethodEvent(eventType, observableList, string2, n2);
                    }
                    return null;
                }
            }, this.scene.getAccessControlContext());
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
    }

    @Override
    public double[] getInputMethodCandidatePos(int n) {
        Point2D point2D = this.scene.inputMethodRequests.getTextLocation(n);
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        return dArray;
    }

    private static TransferMode actionToTransferMode(int n) {
        if (n == 0) {
            return null;
        }
        if (n == 1 || n == 0x40000001) {
            return TransferMode.COPY;
        }
        if (n == 2 || n == 0x40000002) {
            return TransferMode.MOVE;
        }
        if (n == 0x40000000) {
            return TransferMode.LINK;
        }
        if (n == 3) {
            if (QuantumToolkit.verbose) {
                System.err.println("Ambiguous drop action: " + Integer.toHexString(n));
            }
        } else if (QuantumToolkit.verbose) {
            System.err.println("Unknown drop action: " + Integer.toHexString(n));
        }
        return null;
    }

    private static int transferModeToAction(TransferMode transferMode) {
        if (transferMode == null) {
            return 0;
        }
        switch (transferMode) {
            case COPY: {
                return 1;
            }
            case MOVE: {
                return 2;
            }
            case LINK: {
                return 0x40000000;
            }
        }
        return 0;
    }

    @Override
    public int handleDragEnter(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        TransferMode transferMode = this.dndHandler.handleDragEnter(n, n2, n3, n4, GlassViewEventHandler.actionToTransferMode(n5), clipboardAssistance);
        return GlassViewEventHandler.transferModeToAction(transferMode);
    }

    @Override
    public void handleDragLeave(View view, ClipboardAssistance clipboardAssistance) {
        this.dndHandler.handleDragLeave(clipboardAssistance);
    }

    @Override
    public int handleDragDrop(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        TransferMode transferMode = this.dndHandler.handleDragDrop(n, n2, n3, n4, GlassViewEventHandler.actionToTransferMode(n5), clipboardAssistance);
        return GlassViewEventHandler.transferModeToAction(transferMode);
    }

    @Override
    public int handleDragOver(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        TransferMode transferMode = this.dndHandler.handleDragOver(n, n2, n3, n4, GlassViewEventHandler.actionToTransferMode(n5), clipboardAssistance);
        return GlassViewEventHandler.transferModeToAction(transferMode);
    }

    @Override
    public void handleDragStart(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        this.dropSourceAssistant = clipboardAssistance;
        this.dndHandler.handleDragStart(n, n2, n3, n4, n5, clipboardAssistance);
    }

    @Override
    public void handleDragEnd(View view, int n) {
        this.dndHandler.handleDragEnd(GlassViewEventHandler.actionToTransferMode(n), this.dropSourceAssistant);
    }

    @Override
    public void handleViewEvent(View view, long l, int n) {
        this.viewNotification.view = view;
        this.viewNotification.time = l;
        this.viewNotification.type = n;
        AccessController.doPrivileged(this.viewNotification, this.scene.getAccessControlContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleScrollGestureEvent(View view, long l, final int n, final int n2, final boolean bl, final boolean bl2, final int n3, final int n4, final int n5, final int n6, final int n7, final double d, final double d2, final double d3, final double d4, final double d5, final double d6) {
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        EventType<ScrollEvent> eventType;
                        switch (n) {
                            case 1: {
                                eventType = ScrollEvent.SCROLL_STARTED;
                                break;
                            }
                            case 2: {
                                eventType = ScrollEvent.SCROLL;
                                break;
                            }
                            case 3: {
                                eventType = ScrollEvent.SCROLL_FINISHED;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown scroll event type: " + n);
                            }
                        }
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.scrollEvent(eventType, d, d2, d3, d4, d5, d6, n3, 0, 0, 0, 0, n4 == Integer.MAX_VALUE ? Double.NaN : (double)n4, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6, n7 == Integer.MAX_VALUE ? Double.NaN : (double)n7, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0, bl, bl2);
                    }
                    return null;
                }
            }, this.scene.getAccessControlContext());
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleZoomGestureEvent(View view, long l, final int n, final int n2, final boolean bl, final boolean bl2, final int n3, final int n4, final int n5, final int n6, final double d, double d2, final double d3, double d4) {
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        EventType<ZoomEvent> eventType;
                        switch (n) {
                            case 1: {
                                eventType = ZoomEvent.ZOOM_STARTED;
                                break;
                            }
                            case 2: {
                                eventType = ZoomEvent.ZOOM;
                                break;
                            }
                            case 3: {
                                eventType = ZoomEvent.ZOOM_FINISHED;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown scroll event type: " + n);
                            }
                        }
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.zoomEvent(eventType, d, d3, n3 == Integer.MAX_VALUE ? Double.NaN : (double)n3, n4 == Integer.MAX_VALUE ? Double.NaN : (double)n4, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0, bl, bl2);
                    }
                    return null;
                }
            }, this.scene.getAccessControlContext());
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRotateGestureEvent(View view, long l, final int n, final int n2, final boolean bl, final boolean bl2, final int n3, final int n4, final int n5, final int n6, final double d, final double d2) {
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        EventType<RotateEvent> eventType;
                        switch (n) {
                            case 1: {
                                eventType = RotateEvent.ROTATION_STARTED;
                                break;
                            }
                            case 2: {
                                eventType = RotateEvent.ROTATE;
                                break;
                            }
                            case 3: {
                                eventType = RotateEvent.ROTATION_FINISHED;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown scroll event type: " + n);
                            }
                        }
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.rotateEvent(eventType, d, d2, n3 == Integer.MAX_VALUE ? Double.NaN : (double)n3, n4 == Integer.MAX_VALUE ? Double.NaN : (double)n4, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0, bl, bl2);
                    }
                    return null;
                }
            }, this.scene.getAccessControlContext());
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSwipeGestureEvent(View view, long l, int n, final int n2, final boolean bl, boolean bl2, final int n3, final int n4, final int n5, final int n6, final int n7, final int n8) {
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        EventType<SwipeEvent> eventType;
                        switch (n4) {
                            case 1: {
                                eventType = SwipeEvent.SWIPE_UP;
                                break;
                            }
                            case 2: {
                                eventType = SwipeEvent.SWIPE_DOWN;
                                break;
                            }
                            case 3: {
                                eventType = SwipeEvent.SWIPE_LEFT;
                                break;
                            }
                            case 4: {
                                eventType = SwipeEvent.SWIPE_RIGHT;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown swipe event direction: " + n4);
                            }
                        }
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.swipeEvent(eventType, n3, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6, n7 == Integer.MAX_VALUE ? Double.NaN : (double)n7, n8 == Integer.MAX_VALUE ? Double.NaN : (double)n8, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0, bl);
                    }
                    return null;
                }
            }, this.scene.getAccessControlContext());
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBeginTouchEvent(View view, final long l, final int n, final boolean bl, final int n2) {
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.touchEventBegin(l, n2, bl, (n & 1) != 0, (n & 4) != 0, (n & 8) != 0, (n & 0x10) != 0);
                    }
                    return null;
                }
            }, this.scene.getAccessControlContext());
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
        this.gestures.notifyBeginTouchEvent(l, n, bl, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNextTouchEvent(View view, long l, final int n, final long l2, final int n2, final int n3, final int n4, final int n5) {
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        TouchPoint.State state;
                        switch (n) {
                            case 811: {
                                state = TouchPoint.State.PRESSED;
                                break;
                            }
                            case 812: {
                                state = TouchPoint.State.MOVED;
                                break;
                            }
                            case 814: {
                                state = TouchPoint.State.STATIONARY;
                                break;
                            }
                            case 813: {
                                state = TouchPoint.State.RELEASED;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown touch state: " + n);
                            }
                        }
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.touchEventNext(state, l2, n2, n3, n4, n5);
                    }
                    return null;
                }
            }, this.scene.getAccessControlContext());
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
        this.gestures.notifyNextTouchEvent(l, n, l2, n2, n3, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEndTouchEvent(View view, long l) {
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                        ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.touchEventEnd();
                    }
                    return null;
                }
            }, this.scene.getAccessControlContext());
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
        this.gestures.notifyEndTouchEvent(l);
    }

    private class ViewEventNotification
    implements PrivilegedAction<Void> {
        View view;
        long time;
        int type;

        private ViewEventNotification() {
        }

        @Override
        public Void run() {
            if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener == null) {
                return null;
            }
            switch (this.type) {
                case 421: {
                    WindowStage windowStage;
                    Window window = this.view.getWindow();
                    if (window != null && window.getMinimumWidth() == this.view.getWidth() && !window.isVisible()) break;
                    if (QuantumToolkit.drawInPaint && window != null && window.isVisible() && (windowStage = GlassViewEventHandler.this.scene.getWindowStage()) != null && !windowStage.isApplet()) {
                        GlassViewEventHandler.this.collector.liveRepaintRenderJob(GlassViewEventHandler.this.scene);
                    }
                    GlassViewEventHandler.this.scene.entireSceneNeedsRepaint();
                    break;
                }
                case 422: {
                    WindowStage windowStage;
                    Window window = this.view.getWindow();
                    ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.changedSize(this.view.getWidth(), this.view.getHeight());
                    GlassViewEventHandler.this.scene.entireSceneNeedsRepaint();
                    ViewPainter.renderLock.lock();
                    try {
                        GlassViewEventHandler.this.scene.updateSceneState();
                    }
                    finally {
                        ViewPainter.renderLock.unlock();
                    }
                    if (!QuantumToolkit.liveResize || window == null || !window.isVisible() || (windowStage = GlassViewEventHandler.this.scene.getWindowStage()) == null || windowStage.isApplet()) break;
                    GlassViewEventHandler.this.collector.liveRepaintRenderJob(GlassViewEventHandler.this.scene);
                    break;
                }
                case 423: {
                    ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.changedLocation(this.view.getX(), this.view.getY());
                    break;
                }
                case 431: 
                case 432: {
                    if (GlassViewEventHandler.this.scene.getWindowStage() == null) break;
                    GlassViewEventHandler.this.scene.getWindowStage().fullscreenChanged(this.type == 431);
                    break;
                }
                case 411: 
                case 412: {
                    break;
                }
                default: {
                    throw new RuntimeException("handleViewEvent: unhandled type: " + this.type);
                }
            }
            return null;
        }
    }

    private class MouseEventNotification
    implements PrivilegedAction<Void> {
        View view;
        long time;
        int type;
        int button;
        int x;
        int y;
        int xAbs;
        int yAbs;
        int modifiers;
        boolean isPopupTrigger;
        boolean isSynthesized;

        private MouseEventNotification() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run() {
            int n;
            switch (this.button) {
                case 212: {
                    n = 32;
                    break;
                }
                case 214: {
                    n = 128;
                    break;
                }
                case 213: {
                    n = 64;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            switch (this.type) {
                case 224: {
                    if (this.button == 211) break;
                    return null;
                }
                case 222: {
                    if ((GlassViewEventHandler.this.mouseButtonPressedMask & n) == 0) {
                        return null;
                    }
                    GlassViewEventHandler.this.mouseButtonPressedMask = GlassViewEventHandler.this.mouseButtonPressedMask & ~n;
                    break;
                }
                case 221: {
                    GlassViewEventHandler.this.mouseButtonPressedMask = GlassViewEventHandler.this.mouseButtonPressedMask | n;
                    break;
                }
                case 225: 
                case 226: {
                    break;
                }
                case 227: {
                    return null;
                }
                default: {
                    if (!QuantumToolkit.verbose) break;
                    System.out.println("handleMouseEvent: unhandled type: " + this.type);
                }
            }
            WindowStage windowStage = GlassViewEventHandler.this.scene.getWindowStage();
            try {
                if (windowStage != null) {
                    windowStage.setInEventHandler(true);
                }
                if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener != null) {
                    boolean bl = (this.modifiers & 1) != 0;
                    boolean bl2 = (this.modifiers & 4) != 0;
                    boolean bl3 = (this.modifiers & 8) != 0;
                    boolean bl4 = (this.modifiers & 0x10) != 0;
                    boolean bl5 = (this.modifiers & 0x20) != 0;
                    boolean bl6 = (this.modifiers & 0x80) != 0;
                    boolean bl7 = (this.modifiers & 0x40) != 0;
                    ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.mouseEvent(GlassViewEventHandler.mouseEventType(this.type), this.x, this.y, this.xAbs, this.yAbs, GlassViewEventHandler.mouseEventButton(this.button), this.isPopupTrigger, this.isSynthesized, bl, bl2, bl3, bl4, bl5, bl6, bl7);
                }
            }
            finally {
                if (windowStage != null) {
                    windowStage.setInEventHandler(false);
                }
            }
            return null;
        }
    }

    private class KeyEventNotification
    implements PrivilegedAction<Void> {
        View view;
        long time;
        int type;
        int key;
        char[] chars;
        int modifiers;

        private KeyEventNotification() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void run() {
            WindowStage windowStage = GlassViewEventHandler.this.scene.getWindowStage();
            try {
                String string;
                if (windowStage != null) {
                    windowStage.setInEventHandler(true);
                }
                boolean bl = (this.modifiers & 1) != 0;
                boolean bl2 = (this.modifiers & 4) != 0;
                boolean bl3 = (this.modifiers & 8) != 0;
                boolean bl4 = (this.modifiers & 0x10) != 0;
                String string2 = string = new String(this.chars);
                KeyEvent keyEvent = new KeyEvent(GlassViewEventHandler.keyEventType(this.type), string, string2, KeyCodeMap.valueOf(this.key), bl, bl2, bl3, bl4);
                switch (this.type) {
                    case 111: {
                        if (this.view.isInFullscreen() && windowStage != null && windowStage.getSavedFullScreenExitKey() != null && windowStage.getSavedFullScreenExitKey().match(keyEvent)) {
                            windowStage.exitFullScreen();
                        }
                    }
                    case 112: 
                    case 113: {
                        if (this.view.isInFullscreen() && !GlassViewEventHandler.this.checkFullScreenKeyEvent(this.type, this.key, this.chars, this.modifiers)) {
                            return null;
                        } else {
                            if (((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener == null) return null;
                            ((GlassViewEventHandler)GlassViewEventHandler.this).scene.sceneListener.keyEvent(keyEvent);
                            return null;
                        }
                    }
                    default: {
                        if (!QuantumToolkit.verbose) return null;
                        System.out.println("handleKeyEvent: unhandled type: " + this.type);
                        return null;
                    }
                }
            }
            finally {
                if (windowStage != null) {
                    windowStage.setInEventHandler(false);
                }
            }
        }
    }
}

