/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.prism.PresentableState;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import java.util.concurrent.atomic.AtomicInteger;

class SceneState
extends PresentableState {
    final GlassScene scene;
    private Color clearColor;
    private Paint currentPaint;
    private NGCamera camera;

    public SceneState(GlassScene glassScene) {
        this.scene = glassScene;
    }

    @Override
    public boolean isAntiAliasing() {
        return this.scene.isAntiAliasing();
    }

    public GlassScene getScene() {
        return this.scene;
    }

    public boolean isValid() {
        return this.getWindow() != null && this.getView() != null && !this.isViewClosed() && this.getWidth() > 0 && this.getHeight() > 0;
    }

    @Override
    public void update() {
        this.view = this.scene.getPlatformView();
        this.clearColor = this.scene.getClearColor();
        this.currentPaint = this.scene.getCurrentPaint();
        super.update();
        this.camera = this.scene.getCamera();
        if (this.camera != null) {
            this.viewWidth = (int)this.camera.getViewWidth();
            this.viewHeight = (int)this.camera.getViewHeight();
        }
    }

    @Override
    public void uploadPixels(final Pixels pixels, final AtomicInteger atomicInteger) {
        Application.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SceneState.this.isValid()) {
                    SceneState.super.uploadPixels(pixels, atomicInteger);
                } else if (atomicInteger != null) {
                    atomicInteger.decrementAndGet();
                }
            }
        });
    }

    Color getClearColor() {
        return this.clearColor;
    }

    Paint getCurrentPaint() {
        return this.currentPaint;
    }

    NGCamera getCamera() {
        return this.camera;
    }
}

