/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.LinearConvolvePeer;
import java.nio.FloatBuffer;

public abstract class LinearConvolveKernel {
    public static final int MAX_KERNEL_SIZE = 128;
    static final float[] BLACK_COMPONENTS = Color4f.BLACK.getPremultipliedRGBComponents();

    public static int getPeerSize(int n) {
        if (n < 32) {
            return n + 3 & 0xFFFFFFFC;
        }
        if (n <= 128) {
            return n + 31 & 0xFFFFFFE0;
        }
        throw new RuntimeException("No peer available for kernel size: " + n);
    }

    public boolean isShadow() {
        return false;
    }

    public abstract int getNumberOfPasses();

    public boolean isNop() {
        return false;
    }

    public boolean isNop(int n) {
        return false;
    }

    public PassType getPassType(int n) {
        return PassType.GENERAL_VECTOR;
    }

    public abstract Rectangle getResultBounds(Rectangle var1, int var2);

    public Rectangle getScaledResultBounds(Rectangle rectangle, int n) {
        return this.getResultBounds(rectangle, n);
    }

    public abstract float[] getVector(Rectangle var1, BaseTransform var2, int var3);

    public abstract int getKernelSize(int var1);

    public int getScaledKernelSize(int n) {
        return this.getKernelSize(n);
    }

    public int getPow2ScaleX() {
        return 0;
    }

    public int getPow2ScaleY() {
        return 0;
    }

    public abstract FloatBuffer getWeights(int var1);

    public int getWeightsArrayLength(int n) {
        int n2 = this.getScaledKernelSize(n);
        int n3 = LinearConvolveKernel.getPeerSize(n2);
        return n3 / 4;
    }

    public float[] getShadowColorComponents(int n) {
        return BLACK_COMPONENTS;
    }

    public EffectPeer getPeer(Renderer renderer, FilterContext filterContext, int n) {
        if (this.isNop(n)) {
            return null;
        }
        int n2 = this.getScaledKernelSize(n);
        int n3 = LinearConvolveKernel.getPeerSize(n2);
        String string = this.isShadow() ? "LinearConvolveShadow" : "LinearConvolve";
        return renderer.getPeerInstance(filterContext, string, n3);
    }

    public Rectangle transform(Rectangle rectangle, int n, int n2) {
        if (rectangle == null || (n | n2) == 0) {
            return rectangle;
        }
        rectangle = new Rectangle(rectangle);
        if (n < 0) {
            n = -n;
            rectangle.width = rectangle.width + (1 << n) - 1 >> n;
            rectangle.x >>= n;
        } else if (n > 0) {
            rectangle.width <<= n;
            rectangle.x <<= n;
        }
        if (n2 < 0) {
            n2 = -n2;
            rectangle.height = rectangle.height + (1 << n2) - 1 >> n2;
            rectangle.y >>= n2;
        } else if (n2 > 0) {
            rectangle.height <<= n2;
            rectangle.y <<= n2;
        }
        return rectangle;
    }

    public ImageData filterImageDatas(Effect effect, FilterContext filterContext, BaseTransform baseTransform, Rectangle rectangle, ImageData ... imageDataArray) {
        int n;
        int n2;
        ImageData imageData = imageDataArray[0];
        imageData.addref();
        if (this.isNop()) {
            return imageData;
        }
        Rectangle rectangle2 = imageDataArray[0].getUntransformedBounds();
        int n3 = rectangle2.width;
        int n4 = rectangle2.height;
        Renderer renderer = Renderer.getRenderer(filterContext, effect, n3, n4);
        EffectPeer effectPeer = this.getPeer(renderer, filterContext, 0);
        EffectPeer effectPeer2 = this.getPeer(renderer, filterContext, 1);
        int n5 = 0;
        int n6 = 0;
        if (effectPeer instanceof LinearConvolvePeer) {
            n5 = ((LinearConvolvePeer)((Object)effectPeer)).getPow2ScaleX(this);
        }
        if (effectPeer2 instanceof LinearConvolvePeer) {
            n6 = ((LinearConvolvePeer)((Object)effectPeer2)).getPow2ScaleY(this);
        }
        Rectangle rectangle3 = rectangle;
        if ((n5 | n6) != 0) {
            if (!(imageData = renderer.transform(filterContext, imageData, n5, n6)).validate(filterContext)) {
                imageData.unref();
                return imageData;
            }
            rectangle3 = this.transform(rectangle, n5, n6);
        }
        if (rectangle3 != null && ((n2 = this.getScaledKernelSize(0) / 2) | (n = this.getScaledKernelSize(1) / 2)) != 0) {
            if (rectangle3 == rectangle) {
                rectangle3 = new Rectangle(rectangle);
            }
            rectangle3.grow(n2, n);
        }
        if (effectPeer != null) {
            effectPeer.setPass(0);
            ImageData imageData2 = effectPeer.filter(effect, baseTransform, rectangle3, imageData);
            imageData.unref();
            imageData = imageData2;
            if (!imageData.validate(filterContext)) {
                imageData.unref();
                return imageData;
            }
        }
        if (effectPeer2 != null) {
            effectPeer2.setPass(1);
            ImageData imageData3 = effectPeer2.filter(effect, baseTransform, rectangle3, imageData);
            imageData.unref();
            imageData = imageData3;
            if (!imageData.validate(filterContext)) {
                imageData.unref();
                return imageData;
            }
        }
        if ((n5 | n6) != 0) {
            imageData = renderer.transform(filterContext, imageData, -n5, -n6);
        }
        return imageData;
    }

    public static enum PassType {
        HORIZONTAL_CENTERED,
        VERTICAL_CENTERED,
        GENERAL_VECTOR;

    }
}

