/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.NGExternalNode;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.stage.FocusUngrabEvent;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingCursors;
import javafx.embed.swing.SwingEvents;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ScrollEvent;
import javafx.scene.text.Font;
import javafx.stage.Window;
import javax.swing.JComponent;
import sun.awt.UngrabEvent;
import sun.swing.JLightweightFrame;
import sun.swing.LightweightContent;

public class SwingNode
extends Node {
    private double width;
    private double height;
    private double prefWidth;
    private double prefHeight;
    private double maxWidth;
    private double maxHeight;
    private double minWidth;
    private double minHeight;
    private volatile JComponent content;
    private volatile JLightweightFrame lwFrame;
    private volatile NGExternalNode peer;
    private final ReentrantLock paintLock = new ReentrantLock();
    private boolean skipBackwardUnrgabNotification;
    private boolean grabbed;
    private List<Runnable> peerRequests = new ArrayList<Runnable>();
    private final InvalidationListener locationListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            SwingNode.this.locateLwFrame();
        }
    };
    private final EventHandler<FocusUngrabEvent> ungrabHandler = new EventHandler<FocusUngrabEvent>(){

        @Override
        public void handle(FocusUngrabEvent focusUngrabEvent) {
            if (!SwingNode.this.skipBackwardUnrgabNotification) {
                AccessController.doPrivileged(new PostEventAction(new UngrabEvent(SwingNode.this.lwFrame)));
            }
        }
    };
    private final ChangeListener<Boolean> windowVisibleListener = new ChangeListener<Boolean>(){

        @Override
        public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
            if (!bl2.booleanValue()) {
                SwingNode.this.disposeLwFrame();
            } else {
                SwingNode.this.setContent(SwingNode.this.content);
            }
        }
    };
    private final ChangeListener<Window> sceneWindowListener = new ChangeListener<Window>(){

        @Override
        public void changed(ObservableValue<? extends Window> observableValue, Window window, Window window2) {
            if (window != null) {
                SwingNode.this.removeWindowListeners(window);
            }
            if (window2 != null) {
                SwingNode.this.addWindowListeners(window2);
            }
        }
    };

    public SwingNode() {
        this.setFocusTraversable(true);
        this.setEventHandler(javafx.scene.input.MouseEvent.ANY, new SwingMouseEventHandler());
        this.setEventHandler(KeyEvent.ANY, new SwingKeyEventHandler());
        this.setEventHandler(ScrollEvent.SCROLL, new SwingScrollEventHandler());
        this.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                SwingNode.this.activateLwFrame(bl2);
            }
        });
        Font.getFamilies();
    }

    public void setContent(final JComponent jComponent) {
        this.content = jComponent;
        SwingFXUtils.runOnEDT(new Runnable(){

            @Override
            public void run() {
                SwingNode.this.setContentImpl(jComponent);
            }
        });
    }

    public JComponent getContent() {
        return this.content;
    }

    private void setContentImpl(JComponent jComponent) {
        if (this.lwFrame != null) {
            this.lwFrame.dispose();
            this.lwFrame = null;
        }
        if (jComponent != null) {
            this.lwFrame = new JLightweightFrame();
            this.lwFrame.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent windowEvent) {
                    SwingFXUtils.runOnFxThread(new Runnable(){

                        @Override
                        public void run() {
                            SwingNode.this.requestFocus();
                        }
                    });
                }

                @Override
                public void windowLostFocus(WindowEvent windowEvent) {
                    SwingFXUtils.runOnFxThread(new Runnable(){

                        @Override
                        public void run() {
                            SwingNode.this.ungrabFocus(true);
                        }
                    });
                }
            });
            this.lwFrame.setContent(new SwingNodeContent(jComponent));
            this.lwFrame.setSize((int)this.width, (int)this.height);
            this.lwFrame.setVisible(true);
            SwingFXUtils.runOnFxThread(new Runnable(){

                @Override
                public void run() {
                    SwingNode.this.locateLwFrame();
                    if (SwingNode.this.focusedProperty().get()) {
                        SwingNode.this.activateLwFrame(true);
                    }
                }
            });
        }
    }

    void setImageBuffer(final int[] nArray, final int n, final int n2, final int n3, final int n4, final int n5) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingNode.this.peer.setImageBuffer(IntBuffer.wrap(nArray), n, n2, n3, n4, n5);
            }
        };
        if (this.peer != null) {
            SwingFXUtils.runOnFxThread(runnable);
        } else {
            this.peerRequests.clear();
            this.peerRequests.add(runnable);
        }
    }

    void setImageBounds(final int n, final int n2, final int n3, final int n4) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingNode.this.peer.setImageBounds(n, n2, n3, n4);
            }
        };
        if (this.peer != null) {
            SwingFXUtils.runOnFxThread(runnable);
        } else {
            this.peerRequests.add(runnable);
        }
    }

    void repaintDirtyRegion(final int n, final int n2, final int n3, final int n4) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingNode.this.peer.repaintDirtyRegion(n, n2, n3, n4);
                SwingNode.this.impl_markDirty(DirtyBits.NODE_CONTENTS);
            }
        };
        if (this.peer != null) {
            SwingFXUtils.runOnFxThread(runnable);
        } else {
            this.peerRequests.add(runnable);
        }
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void resize(final double d, final double d2) {
        super.resize(d, d2);
        if (d != this.width || d2 != this.height) {
            this.width = d;
            this.height = d2;
            this.impl_geomChanged();
            this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            SwingFXUtils.runOnEDT(new Runnable(){

                @Override
                public void run() {
                    if (SwingNode.this.lwFrame != null) {
                        SwingNode.this.lwFrame.setSize((int)d, (int)d2);
                    }
                }
            });
        }
    }

    @Override
    public double prefWidth(double d) {
        return this.prefWidth;
    }

    @Override
    public double prefHeight(double d) {
        return this.prefHeight;
    }

    @Override
    public double maxWidth(double d) {
        return this.maxWidth;
    }

    @Override
    public double maxHeight(double d) {
        return this.maxHeight;
    }

    @Override
    public double minWidth(double d) {
        return this.minWidth;
    }

    @Override
    public double minHeight(double d) {
        return this.minHeight;
    }

    @Override
    protected boolean impl_computeContains(double d, double d2) {
        return true;
    }

    private void removeSceneListeners(Scene scene) {
        Window window = scene.getWindow();
        if (window != null) {
            this.removeWindowListeners(window);
        }
        scene.windowProperty().removeListener(this.sceneWindowListener);
    }

    private void addSceneListeners(Scene scene) {
        Window window = scene.getWindow();
        if (window != null) {
            this.addWindowListeners(window);
        }
        scene.windowProperty().addListener(this.sceneWindowListener);
    }

    private void addWindowListeners(Window window) {
        window.xProperty().addListener(this.locationListener);
        window.yProperty().addListener(this.locationListener);
        window.addEventHandler(FocusUngrabEvent.FOCUS_UNGRAB, this.ungrabHandler);
        window.showingProperty().addListener(this.windowVisibleListener);
    }

    private void removeWindowListeners(Window window) {
        window.xProperty().removeListener(this.locationListener);
        window.yProperty().removeListener(this.locationListener);
        window.removeEventHandler(FocusUngrabEvent.FOCUS_UNGRAB, this.ungrabHandler);
        window.showingProperty().removeListener(this.windowVisibleListener);
    }

    @Override
    protected NGNode impl_createPeer() {
        this.peer = new NGExternalNode();
        this.peer.setLock(this.paintLock);
        for (Runnable runnable : this.peerRequests) {
            runnable.run();
        }
        this.peerRequests = null;
        if (this.getScene() != null) {
            this.addSceneListeners(this.getScene());
        }
        this.sceneProperty().addListener(new ChangeListener<Scene>(){

            @Override
            public void changed(ObservableValue<? extends Scene> observableValue, Scene scene, Scene scene2) {
                if (scene != null) {
                    SwingNode.this.removeSceneListeners(scene);
                    SwingNode.this.disposeLwFrame();
                }
                if (scene2 != null) {
                    if (SwingNode.this.content != null && SwingNode.this.lwFrame == null) {
                        SwingNode.this.setContent(SwingNode.this.content);
                    }
                    SwingNode.this.addSceneListeners(scene2);
                }
            }
        });
        this.impl_treeVisibleProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                SwingNode.this.setLwFrameVisible(bl2);
            }
        });
        return this.peer;
    }

    @Override
    public void impl_updatePeer() {
        super.impl_updatePeer();
        if (this.impl_isDirty(DirtyBits.NODE_VISIBLE) || this.impl_isDirty(DirtyBits.NODE_BOUNDS)) {
            this.locateLwFrame();
        }
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            this.peer.markContentDirty();
        }
    }

    private void locateLwFrame() {
        if (this.getScene() == null || this.lwFrame == null || this.getScene().getWindow() == null || !this.getScene().getWindow().isShowing()) {
            return;
        }
        final Point2D point2D = this.localToScene(0.0, 0.0);
        final int n = (int)this.getScene().getWindow().getX();
        final int n2 = (int)this.getScene().getWindow().getY();
        final int n3 = (int)this.getScene().getX();
        final int n4 = (int)this.getScene().getY();
        SwingFXUtils.runOnEDT(new Runnable(){

            @Override
            public void run() {
                if (SwingNode.this.lwFrame != null) {
                    SwingNode.this.lwFrame.setLocation(n + n3 + (int)point2D.getX(), n2 + n4 + (int)point2D.getY());
                }
            }
        });
    }

    private void activateLwFrame(final boolean bl) {
        if (this.lwFrame == null) {
            return;
        }
        SwingFXUtils.runOnEDT(new Runnable(){

            @Override
            public void run() {
                if (SwingNode.this.lwFrame != null) {
                    SwingNode.this.lwFrame.emulateActivation(bl);
                }
            }
        });
    }

    private void disposeLwFrame() {
        if (this.lwFrame == null) {
            return;
        }
        SwingFXUtils.runOnEDT(new Runnable(){

            @Override
            public void run() {
                if (SwingNode.this.lwFrame != null) {
                    SwingNode.this.lwFrame.dispose();
                    SwingNode.this.lwFrame = null;
                }
            }
        });
    }

    private void setLwFrameVisible(final boolean bl) {
        if (this.lwFrame == null) {
            return;
        }
        SwingFXUtils.runOnEDT(new Runnable(){

            @Override
            public void run() {
                if (SwingNode.this.lwFrame != null) {
                    SwingNode.this.lwFrame.setVisible(bl);
                }
            }
        });
    }

    @Override
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        baseBounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, (float)this.width, (float)this.height, 0.0f);
        baseTransform.transform(baseBounds, baseBounds);
        return baseBounds;
    }

    @Override
    public Object impl_processMXNode(MXNodeAlgorithm mXNodeAlgorithm, MXNodeAlgorithmContext mXNodeAlgorithmContext) {
        return mXNodeAlgorithm.processLeafNode(this, mXNodeAlgorithmContext);
    }

    private void ungrabFocus(boolean bl) {
        if (this.grabbed && this.getScene() != null && this.getScene().getWindow() != null && this.getScene().getWindow().impl_getPeer() != null) {
            this.skipBackwardUnrgabNotification = !bl;
            this.getScene().getWindow().impl_getPeer().ungrabFocus();
            this.skipBackwardUnrgabNotification = false;
            this.grabbed = false;
        }
    }

    private class SwingKeyEventHandler
    implements EventHandler<KeyEvent> {
        private SwingKeyEventHandler() {
        }

        @Override
        public void handle(KeyEvent keyEvent) {
            String string;
            int n;
            JLightweightFrame jLightweightFrame = SwingNode.this.lwFrame;
            if (jLightweightFrame == null) {
                return;
            }
            if (keyEvent.getCharacter().isEmpty()) {
                return;
            }
            if (keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.RIGHT || keyEvent.getCode() == KeyCode.TAB) {
                keyEvent.consume();
            }
            if ((n = SwingEvents.fxKeyEventTypeToKeyID(keyEvent)) < 0) {
                return;
            }
            int n2 = SwingEvents.fxKeyModsToKeyMods(keyEvent);
            int n3 = keyEvent.getCode().impl_getCode();
            char c = keyEvent.getCharacter().charAt(0);
            if (keyEvent.getEventType() == KeyEvent.KEY_PRESSED && (string = keyEvent.getText()).length() == 1) {
                c = string.charAt(0);
            }
            long l = System.currentTimeMillis();
            java.awt.event.KeyEvent keyEvent2 = new java.awt.event.KeyEvent(jLightweightFrame, n, l, n2, n3, c);
            AccessController.doPrivileged(new PostEventAction(keyEvent2));
        }
    }

    private class SwingScrollEventHandler
    implements EventHandler<ScrollEvent> {
        private SwingScrollEventHandler() {
        }

        @Override
        public void handle(ScrollEvent scrollEvent) {
            double d;
            boolean bl;
            JLightweightFrame jLightweightFrame = SwingNode.this.lwFrame;
            if (jLightweightFrame == null) {
                return;
            }
            int n = SwingEvents.fxScrollModsToMouseWheelMods(scrollEvent);
            boolean bl2 = bl = (n & 0x40) != 0;
            if (!bl && scrollEvent.getDeltaY() != 0.0) {
                this.sendMouseWheelEvent(jLightweightFrame, (int)scrollEvent.getX(), (int)scrollEvent.getY(), n, scrollEvent.getDeltaY() / scrollEvent.getMultiplierY());
            }
            double d2 = d = bl && scrollEvent.getDeltaY() != 0.0 ? scrollEvent.getDeltaY() / scrollEvent.getMultiplierY() : scrollEvent.getDeltaX() / scrollEvent.getMultiplierX();
            if (d != 0.0) {
                this.sendMouseWheelEvent(jLightweightFrame, (int)scrollEvent.getX(), (int)scrollEvent.getY(), n |= 0x40, d);
            }
        }

        private void sendMouseWheelEvent(Component component, int n, int n2, int n3, double d) {
            int n4 = (int)d;
            int n5 = (int)Math.signum(d);
            if ((double)n5 * d < 1.0) {
                n4 = n5;
            }
            MouseWheelEvent mouseWheelEvent = new MouseWheelEvent(component, 507, System.currentTimeMillis(), n3, n, n2, 0, 0, 0, false, 0, 1, -n4);
            AccessController.doPrivileged(new PostEventAction(mouseWheelEvent));
        }
    }

    private class SwingMouseEventHandler
    implements EventHandler<javafx.scene.input.MouseEvent> {
        private final Set<MouseButton> mouseClickedAllowed = new HashSet<MouseButton>();

        private SwingMouseEventHandler() {
        }

        @Override
        public void handle(javafx.scene.input.MouseEvent mouseEvent) {
            JLightweightFrame jLightweightFrame = SwingNode.this.lwFrame;
            if (jLightweightFrame == null) {
                return;
            }
            int n = SwingEvents.fxMouseEventTypeToMouseID(mouseEvent);
            if (n < 0) {
                return;
            }
            EventType<? extends javafx.scene.input.MouseEvent> eventType = mouseEvent.getEventType();
            if (eventType == javafx.scene.input.MouseEvent.MOUSE_PRESSED) {
                this.mouseClickedAllowed.add(mouseEvent.getButton());
            } else if (eventType != javafx.scene.input.MouseEvent.MOUSE_RELEASED) {
                if (eventType == javafx.scene.input.MouseEvent.MOUSE_DRAGGED) {
                    this.mouseClickedAllowed.clear();
                } else if (eventType == javafx.scene.input.MouseEvent.MOUSE_CLICKED) {
                    if (mouseEvent.getClickCount() == 1 && !this.mouseClickedAllowed.contains((Object)mouseEvent.getButton())) {
                        return;
                    }
                    this.mouseClickedAllowed.remove((Object)mouseEvent.getButton());
                }
            }
            int n2 = SwingEvents.fxMouseModsToMouseMods(mouseEvent);
            boolean bl = mouseEvent.getButton() == MouseButton.SECONDARY;
            int n3 = SwingEvents.fxMouseButtonToMouseButton(mouseEvent);
            long l = System.currentTimeMillis();
            MouseEvent mouseEvent2 = new MouseEvent(jLightweightFrame, n, l, n2, (int)mouseEvent.getX(), (int)mouseEvent.getY(), (int)mouseEvent.getScreenX(), (int)mouseEvent.getSceneY(), mouseEvent.getClickCount(), bl, n3);
            AccessController.doPrivileged(new PostEventAction(mouseEvent2));
        }
    }

    private class PostEventAction
    implements PrivilegedAction<Void> {
        private AWTEvent event;

        public PostEventAction(AWTEvent aWTEvent) {
            this.event = aWTEvent;
        }

        @Override
        public Void run() {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            eventQueue.postEvent(this.event);
            return null;
        }
    }

    private class SwingNodeContent
    implements LightweightContent {
        private JComponent comp;

        public SwingNodeContent(JComponent jComponent) {
            this.comp = jComponent;
        }

        @Override
        public JComponent getComponent() {
            return this.comp;
        }

        @Override
        public void paintLock() {
            SwingNode.this.paintLock.lock();
        }

        @Override
        public void paintUnlock() {
            SwingNode.this.paintLock.unlock();
        }

        @Override
        public void imageBufferReset(int[] nArray, int n, int n2, int n3, int n4, int n5) {
            SwingNode.this.setImageBuffer(nArray, n, n2, n3, n4, n5);
        }

        @Override
        public void imageReshaped(int n, int n2, int n3, int n4) {
            SwingNode.this.setImageBounds(n, n2, n3, n4);
        }

        @Override
        public void imageUpdated(int n, int n2, int n3, int n4) {
            SwingNode.this.repaintDirtyRegion(n, n2, n3, n4);
        }

        @Override
        public void focusGrabbed() {
            SwingFXUtils.runOnFxThread(new Runnable(){

                @Override
                public void run() {
                    if (SwingNode.this.getScene() != null && SwingNode.this.getScene().getWindow() != null && SwingNode.this.getScene().getWindow().impl_getPeer() != null) {
                        SwingNode.this.getScene().getWindow().impl_getPeer().grabFocus();
                        SwingNode.this.grabbed = true;
                    }
                }
            });
        }

        @Override
        public void focusUngrabbed() {
            SwingFXUtils.runOnFxThread(new Runnable(){

                @Override
                public void run() {
                    SwingNode.this.ungrabFocus(false);
                }
            });
        }

        @Override
        public void preferredSizeChanged(final int n, final int n2) {
            SwingFXUtils.runOnFxThread(new Runnable(){

                @Override
                public void run() {
                    SwingNode.this.prefWidth = n;
                    SwingNode.this.prefHeight = n2;
                    SwingNode.this.impl_notifyLayoutBoundsChanged();
                }
            });
        }

        @Override
        public void maximumSizeChanged(final int n, final int n2) {
            SwingFXUtils.runOnFxThread(new Runnable(){

                @Override
                public void run() {
                    SwingNode.this.maxWidth = n;
                    SwingNode.this.maxHeight = n2;
                    SwingNode.this.impl_notifyLayoutBoundsChanged();
                }
            });
        }

        @Override
        public void minimumSizeChanged(final int n, final int n2) {
            SwingFXUtils.runOnFxThread(new Runnable(){

                @Override
                public void run() {
                    SwingNode.this.minWidth = n;
                    SwingNode.this.minHeight = n2;
                    SwingNode.this.impl_notifyLayoutBoundsChanged();
                }
            });
        }

        @Override
        public void setCursor(final Cursor cursor) {
            SwingFXUtils.runOnFxThread(new Runnable(){

                @Override
                public void run() {
                    SwingNode.this.setCursor(SwingCursors.embedCursorToCursor(cursor));
                }
            });
        }
    }
}

