/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package javafx.scene.shape;

/**
 * Defines where to draw the stroke around the boundary of a Shape node.
 *
 * @see Shape
 * @since JavaFX 2.0
 */
public enum StrokeType {

    /**
     * The stroke is applied by extending the boundary of the {@link Shape}
     * node into its interior by a distance specified by the
     * {@link Shape#strokeWidthProperty strokeWidth}.
     *
     * <p>
     * The image shows a shape without stroke and the same shape with a thick
     * inside stroke applied.
     * </p><p>
     * <img src="doc-files/stroketype-inside.png"/>
     * </p>
     */
    INSIDE,

    /**
     * The stroke is applied by extending the boundary of the {@link Shape}
     * node outside of its interior by a distance specified by the
     * {@link Shape#strokeWidthProperty strokeWidth}.
     *
     * <p>
     * The image shows a shape without stroke and the same shape with a thick
     * outside stroke applied.
     * </p><p>
     * <img src="doc-files/stroketype-outside.png"/>
     * </p>
     */
    OUTSIDE,

    /**
     * The stroke is applied by extending the boundary of the {@link Shape}
     * node by a distance of half of the {@link Shape#strokeWidthProperty strokeWidth}
     * on either side (inside and outside) of the boundary.
     *
     * <p>
     * The image shows a shape without stroke and the same shape with a thick
     * centered stroke applied.
     * </p><p>
     * <img src="doc-files/stroketype-centered.png"/>
     * </p>
     */
    CENTERED
}
